/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.repo;

import com.google.common.collect.ListMultimap;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import net.pcal.fastback.config.FastbackConfigKey;
import net.pcal.fastback.config.GitConfig;
import net.pcal.fastback.config.OtherConfigKey;
import net.pcal.fastback.logging.SystemLogger;
import net.pcal.fastback.logging.UserLogger;
import net.pcal.fastback.logging.UserMessage;
import net.pcal.fastback.repo.JGitIncrementalProgressMonitor;
import net.pcal.fastback.repo.JGitPercentageProgressMonitor;
import net.pcal.fastback.repo.PreflightUtils;
import net.pcal.fastback.repo.Repo;
import net.pcal.fastback.repo.RepoImpl;
import net.pcal.fastback.repo.SnapshotId;
import net.pcal.fastback.repo.SnapshotIdUtils;
import net.pcal.fastback.repo.WorldId;
import net.pcal.fastback.utils.ProcessException;
import net.pcal.fastback.utils.ProcessUtils;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.merge.ContentMergeStrategy;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.TrackingRefUpdate;
import org.eclipse.jgit.transport.URIish;

abstract class PushUtils {
    PushUtils() {
    }

    static boolean isTempBranch(String branchName) {
        return branchName.startsWith("temp/");
    }

    static void doPush(SnapshotId sid, RepoImpl repo, UserLogger ulog) throws IOException, ProcessException {
        try {
            GitConfig conf = repo.getConfig();
            String pushUrl = conf.getString(OtherConfigKey.REMOTE_PUSH_URL);
            if (pushUrl == null) {
                SystemLogger.syslog().warn("Skipping remote backup because no remote url has been configured.");
                return;
            }
            Git jgit = repo.getJGit();
            Collection remoteBranchRefs = jgit.lsRemote().setHeads(true).setTags(false).setRemote(conf.getString(FastbackConfigKey.REMOTE_NAME)).call();
            ListMultimap<WorldId, SnapshotId> snapshotsPerWorld = SnapshotIdUtils.getSnapshotsPerWorld(remoteBranchRefs, repo.getSidCodec());
            if (conf.getBoolean(FastbackConfigKey.IS_UUID_CHECK_ENABLED)) {
                boolean uuidCheckResult;
                try {
                    uuidCheckResult = PushUtils.doWorldIdCheck(repo, snapshotsPerWorld.keySet());
                }
                catch (IOException e) {
                    SystemLogger.syslog().error("Unexpected exception thrown during id check", e);
                    uuidCheckResult = false;
                }
                if (!uuidCheckResult) {
                    URIish remoteUri = PushUtils.getRemoteUri(repo.getJGit(), repo.getConfig().getString(FastbackConfigKey.REMOTE_NAME));
                    ulog.message(UserMessage.styledLocalized("fastback.chat.push-id-mismatch", UserMessage.UserMessageStyle.ERROR, remoteUri));
                    SystemLogger.syslog().error("Failing remote backup due to failed id check");
                    throw new IOException();
                }
            }
            SystemLogger.syslog().debug("Pushing to " + pushUrl);
            PreflightUtils.doPreflight(repo);
            if (conf.getBoolean(FastbackConfigKey.IS_NATIVE_GIT_ENABLED)) {
                ulog.message(UserMessage.styledLocalized("fastback.chat.push-started", UserMessage.UserMessageStyle.NATIVE_GIT, pushUrl));
                PushUtils.native_doPush(repo, sid.getBranchName(), ulog);
            } else if (conf.getBoolean(FastbackConfigKey.IS_SMART_PUSH_ENABLED)) {
                ulog.message(UserMessage.styledLocalized("fastback.chat.push-started", UserMessage.UserMessageStyle.NORMAL, pushUrl));
                WorldId uuid = repo.getWorldId();
                PushUtils.jgit_doSmartPush(repo, snapshotsPerWorld.get((Object)uuid), sid.getBranchName(), conf, ulog);
            } else {
                ulog.message(UserMessage.styledLocalized("fastback.chat.push-started", UserMessage.UserMessageStyle.NORMAL, pushUrl));
                PushUtils.jgit_doPush(jgit, sid.getBranchName(), conf, ulog);
            }
            SystemLogger.syslog().info("Remote backup complete.");
        }
        catch (GitAPIException e) {
            throw new IOException(e);
        }
    }

    private static void native_doPush(Repo repo, String branchNameToPush, UserLogger log) throws ProcessException {
        SystemLogger.syslog().debug("Start native_push");
        File worktree = repo.getWorkTree();
        GitConfig conf = repo.getConfig();
        String remoteName = conf.getString(FastbackConfigKey.REMOTE_NAME);
        String[] push = new String[]{"git", "-C", worktree.getAbsolutePath(), "-c", "push.autosetupremote=false", "push", "--progress", "--set-upstream", remoteName, branchNameToPush};
        Map<String, String> env = Map.of("GIT_LFS_FORCE_PROGRESS", "1");
        Consumer<String> outputConsumer = line -> log.update(UserMessage.styledRaw(line, UserMessage.UserMessageStyle.NATIVE_GIT));
        ProcessUtils.doExec(push, env, outputConsumer, outputConsumer);
        SystemLogger.syslog().debug("End native_push");
    }

    private static void jgit_doPush(Git jgit, String branchNameToPush, GitConfig conf, UserLogger ulog) throws GitAPIException {
        JGitIncrementalProgressMonitor pm = new JGitIncrementalProgressMonitor(new JGitPushProgressMonitor(ulog), 100);
        String remoteName = conf.getString(FastbackConfigKey.REMOTE_NAME);
        SystemLogger.syslog().info("Doing simple push of " + branchNameToPush);
        jgit.push().setProgressMonitor((ProgressMonitor)pm).setRemote(remoteName).setRefSpecs(new RefSpec[]{new RefSpec(branchNameToPush + ":" + branchNameToPush)}).call();
    }

    private static void jgit_doSmartPush(RepoImpl repo, List<SnapshotId> remoteSnapshots, String branchNameToPush, GitConfig conf, UserLogger ulog) throws IOException {
        ulog.update(UserMessage.styledLocalized("fastback.chat.push-started", UserMessage.UserMessageStyle.JGIT, new Object[0]));
        try {
            Git jgit = repo.getJGit();
            String remoteName = conf.getString(FastbackConfigKey.REMOTE_NAME);
            WorldId worldUuid = repo.getWorldId();
            if (remoteSnapshots.isEmpty()) {
                SystemLogger.syslog().warn("** This appears to be the first time this world has been pushed.");
                SystemLogger.syslog().warn("** If the world is large, this may take some time.");
                PushUtils.jgit_doPush(jgit, branchNameToPush, conf, ulog);
                return;
            }
            List localBranchRefs = jgit.branchList().call();
            ListMultimap<WorldId, SnapshotId> localSnapshotsPerWorld = SnapshotIdUtils.getSnapshotsPerWorld(localBranchRefs, repo.getSidCodec());
            List localSnapshots = localSnapshotsPerWorld.get((Object)worldUuid);
            remoteSnapshots.retainAll(localSnapshots);
            if (remoteSnapshots.isEmpty()) {
                SystemLogger.syslog().warn("No common snapshots found between local and remote.");
                SystemLogger.syslog().warn("Doing a full push.  This may take some time.");
                PushUtils.jgit_doPush(jgit, branchNameToPush, conf, ulog);
                return;
            }
            Collections.sort(remoteSnapshots);
            SnapshotId latestCommonSnapshot = remoteSnapshots.get(remoteSnapshots.size() - 1);
            SystemLogger.syslog().debug("Using existing snapshot " + latestCommonSnapshot + " for common history");
            String tempBranchName = "temp/" + branchNameToPush;
            SystemLogger.syslog().debug("Creating out temp branch " + tempBranchName);
            jgit.checkout().setCreateBranch(true).setName(tempBranchName).call();
            ObjectId branchId = jgit.getRepository().resolve(latestCommonSnapshot.getBranchName());
            SystemLogger.syslog().debug("Merging " + latestCommonSnapshot.getBranchName());
            jgit.merge().setContentMergeStrategy(ContentMergeStrategy.OURS).include((AnyObjectId)branchId).setMessage("Merge " + branchId + " into " + tempBranchName).call();
            SystemLogger.syslog().debug("Checking out " + branchNameToPush);
            jgit.checkout().setName(branchNameToPush).call();
            SystemLogger.syslog().debug("Pushing temp branch " + tempBranchName);
            JGitIncrementalProgressMonitor pm = new JGitIncrementalProgressMonitor(new JGitPushProgressMonitor(ulog), 100);
            Iterable pushResult = jgit.push().setProgressMonitor((ProgressMonitor)pm).setRemote(remoteName).setRefSpecs(new RefSpec[]{new RefSpec(tempBranchName + ":" + tempBranchName), new RefSpec(branchNameToPush + ":" + branchNameToPush)}).call();
            SystemLogger.syslog().debug("Cleaning up branches...");
            if (conf.getBoolean(FastbackConfigKey.IS_TRACKING_BRANCH_CLEANUP_ENABLED)) {
                for (PushResult pr : pushResult) {
                    for (TrackingRefUpdate f : pr.getTrackingRefUpdates()) {
                        String PREFIX = "refs/remotes/";
                        if (f.getLocalName().startsWith("refs/remotes/")) {
                            String trackingBranchName = f.getLocalName().substring("refs/remotes/".length());
                            SystemLogger.syslog().debug("Cleaning up tracking branch " + trackingBranchName);
                            jgit.branchDelete().setForce(true).setBranchNames(new String[]{trackingBranchName}).call();
                            continue;
                        }
                        SystemLogger.syslog().warn("Ignoring unrecognized TrackingRefUpdate " + f.getLocalName());
                    }
                }
            }
            if (conf.getBoolean(FastbackConfigKey.IS_TEMP_BRANCH_CLEANUP_ENABLED)) {
                SystemLogger.syslog().debug("Deleting local temp branch " + tempBranchName);
                jgit.branchDelete().setForce(true).setBranchNames(new String[]{tempBranchName}).call();
            }
            if (conf.getBoolean(FastbackConfigKey.IS_REMOTE_TEMP_BRANCH_CLEANUP_ENABLED)) {
                String remoteTempBranch = "refs/heads/" + tempBranchName;
                SystemLogger.syslog().debug("Deleting remote temp branch " + remoteTempBranch);
                RefSpec deleteRemoteBranchSpec = new RefSpec().setSource(null).setDestination(remoteTempBranch);
                jgit.push().setProgressMonitor((ProgressMonitor)pm).setRemote(remoteName).setRefSpecs(new RefSpec[]{deleteRemoteBranchSpec}).call();
            }
            SystemLogger.syslog().info("Push complete");
        }
        catch (GitAPIException e) {
            throw new IOException(e);
        }
    }

    private static boolean doWorldIdCheck(RepoImpl repo, Set<WorldId> remoteWorldUuids) throws IOException {
        WorldId localUuid = repo.getWorldId();
        if (remoteWorldUuids.size() > 2) {
            SystemLogger.syslog().warn("Remote has more than one world-id.  This is unusual. " + remoteWorldUuids);
        }
        if (remoteWorldUuids.isEmpty()) {
            SystemLogger.syslog().debug("Remote does not have any previously-backed up worlds.");
        } else if (!remoteWorldUuids.contains(localUuid)) {
            SystemLogger.syslog().debug("local: " + localUuid + ", remote: " + remoteWorldUuids);
            return false;
        }
        SystemLogger.syslog().debug("world-id check passed.");
        return true;
    }

    private static URIish getRemoteUri(Git jgit, String remoteName) throws IOException {
        List remotes;
        Objects.requireNonNull(jgit);
        Objects.requireNonNull(remoteName);
        try {
            remotes = jgit.remoteList().call();
        }
        catch (GitAPIException e) {
            throw new IOException(e);
        }
        for (RemoteConfig remote : remotes) {
            SystemLogger.syslog().debug("getRemoteUri " + remote);
            if (!remote.getName().equals(remoteName)) continue;
            return remote.getPushURIs() != null && !remote.getURIs().isEmpty() ? (URIish)remote.getURIs().get(0) : null;
        }
        return null;
    }

    private static class JGitPushProgressMonitor
    extends JGitPercentageProgressMonitor {
        private final UserLogger ulog;

        public JGitPushProgressMonitor(UserLogger ulog) {
            this.ulog = Objects.requireNonNull(ulog);
        }

        @Override
        public void progressStart(String task) {
            SystemLogger.syslog().debug(task);
        }

        @Override
        public void progressUpdate(String task, int percentage) {
            String msg = task + " " + percentage + "%";
            SystemLogger.syslog().debug(msg);
            this.ulog.update(UserMessage.styledRaw(msg, UserMessage.UserMessageStyle.JGIT));
        }

        @Override
        public void progressDone(String task) {
            String msg = "Done " + task;
            SystemLogger.syslog().debug(msg);
            this.ulog.update(UserMessage.styledRaw(msg, UserMessage.UserMessageStyle.JGIT));
        }

        public void showDuration(boolean enabled) {
        }
    }
}

