/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.repo;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.pcal.fastback.config.FastbackConfigKey;
import net.pcal.fastback.config.GitConfig;
import net.pcal.fastback.logging.SystemLogger;
import net.pcal.fastback.logging.UserLogger;
import net.pcal.fastback.logging.UserMessage;
import net.pcal.fastback.mod.Mod;
import net.pcal.fastback.repo.PreflightUtils;
import net.pcal.fastback.repo.Repo;
import net.pcal.fastback.repo.RepoImpl;
import net.pcal.fastback.repo.SnapshotId;
import net.pcal.fastback.repo.WorldId;
import net.pcal.fastback.utils.EnvironmentUtils;
import net.pcal.fastback.utils.ProcessException;
import net.pcal.fastback.utils.ProcessUtils;
import org.apache.commons.io.FileUtils;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.RmCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;

abstract class CommitUtils {
    CommitUtils() {
    }

    static SnapshotId doCommitSnapshot(RepoImpl repo, UserLogger ulog) throws IOException, ProcessException, GitAPIException {
        PreflightUtils.doPreflight(repo);
        WorldId uuid = repo.getWorldId();
        GitConfig conf = repo.getConfig();
        SnapshotId newSid = repo.getSidCodec().create(uuid);
        SystemLogger.syslog().debug("start doCommitSnapshot for " + newSid);
        CommitUtils.writeBackupProperties(repo);
        if (conf.getBoolean(FastbackConfigKey.IS_MODS_BACKUP_ENABLED)) {
            CommitUtils.doSettingsBackup(repo, ulog);
        }
        String newBranchName = newSid.getBranchName();
        try {
            if (conf.getBoolean(FastbackConfigKey.IS_NATIVE_GIT_ENABLED)) {
                ulog.message(UserMessage.styledLocalized("fastback.chat.commit-start", UserMessage.UserMessageStyle.NATIVE_GIT, newSid.getShortName()));
                CommitUtils.native_commit(newBranchName, repo, ulog);
            } else {
                ulog.message(UserMessage.styledLocalized("fastback.chat.commit-start", UserMessage.UserMessageStyle.NORMAL, newSid.getShortName()));
                CommitUtils.jgit_commit(newBranchName, repo.getJGit(), ulog);
            }
        }
        catch (InterruptedException | GitAPIException e) {
            throw new IOException(e);
        }
        SystemLogger.syslog().debug("Local backup complete.");
        return newSid;
    }

    private static void doSettingsBackup(RepoImpl repo, UserLogger ulog) {
        SystemLogger.syslog().info("Backing up minecraft settings");
        try {
            File backupDir = repo.getDotFasbackDir().resolve("mods-backup").toFile();
            if (backupDir.exists()) {
                FileUtils.deleteDirectory((File)backupDir);
            }
            backupDir.mkdirs();
            for (Path src : Mod.mod().getModsBackupPaths()) {
                try {
                    File srcFile = src.toFile();
                    SystemLogger.syslog().debug("backing up " + srcFile + " to " + backupDir);
                    if (!srcFile.exists()) continue;
                    if (srcFile.isDirectory()) {
                        FileUtils.copyDirectory((File)srcFile, (File)backupDir.toPath().resolve(srcFile.getName()).toFile());
                        continue;
                    }
                    FileUtils.copyFile((File)srcFile, (File)backupDir);
                }
                catch (Exception ohwell) {
                    SystemLogger.syslog().error(ohwell);
                }
            }
        }
        catch (Exception ohwell) {
            SystemLogger.syslog().error(ohwell);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void native_commit(String newBranchName, Repo repo, UserLogger ulog) throws IOException, InterruptedException {
        SystemLogger.syslog().debug("Start native_commit");
        ulog.update(UserMessage.styledLocalized("fastback.hud.local-saving", UserMessage.UserMessageStyle.NATIVE_GIT, new Object[0]));
        File worktree = repo.getWorkTree();
        Map<String, String> env = Map.of("GIT_LFS_FORCE_PROGRESS", "1");
        Consumer<String> outputConsumer = line -> ulog.update(UserMessage.styledRaw(line, UserMessage.UserMessageStyle.NATIVE_GIT));
        String[] checkout = new String[]{"git", "-C", worktree.getAbsolutePath(), "checkout", "--orphan", newBranchName};
        try {
            ProcessUtils.doExec(checkout, env, outputConsumer, outputConsumer);
            Mod.mod().setWorldSaveEnabled(false);
            try {
                String[] add = new String[]{"git", "-C", worktree.getAbsolutePath(), "add", "-v", "."};
                ProcessUtils.doExec(add, env, outputConsumer, outputConsumer);
            }
            finally {
                Mod.mod().setWorldSaveEnabled(true);
                SystemLogger.syslog().debug("World save re-enabled.");
            }
            String[] commit = new String[]{"git", "-C", worktree.getAbsolutePath(), "commit", "-m", newBranchName};
            ProcessUtils.doExec(commit, env, outputConsumer, outputConsumer);
        }
        catch (ProcessException e) {
            SystemLogger.syslog().error(e);
            ulog.message(UserMessage.styledRaw("fastback.chat.commit-failed", UserMessage.UserMessageStyle.ERROR));
            return;
        }
        SystemLogger.syslog().debug("End native_commit");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void jgit_commit(String newBranchName, Git jgit, UserLogger ulog) throws GitAPIException, IOException {
        SystemLogger.syslog().debug("Starting jgit_commit");
        ulog.update(UserMessage.styledLocalized("fastback.hud.local-saving", UserMessage.UserMessageStyle.JGIT, new Object[0]));
        jgit.checkout().setOrphan(true).setName(newBranchName).call();
        jgit.reset().setMode(ResetCommand.ResetType.SOFT).call();
        SystemLogger.syslog().debug("status");
        Status status = jgit.status().call();
        try {
            SystemLogger.syslog().debug("Disabling world save for 'git add'");
            Mod.mod().setWorldSaveEnabled(false);
            ArrayList<String> toAdd = new ArrayList<String>();
            toAdd.add(".fastback");
            toAdd.addAll(status.getModified());
            toAdd.addAll(status.getUntracked());
            Collections.sort(toAdd);
            if (!toAdd.isEmpty()) {
                SystemLogger.syslog().debug("Adding " + toAdd.size() + " new or modified files to index");
                for (String file : toAdd) {
                    AddCommand gitAdd = jgit.add();
                    SystemLogger.syslog().debug("add  " + file);
                    ulog.update(UserMessage.styledRaw("Backing up " + file, UserMessage.UserMessageStyle.JGIT));
                    gitAdd.addFilepattern(file);
                    gitAdd.call();
                }
            }
            ArrayList toDelete = new ArrayList();
            toDelete.addAll(status.getRemoved());
            toDelete.addAll(status.getMissing());
            Collections.sort(toDelete);
            if (!toDelete.isEmpty()) {
                SystemLogger.syslog().debug("Removing " + toDelete.size() + " deleted files from index");
                for (String file : toDelete) {
                    RmCommand gitRm = jgit.rm();
                    SystemLogger.syslog().debug("rm  " + file);
                    ulog.update(UserMessage.styledRaw("Removing " + file, UserMessage.UserMessageStyle.JGIT));
                    gitRm.addFilepattern(file);
                    gitRm.call();
                }
            }
        }
        finally {
            Mod.mod().setWorldSaveEnabled(true);
            SystemLogger.syslog().debug("World save re-enabled.");
        }
        SystemLogger.syslog().debug("commit");
        ulog.update(UserMessage.styledRaw("Commit complete", UserMessage.UserMessageStyle.JGIT));
        jgit.commit().setMessage(newBranchName).call();
    }

    private static void writeBackupProperties(Repo repo) throws IOException {
        HashMap<String, String> props = new HashMap<String, String>();
        GitConfig conf = repo.getConfig();
        props.put("fastback-" + FastbackConfigKey.IS_NATIVE_GIT_ENABLED.getSettingName(), conf.getString(FastbackConfigKey.IS_NATIVE_GIT_ENABLED));
        props.put("git-version", EnvironmentUtils.getGitVersion());
        props.put("git-lfs-version", EnvironmentUtils.getGitLfsVersion());
        try {
            Mod.mod().addBackupProperties(props);
        }
        catch (Exception e) {
            SystemLogger.syslog().error("Failed to add extra backup.properties", e);
        }
        Path path = repo.getWorkTree().toPath().resolve(".fastback/backup.properties");
        ArrayList keys = new ArrayList(props.keySet());
        try (PrintWriter pw = new PrintWriter(new FileWriter(path.toFile()));){
            Collections.sort(keys);
            for (String key : keys) {
                pw.println(key + " = " + (String)props.get(key));
            }
        }
    }
}

