/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.mod.fabric.mixins;

import net.minecraft.server.MinecraftServer;
import net.pcal.fastback.logging.SystemLogger;
import net.pcal.fastback.mod.fabric.MixinGateway;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MinecraftServer.class})
public class MinecraftServerMixin {
    @Redirect(method={"tick(Ljava/util/function/BooleanSupplier;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;saveAll(ZZZ)Z"))
    public boolean fastback_saveAll(MinecraftServer instance, boolean suppressLogs, boolean flush, boolean force) {
        boolean result = instance.method_39218(suppressLogs, flush, force);
        MixinGateway.get().autoSaveCompleted();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(at={@At(value="HEAD")}, method={"save(ZZZ)Z"}, cancellable=true)
    public void fastback_save(boolean suppressLogs, boolean flush, boolean force, CallbackInfoReturnable<Boolean> ci) {
        MinecraftServerMixin minecraftServerMixin = this;
        synchronized (minecraftServerMixin) {
            if (MixinGateway.get().isWorldSaveEnabled()) {
                SystemLogger.syslog().debug("world saves are enabled, doing requested save");
            } else {
                SystemLogger.syslog().warn("Skipping requested save because a backup is in progress.");
                ci.setReturnValue((Object)false);
                ci.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(at={@At(value="HEAD")}, method={"saveAll(ZZZ)Z"}, cancellable=true)
    public void fastback_saveAll(boolean suppressLogs, boolean flush, boolean force, CallbackInfoReturnable<Boolean> ci) {
        MinecraftServerMixin minecraftServerMixin = this;
        synchronized (minecraftServerMixin) {
            if (MixinGateway.get().isWorldSaveEnabled()) {
                SystemLogger.syslog().debug("world saves are enabled, doing requested saveAll");
            } else {
                SystemLogger.syslog().warn("Skipping requested saveAll because a backup is in progress.");
                ci.setReturnValue((Object)false);
                ci.cancel();
            }
        }
    }
}

