/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.logging;

import com.mojang.brigadier.context.CommandContext;
import net.minecraft.class_2168;
import net.pcal.fastback.logging.CommandLogger;
import net.pcal.fastback.logging.ShutdownLogger;
import net.pcal.fastback.logging.SystemLogger;
import net.pcal.fastback.logging.UserMessage;
import net.pcal.fastback.mod.Mod;

public interface UserLogger
extends AutoCloseable {
    public void message(UserMessage var1);

    public void update(UserMessage var1);

    @Override
    default public void close() {
        Mod.mod().clearHudText();
    }

    default public void internalError() {
        this.message(UserMessage.styledLocalized("fastback.chat.internal-error", UserMessage.UserMessageStyle.ERROR, new Object[0]));
    }

    default public void internalError(Exception e) {
        SystemLogger.syslog().error(e);
        this.internalError();
    }

    public static UserLogger ulog(CommandContext<class_2168> cc) {
        return new CommandLogger((class_2168)cc.getSource());
    }

    public static UserLogger ulog(class_2168 scs) {
        return new CommandLogger(scs);
    }

    public static UserLogger forShutdown() {
        return ShutdownLogger.INSTANCE;
    }

    public static UserLogger forAutosave() {
        return ShutdownLogger.INSTANCE;
    }
}

