/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.config;

import java.io.IOException;
import java.util.Objects;
import net.pcal.fastback.config.GitConfig;
import net.pcal.fastback.config.GitConfigKey;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.StoredConfig;

class GitConfigImpl
implements GitConfig {
    private final StoredConfig storedConfig;

    static GitConfig load(Git jgit) {
        return new GitConfigImpl(jgit.getRepository().getConfig());
    }

    GitConfigImpl(StoredConfig jgitConfig) {
        this.storedConfig = Objects.requireNonNull(jgitConfig);
    }

    @Override
    public boolean getBoolean(GitConfigKey key) {
        if (key.getSettingName() == null) {
            return key.getBooleanDefault();
        }
        return this.storedConfig.getBoolean(key.getSectionName(), key.getSubSectionName(), key.getSettingName(), key.getBooleanDefault());
    }

    @Override
    public String getString(GitConfigKey key) {
        if (key.getSettingName() == null) {
            return key.getStringDefault();
        }
        String out = this.storedConfig.getString(key.getSectionName(), key.getSubSectionName(), key.getSettingName());
        return out != null ? out : key.getStringDefault();
    }

    @Override
    public int getInt(GitConfigKey key) {
        if (key.getSettingName() == null) {
            return key.getIntDefault();
        }
        return this.storedConfig.getInt(key.getSectionName(), key.getSubSectionName(), key.getSettingName(), key.getIntDefault());
    }

    @Override
    public boolean isSet(GitConfigKey key) {
        String out = this.storedConfig.getString(key.getSectionName(), key.getSubSectionName(), key.getSettingName());
        return out != null;
    }

    @Override
    public GitConfig.Updater updater() {
        return new UpdaterImpl();
    }

    private class UpdaterImpl
    implements GitConfig.Updater {
        private UpdaterImpl() {
        }

        @Override
        public GitConfig.Updater set(GitConfigKey key, boolean newValue) {
            GitConfigImpl.this.storedConfig.setBoolean(key.getSectionName(), key.getSubSectionName(), key.getSettingName(), newValue);
            return this;
        }

        @Override
        public GitConfig.Updater set(GitConfigKey key, String newValue) {
            GitConfigImpl.this.storedConfig.setString(key.getSectionName(), key.getSubSectionName(), key.getSettingName(), newValue);
            return this;
        }

        @Override
        public GitConfig.Updater set(GitConfigKey key, int newValue) {
            GitConfigImpl.this.storedConfig.setInt(key.getSectionName(), key.getSubSectionName(), key.getSettingName(), newValue);
            return this;
        }

        @Override
        public GitConfig.Updater setCommented(GitConfigKey key, boolean newValue) {
            GitConfigImpl.this.storedConfig.setBoolean(key.getSectionName(), key.getSubSectionName(), "# " + key.getSettingName(), newValue);
            return this;
        }

        @Override
        public GitConfig.Updater setCommented(GitConfigKey key, String newValue) {
            GitConfigImpl.this.storedConfig.setString(key.getSectionName(), key.getSubSectionName(), "# " + key.getSettingName(), newValue);
            return this;
        }

        @Override
        public GitConfig.Updater setCommented(GitConfigKey key, int newValue) {
            GitConfigImpl.this.storedConfig.setInt(key.getSectionName(), key.getSubSectionName(), "# " + key.getSettingName(), newValue);
            return this;
        }

        @Override
        public void save() throws IOException {
            GitConfigImpl.this.storedConfig.save();
        }
    }
}

