/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.commands;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2168;
import net.pcal.fastback.commands.Commands;
import net.pcal.fastback.logging.UserLogger;
import net.pcal.fastback.repo.Repo;
import net.pcal.fastback.repo.SnapshotId;
import net.pcal.fastback.utils.Executor;

abstract class SnapshotNameSuggestions
implements SuggestionProvider<class_2168> {
    SnapshotNameSuggestions() {
    }

    static SnapshotNameSuggestions local() {
        return new SnapshotNameSuggestions(){

            @Override
            protected Iterator<SnapshotId> getSnapshotIds(Repo repo, UserLogger ulog) throws Exception {
                return repo.getLocalSnapshots().iterator();
            }
        };
    }

    static SnapshotNameSuggestions remote() {
        return new SnapshotNameSuggestions(){

            @Override
            protected Iterator<SnapshotId> getSnapshotIds(Repo repo, UserLogger ulog) throws Exception {
                return repo.getRemoteSnapshots().iterator();
            }
        };
    }

    public CompletableFuture<Suggestions> getSuggestions(CommandContext<class_2168> cc, SuggestionsBuilder builder) {
        CompletableFuture<Suggestions> completableFuture = new CompletableFuture<Suggestions>();
        try (UserLogger ulog = UserLogger.ulog(cc);){
            Commands.gitOp(Executor.ExecutionLock.NONE, ulog, repo -> {
                Iterator<SnapshotId> i = this.getSnapshotIds(repo, ulog);
                while (i.hasNext()) {
                    builder.suggest(i.next().getShortName());
                }
                completableFuture.complete((Suggestions)builder.buildFuture().get());
            });
        }
        return completableFuture;
    }

    protected abstract Iterator<SnapshotId> getSnapshotIds(Repo var1, UserLogger var2) throws Exception;
}

