/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.pcal.fastback.commands.Command;
import net.pcal.fastback.commands.Commands;
import net.pcal.fastback.commands.PermissionsFactory;
import net.pcal.fastback.commands.SchedulableAction;
import net.pcal.fastback.config.FastbackConfigKey;
import net.pcal.fastback.config.GitConfig;
import net.pcal.fastback.config.GitConfigKey;
import net.pcal.fastback.config.OtherConfigKey;
import net.pcal.fastback.logging.SystemLogger;
import net.pcal.fastback.logging.UserLogger;
import net.pcal.fastback.logging.UserMessage;
import net.pcal.fastback.mod.Mod;
import net.pcal.fastback.repo.Repo;
import net.pcal.fastback.repo.RepoFactory;
import net.pcal.fastback.retention.RetentionPolicy;
import net.pcal.fastback.retention.RetentionPolicyCodec;
import net.pcal.fastback.retention.RetentionPolicyType;
import net.pcal.fastback.utils.EnvironmentUtils;

enum SetCommand implements Command
{
    INSTANCE;

    private static final String COMMAND_NAME = "set";
    private static final String FORCE_DEBUG_SETTING = "force-debug-enabled";

    @Override
    public void register(LiteralArgumentBuilder<class_2168> root, PermissionsFactory<class_2168> pf) {
        LiteralArgumentBuilder sc = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)COMMAND_NAME).requires(Commands.subcommandPermission(COMMAND_NAME, pf))).executes(cc -> Commands.missingArgument("key", (CommandContext<class_2168>)cc));
        SetCommand.registerBooleanConfigValue(FastbackConfigKey.IS_NATIVE_GIT_ENABLED, (LiteralArgumentBuilder<class_2168>)sc);
        SetCommand.registerBooleanConfigValue(FastbackConfigKey.IS_LOCK_CLEANUP_ENABLED, (LiteralArgumentBuilder<class_2168>)sc);
        SetCommand.registerBooleanConfigValue(FastbackConfigKey.IS_BACKUP_ENABLED, (LiteralArgumentBuilder<class_2168>)sc);
        SetCommand.registerBooleanConfigValue(FastbackConfigKey.IS_MODS_BACKUP_ENABLED, (LiteralArgumentBuilder<class_2168>)sc);
        SetCommand.registerBooleanConfigValue(FastbackConfigKey.BROADCAST_ENABLED, (LiteralArgumentBuilder<class_2168>)sc);
        SetCommand.registerStringConfigValue(FastbackConfigKey.BROADCAST_MESSAGE, "message", (LiteralArgumentBuilder<class_2168>)sc);
        SetCommand.registerStringConfigValue(FastbackConfigKey.RESTORE_DIRECTORY, "full-directory-path", (LiteralArgumentBuilder<class_2168>)sc);
        SetCommand.registerStringConfigValue(OtherConfigKey.REMOTE_PUSH_URL, "url", (LiteralArgumentBuilder<class_2168>)sc);
        SetCommand.registerIntegerConfigValue(FastbackConfigKey.AUTOBACK_WAIT_MINUTES, "minutes", (LiteralArgumentBuilder<class_2168>)sc);
        ArrayList<String> schedulableActions = new ArrayList<String>();
        for (SchedulableAction sa : SchedulableAction.values()) {
            schedulableActions.add(sa.getConfigValue());
        }
        SetCommand.registerSelectConfigValue(FastbackConfigKey.AUTOBACK_ACTION, schedulableActions, (LiteralArgumentBuilder<class_2168>)sc);
        SetCommand.registerSelectConfigValue(FastbackConfigKey.SHUTDOWN_ACTION, schedulableActions, (LiteralArgumentBuilder<class_2168>)sc);
        SetCommand.registerSetRetentionCommand(FastbackConfigKey.LOCAL_RETENTION_POLICY, (LiteralArgumentBuilder<class_2168>)sc);
        SetCommand.registerSetRetentionCommand(FastbackConfigKey.REMOTE_RETENTION_POLICY, (LiteralArgumentBuilder<class_2168>)sc);
        SetCommand.registerForceDebug((LiteralArgumentBuilder<class_2168>)sc);
        root.then((ArgumentBuilder)sc);
    }

    private static void registerBooleanConfigValue(GitConfigKey key, LiteralArgumentBuilder<class_2168> setCommand) {
        LiteralArgumentBuilder builder = class_2170.method_9247((String)key.getDisplayName());
        builder.then(class_2170.method_9247((String)"true").executes(cc -> SetCommand.setBooleanConfigValue(key, true, (CommandContext<class_2168>)cc)));
        builder.then(class_2170.method_9247((String)"false").executes(cc -> SetCommand.setBooleanConfigValue(key, false, (CommandContext<class_2168>)cc)));
        setCommand.then((ArgumentBuilder)builder);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int setBooleanConfigValue(GitConfigKey key, boolean newValue, CommandContext<class_2168> cc) {
        try (UserLogger ulog = UserLogger.ulog(cc);){
            Path worldSaveDir = Mod.mod().getWorldDirectory();
            RepoFactory rf = RepoFactory.rf();
            if (!rf.isGitRepo(worldSaveDir)) return 1;
            try {
                Repo repo;
                block18: {
                    repo = rf.load(worldSaveDir);
                    GitConfig conf = repo.getConfig();
                    boolean current = conf.getBoolean(key);
                    if (current == newValue) {
                        ulog.message(UserMessage.raw("No change."));
                        return 1;
                    }
                    if (key != FastbackConfigKey.IS_NATIVE_GIT_ENABLED || SetCommand.validateNativeGitChange(newValue, repo, ulog)) break block18;
                    int n = 0;
                    if (repo == null) return n;
                    repo.close();
                    return n;
                }
                try {
                    repo.getConfig().updater().set(key, newValue).save();
                    ulog.message(UserMessage.raw(key.getDisplayName() + " = " + newValue));
                    return 1;
                }
                finally {
                    if (repo != null) {
                        repo.close();
                    }
                }
            }
            catch (Exception e) {
                ulog.internalError(e);
                int n = 0;
                if (ulog == null) return n;
                ulog.close();
                return n;
            }
        }
    }

    private static void registerIntegerConfigValue(GitConfigKey key, String argName, LiteralArgumentBuilder<class_2168> setCommand) {
        LiteralArgumentBuilder builder = class_2170.method_9247((String)key.getDisplayName());
        builder.then(class_2170.method_9244((String)argName, (ArgumentType)IntegerArgumentType.integer()).executes(cc -> SetCommand.setIntegerConfigValue(key, argName, (CommandContext<class_2168>)cc)));
        setCommand.then((ArgumentBuilder)builder);
    }

    private static int setIntegerConfigValue(GitConfigKey key, String argName, CommandContext<class_2168> cc) {
        block15: {
            try (UserLogger ulog = UserLogger.ulog(cc);){
                Path worldSaveDir = Mod.mod().getWorldDirectory();
                RepoFactory rf = RepoFactory.rf();
                if (!rf.isGitRepo(worldSaveDir)) break block15;
                try (Repo repo = rf.load(worldSaveDir);){
                    Integer newValue = (Integer)cc.getArgument(argName, Integer.class);
                    repo.getConfig().updater().set(key, newValue).save();
                    ulog.message(UserMessage.raw(key.getDisplayName() + " = " + newValue));
                }
                catch (Exception e) {
                    ulog.internalError(e);
                    int n = 0;
                    if (ulog != null) {
                        ulog.close();
                    }
                    return n;
                }
            }
        }
        return 1;
    }

    private static void registerStringConfigValue(GitConfigKey key, String argName, LiteralArgumentBuilder<class_2168> setCommand) {
        LiteralArgumentBuilder builder = class_2170.method_9247((String)key.getDisplayName());
        builder.then(class_2170.method_9244((String)argName, (ArgumentType)StringArgumentType.greedyString()).executes(cc -> SetCommand.setStringConfigValue(key, argName, (CommandContext<class_2168>)cc)));
        setCommand.then((ArgumentBuilder)builder);
    }

    private static int setStringConfigValue(GitConfigKey key, String argName, CommandContext<class_2168> cc) {
        block15: {
            try (UserLogger ulog = UserLogger.ulog(cc);){
                Path worldSaveDir = Mod.mod().getWorldDirectory();
                RepoFactory rf = RepoFactory.rf();
                if (!rf.isGitRepo(worldSaveDir)) break block15;
                try (Repo repo = rf.load(worldSaveDir);){
                    String newValue = (String)cc.getArgument(argName, String.class);
                    repo.getConfig().updater().set(key, newValue).save();
                    ulog.message(UserMessage.raw(key.getDisplayName() + " = " + newValue));
                }
                catch (Exception e) {
                    ulog.internalError(e);
                    int n = 0;
                    if (ulog != null) {
                        ulog.close();
                    }
                    return n;
                }
            }
        }
        return 1;
    }

    private static void registerSelectConfigValue(GitConfigKey key, List<String> selections, LiteralArgumentBuilder<class_2168> setCommand) {
        LiteralArgumentBuilder builder = class_2170.method_9247((String)key.getDisplayName());
        for (String selection : selections) {
            builder.then(class_2170.method_9247((String)selection).executes(cc -> SetCommand.setSelectionConfigValue(key, selection, (CommandContext<class_2168>)cc)));
        }
        setCommand.then((ArgumentBuilder)builder);
    }

    private static int setSelectionConfigValue(GitConfigKey key, String newValue, CommandContext<class_2168> cc) {
        block15: {
            try (UserLogger ulog = UserLogger.ulog(cc);){
                Path worldSaveDir = Mod.mod().getWorldDirectory();
                if (!RepoFactory.rf().isGitRepo(worldSaveDir)) break block15;
                try (Repo repo = RepoFactory.rf().load(worldSaveDir);){
                    repo.getConfig().updater().set(key, newValue).save();
                    ulog.message(UserMessage.raw(key.getDisplayName() + " = " + newValue));
                }
                catch (Exception e) {
                    ulog.internalError(e);
                    int n = 0;
                    if (ulog != null) {
                        ulog.close();
                    }
                    return n;
                }
            }
        }
        return 1;
    }

    private static void registerForceDebug(LiteralArgumentBuilder<class_2168> setCommand) {
        LiteralArgumentBuilder debug = class_2170.method_9247((String)FORCE_DEBUG_SETTING);
        debug.then(class_2170.method_9247((String)"true").executes(cc -> SetCommand.setForceDebug((CommandContext<class_2168>)cc, true)));
        debug.then(class_2170.method_9247((String)"false").executes(cc -> SetCommand.setForceDebug((CommandContext<class_2168>)cc, false)));
        setCommand.then((ArgumentBuilder)debug);
    }

    private static int setForceDebug(CommandContext<class_2168> cc, boolean value) {
        SystemLogger.syslog().setForceDebugEnabled(value);
        try (UserLogger ulog = UserLogger.ulog(cc);){
            ulog.message(UserMessage.raw("force-debug-enabled = " + value));
        }
        return 1;
    }

    private static void registerSetRetentionCommand(FastbackConfigKey key, LiteralArgumentBuilder<class_2168> argb) {
        LiteralArgumentBuilder retainCommand = class_2170.method_9247((String)key.getSettingName());
        for (RetentionPolicyType rpt : RetentionPolicyType.getAvailable()) {
            LiteralArgumentBuilder policyCommand = class_2170.method_9247((String)rpt.getCommandName());
            policyCommand.executes(cc -> SetCommand.setRetentionPolicy((CommandContext<class_2168>)cc, rpt, key));
            if (rpt.getParameters() != null) {
                for (RetentionPolicyType.Parameter<?> param : rpt.getParameters()) {
                    policyCommand.then(class_2170.method_9244((String)param.name(), param.type()).executes(cc -> SetCommand.setRetentionPolicy((CommandContext<class_2168>)cc, rpt, key)));
                }
            }
            retainCommand.then((ArgumentBuilder)policyCommand);
        }
        argb.then((ArgumentBuilder)retainCommand);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int setRetentionPolicy(CommandContext<class_2168> cc, RetentionPolicyType rpt, FastbackConfigKey confKey) {
        UserLogger ulog = UserLogger.ulog(cc);
        Path worldSaveDir = Mod.mod().getWorldDirectory();
        try (Repo repo = RepoFactory.rf().load(worldSaveDir);){
            HashMap<String, String> config = new HashMap<String, String>();
            for (RetentionPolicyType.Parameter<?> p : rpt.getParameters()) {
                Object val = Commands.getArgumentNicely(p.name(), p.clazz(), cc, ulog);
                if (val == null) {
                    int n = 0;
                    return n;
                }
                config.put(p.name(), String.valueOf(val));
            }
            String encodedPolicy = RetentionPolicyCodec.INSTANCE.encodePolicy(rpt, config);
            RetentionPolicy rp = RetentionPolicyCodec.INSTANCE.decodePolicy(RetentionPolicyType.getAvailable(), encodedPolicy);
            if (rp == null) {
                SystemLogger.syslog().error("Failed to decode policy " + encodedPolicy, new Exception());
                int val = 0;
                return val;
            }
            GitConfig conf = repo.getConfig();
            conf.updater().set((GitConfigKey)confKey, encodedPolicy).save();
            ulog.message(UserMessage.localized("fastback.chat.retention-policy-set", new Object[0]));
            ulog.message(rp.getDescription());
            int n = 1;
            return n;
        }
        catch (Exception e) {
            SystemLogger.syslog().error("Failed to set retention policy", e);
            return 0;
        }
    }

    private static boolean validateNativeGitChange(boolean newValue, Repo repo, UserLogger user) throws IOException {
        if (newValue && !EnvironmentUtils.isNativeGitInstalled()) {
            user.message(UserMessage.styledRaw("Native git is not installed on your machine.  Please install it and try again.", UserMessage.UserMessageStyle.ERROR));
            return false;
        }
        if (!repo.getLocalSnapshots().isEmpty()) {
            user.message(UserMessage.styledRaw("You can't change " + FastbackConfigKey.IS_NATIVE_GIT_ENABLED.getSettingName() + " once you've made a backup.  If you want to delete your current backups and start over, delete the .git directory in your world folder. ", UserMessage.UserMessageStyle.ERROR));
            return false;
        }
        return true;
    }
}

