/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.io.File;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.pcal.fastback.commands.Command;
import net.pcal.fastback.commands.Commands;
import net.pcal.fastback.commands.PermissionsFactory;
import net.pcal.fastback.commands.SchedulableAction;
import net.pcal.fastback.config.FastbackConfigKey;
import net.pcal.fastback.config.GitConfig;
import net.pcal.fastback.config.GitConfigKey;
import net.pcal.fastback.config.OtherConfigKey;
import net.pcal.fastback.logging.UserLogger;
import net.pcal.fastback.logging.UserMessage;
import net.pcal.fastback.mod.Mod;
import net.pcal.fastback.repo.Repo;
import net.pcal.fastback.repo.RepoFactory;
import net.pcal.fastback.retention.RetentionPolicy;
import net.pcal.fastback.retention.RetentionPolicyCodec;
import net.pcal.fastback.retention.RetentionPolicyType;
import net.pcal.fastback.utils.EnvironmentUtils;
import org.apache.commons.io.FileUtils;

enum InfoCommand implements Command
{
    INSTANCE;

    private static final String COMMAND_NAME = "info";

    @Override
    public void register(LiteralArgumentBuilder<class_2168> argb, PermissionsFactory<class_2168> pf) {
        argb.then(((LiteralArgumentBuilder)class_2170.method_9247((String)COMMAND_NAME).requires(Commands.subcommandPermission(COMMAND_NAME, pf))).executes(cc -> InfoCommand.info((class_2168)cc.getSource())));
    }

    private static int info(class_2168 scs) {
        block14: {
            Objects.requireNonNull(scs);
            try (UserLogger ulog = UserLogger.ulog(scs);){
                try {
                    class_5250 notInstalled = class_2561.method_43471((String)"fastback.values.not-installed");
                    ulog.message(UserMessage.localized("fastback.chat.info-header", new Object[0]));
                    ulog.message(UserMessage.localized("fastback.chat.info-fastback-version", Mod.mod().getModVersion()));
                    ulog.message(UserMessage.raw("native git installed: " + EnvironmentUtils.isNativeGitInstalled()));
                    String gitVersion = EnvironmentUtils.getGitVersion();
                    ulog.message(UserMessage.localized("fastback.chat.info-native-git-version", gitVersion != null ? gitVersion : notInstalled));
                    String gitLfsVersion = EnvironmentUtils.getGitLfsVersion();
                    ulog.message(UserMessage.localized("fastback.chat.info-native-git-lfs-version", gitLfsVersion != null ? gitLfsVersion : notInstalled));
                    if (!RepoFactory.rf().isGitRepo(Mod.mod().getWorldDirectory())) break block14;
                    try (Repo repo = RepoFactory.rf().load(Mod.mod().getWorldDirectory());){
                        GitConfig conf = repo.getConfig();
                        ulog.message(UserMessage.localized("fastback.chat.info-uuid", repo.getWorldId()));
                        long backupSize = FileUtils.sizeOfDirectory((File)repo.getDirectory());
                        long worldSize = FileUtils.sizeOfDirectory((File)repo.getWorkTree()) - backupSize;
                        ulog.message(UserMessage.localized("fastback.chat.info-world-size", FileUtils.byteCountToDisplaySize((long)worldSize)));
                        ulog.message(UserMessage.localized("fastback.chat.info-backup-size", FileUtils.byteCountToDisplaySize((long)backupSize)));
                        InfoCommand.show(FastbackConfigKey.IS_BACKUP_ENABLED, conf::getBoolean, ulog);
                        InfoCommand.show(OtherConfigKey.REMOTE_PUSH_URL, conf::getString, ulog);
                        InfoCommand.show(FastbackConfigKey.RESTORE_DIRECTORY, conf::getString, ulog);
                        InfoCommand.show(FastbackConfigKey.IS_NATIVE_GIT_ENABLED, conf::getBoolean, ulog);
                        InfoCommand.show(FastbackConfigKey.AUTOBACK_WAIT_MINUTES, conf::getInt, ulog);
                        InfoCommand.show(FastbackConfigKey.IS_MODS_BACKUP_ENABLED, conf::getBoolean, ulog);
                        InfoCommand.show(FastbackConfigKey.BROADCAST_ENABLED, conf::getBoolean, ulog);
                        InfoCommand.show(FastbackConfigKey.BROADCAST_MESSAGE, conf::getString, ulog);
                        SchedulableAction shutdownAction = SchedulableAction.forConfigValue(conf.getString(FastbackConfigKey.SHUTDOWN_ACTION));
                        ulog.message(UserMessage.localized("fastback.chat.info-shutdown-action", InfoCommand.getActionDisplay(shutdownAction)));
                        SchedulableAction autobackAction = SchedulableAction.forConfigValue(conf.getString(FastbackConfigKey.AUTOBACK_ACTION));
                        ulog.message(UserMessage.localized("fastback.chat.info-autoback-action", InfoCommand.getActionDisplay(autobackAction)));
                        InfoCommand.showRetentionPolicy(ulog, conf.getString(FastbackConfigKey.LOCAL_RETENTION_POLICY), "fastback.chat.retention-policy-set", "fastback.chat.retention-policy-none");
                        InfoCommand.showRetentionPolicy(ulog, conf.getString(FastbackConfigKey.REMOTE_RETENTION_POLICY), "fastback.chat.remote-retention-policy-set", "fastback.chat.remote-retention-policy-none");
                    }
                }
                catch (Exception e) {
                    ulog.internalError(e);
                }
            }
        }
        return 1;
    }

    private static void show(GitConfigKey key, Function<GitConfigKey, Object> valueFn, UserLogger ulog) {
        ulog.message(UserMessage.raw(key.getDisplayName() + " = " + valueFn.apply(key)));
    }

    private static String getActionDisplay(SchedulableAction action) {
        return action == null ? SchedulableAction.NONE.getArgumentName() : action.getArgumentName();
    }

    private static void showRetentionPolicy(UserLogger log, String encodedPolicy, String setKey, String noneKey) {
        if (encodedPolicy == null) {
            log.message(UserMessage.localized(noneKey, new Object[0]));
        } else {
            RetentionPolicy policy = RetentionPolicyCodec.INSTANCE.decodePolicy(RetentionPolicyType.getAvailable(), encodedPolicy);
            if (policy == null) {
                log.message(UserMessage.localized(noneKey, new Object[0]));
            } else {
                log.message(UserMessage.localized(setKey, new Object[0]));
                log.message(policy.getDescription());
            }
        }
    }
}

