/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.utils;

import java.util.ArrayList;
import java.util.Collections;
import net.pcal.fastback.logging.SystemLogger;
import net.pcal.fastback.utils.ProcessException;
import net.pcal.fastback.utils.ProcessUtils;

public class EnvironmentUtils {
    public static boolean isNativeGitInstalled() {
        return EnvironmentUtils.getGitVersion() != null && EnvironmentUtils.getGitLfsVersion() != null;
    }

    public static String getGitVersion() {
        return EnvironmentUtils.execForVersion(new String[]{"git", "--version"});
    }

    public static String getGitLfsVersion() {
        return EnvironmentUtils.execForVersion(new String[]{"git-lfs", "--version"});
    }

    private static String execForVersion(String[] cmd) {
        int exit;
        ArrayList stdout = new ArrayList();
        try {
            exit = ProcessUtils.doExec(cmd, Collections.emptyMap(), stdout::add, line -> {});
        }
        catch (ProcessException e) {
            SystemLogger.syslog().debug("Could not run " + String.join((CharSequence)" ", cmd), e);
            return null;
        }
        return exit == 0 ? (String)stdout.get(0) : null;
    }
}

