/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.shaded.org.eclipse.jgit.transport;

import java.util.Locale;
import net.pcal.fastback.shaded.org.eclipse.jgit.lib.Config;
import net.pcal.fastback.shaded.org.eclipse.jgit.util.StringUtils;

public class PushConfig {
    private final PushRecurseSubmodulesMode recurseSubmodules;
    private final PushDefault pushDefault;

    public PushConfig(Config config) {
        this.recurseSubmodules = config.getEnum("push", null, "recurseSubmodules", PushRecurseSubmodulesMode.NO);
        this.pushDefault = config.getEnum("push", null, "default", PushDefault.SIMPLE);
    }

    public PushRecurseSubmodulesMode getRecurseSubmodules() {
        return this.recurseSubmodules;
    }

    public PushDefault getPushDefault() {
        return this.pushDefault;
    }

    public static enum PushDefault implements Config.ConfigEnum
    {
        NOTHING,
        CURRENT,
        UPSTREAM("tracking"),
        SIMPLE,
        MATCHING;

        private final String alias;

        private PushDefault() {
            this.alias = null;
        }

        private PushDefault(String alias) {
            this.alias = alias;
        }

        @Override
        public String toConfigValue() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        @Override
        public boolean matchConfigValue(String in) {
            return this.toConfigValue().equalsIgnoreCase(in) || this.alias != null && this.alias.equalsIgnoreCase(in);
        }
    }

    public static enum PushRecurseSubmodulesMode implements Config.ConfigEnum
    {
        CHECK("check"),
        ON_DEMAND("on-demand"),
        NO("false");

        private final String configValue;

        private PushRecurseSubmodulesMode(String configValue) {
            this.configValue = configValue;
        }

        @Override
        public String toConfigValue() {
            return this.configValue;
        }

        @Override
        public boolean matchConfigValue(String s) {
            if (StringUtils.isEmptyOrNull(s)) {
                return false;
            }
            s = s.replace('-', '_');
            return this.name().equalsIgnoreCase(s) || this.configValue.equalsIgnoreCase(s);
        }
    }
}

