/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.shaded.org.eclipse.jgit.transport;

import java.io.EOFException;
import java.io.IOException;
import java.text.MessageFormat;
import net.pcal.fastback.shaded.org.eclipse.jgit.errors.PackProtocolException;
import net.pcal.fastback.shaded.org.eclipse.jgit.internal.JGitText;
import net.pcal.fastback.shaded.org.eclipse.jgit.internal.transport.parser.FirstWant;
import net.pcal.fastback.shaded.org.eclipse.jgit.lib.ObjectId;
import net.pcal.fastback.shaded.org.eclipse.jgit.transport.FetchV0Request;
import net.pcal.fastback.shaded.org.eclipse.jgit.transport.FilterSpec;
import net.pcal.fastback.shaded.org.eclipse.jgit.transport.PacketLineIn;
import net.pcal.fastback.shaded.org.eclipse.jgit.transport.TransferConfig;

final class ProtocolV0Parser {
    private final TransferConfig transferConfig;

    ProtocolV0Parser(TransferConfig transferConfig) {
        this.transferConfig = transferConfig;
    }

    FetchV0Request recvWants(PacketLineIn pckIn) throws PackProtocolException, IOException {
        FetchV0Request.Builder reqBuilder = new FetchV0Request.Builder();
        boolean isFirst = true;
        boolean filterReceived = false;
        while (true) {
            String line;
            try {
                line = pckIn.readString();
            }
            catch (EOFException eof) {
                if (isFirst) break;
                throw eof;
            }
            if (PacketLineIn.isEnd(line)) break;
            if (line.startsWith("deepen ")) {
                int depth = Integer.parseInt(line.substring("deepen ".length()));
                if (depth <= 0) {
                    throw new PackProtocolException(MessageFormat.format(JGitText.get().invalidDepth, depth));
                }
                if (reqBuilder.getDeepenSince() != 0) {
                    throw new PackProtocolException(JGitText.get().deepenSinceWithDeepen);
                }
                if (reqBuilder.hasDeepenNots()) {
                    throw new PackProtocolException(JGitText.get().deepenNotWithDeepen);
                }
                reqBuilder.setDepth(depth);
                continue;
            }
            if (line.startsWith("deepen-not ")) {
                reqBuilder.addDeepenNot(line.substring("deepen-not ".length()));
                if (reqBuilder.getDepth() == 0) continue;
                throw new PackProtocolException(JGitText.get().deepenNotWithDeepen);
            }
            if (line.startsWith("deepen-since ")) {
                int ts = Integer.parseInt(line.substring("deepen-since ".length()));
                if (ts <= 0) {
                    throw new PackProtocolException(MessageFormat.format(JGitText.get().invalidTimestamp, line));
                }
                if (reqBuilder.getDepth() != 0) {
                    throw new PackProtocolException(JGitText.get().deepenSinceWithDeepen);
                }
                reqBuilder.setDeepenSince(ts);
                continue;
            }
            if (line.startsWith("shallow ")) {
                reqBuilder.addClientShallowCommit(ObjectId.fromString(line.substring("shallow ".length())));
                continue;
            }
            if (this.transferConfig.isAllowFilter() && line.startsWith("filter ")) {
                String arg = line.substring("filter".length() + 1);
                if (filterReceived) {
                    throw new PackProtocolException(JGitText.get().tooManyFilters);
                }
                filterReceived = true;
                reqBuilder.setFilterSpec(FilterSpec.fromFilterLine(arg));
                continue;
            }
            if (!line.startsWith("want ") || line.length() < 45) {
                throw new PackProtocolException(MessageFormat.format(JGitText.get().expectedGot, "want", line));
            }
            if (isFirst && line.length() > 45) {
                FirstWant firstLine = FirstWant.fromLine(line);
                reqBuilder.addClientCapabilities(firstLine.getCapabilities());
                reqBuilder.setAgent(firstLine.getAgent());
                reqBuilder.setClientSID(firstLine.getClientSID());
                line = firstLine.getLine();
            }
            reqBuilder.addWantId(ObjectId.fromString(line.substring("want ".length())));
            isFirst = false;
        }
        return reqBuilder.build();
    }
}

