/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.shaded.org.eclipse.jgit.transport;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import net.pcal.fastback.shaded.org.eclipse.jgit.lib.ObjectId;
import net.pcal.fastback.shaded.org.eclipse.jgit.lib.Ref;
import net.pcal.fastback.shaded.org.eclipse.jgit.lib.Repository;
import net.pcal.fastback.shaded.org.eclipse.jgit.revwalk.RevWalk;
import net.pcal.fastback.shaded.org.eclipse.jgit.transport.AdvertiseRefsHook;
import net.pcal.fastback.shaded.org.eclipse.jgit.transport.ReceivePack;
import net.pcal.fastback.shaded.org.eclipse.jgit.transport.ServiceMayNotContinueException;
import net.pcal.fastback.shaded.org.eclipse.jgit.transport.UploadPack;

public abstract class AbstractAdvertiseRefsHook
implements AdvertiseRefsHook {
    @Override
    public void advertiseRefs(UploadPack uploadPack) throws ServiceMayNotContinueException {
        uploadPack.setAdvertisedRefs(this.getAdvertisedRefs(uploadPack.getRepository(), uploadPack.getRevWalk()));
    }

    @Override
    public void advertiseRefs(ReceivePack receivePack) throws IOException {
        Map<String, Ref> refs = this.getAdvertisedRefs(receivePack.getRepository(), receivePack.getRevWalk());
        Set<ObjectId> haves = this.getAdvertisedHaves(receivePack.getRepository(), receivePack.getRevWalk());
        receivePack.setAdvertisedRefs(refs, haves);
    }

    protected abstract Map<String, Ref> getAdvertisedRefs(Repository var1, RevWalk var2) throws ServiceMayNotContinueException;

    protected Set<ObjectId> getAdvertisedHaves(Repository repository, RevWalk revWalk) throws ServiceMayNotContinueException {
        return null;
    }
}

