/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.shaded.org.eclipse.jgit.storage.file;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.pcal.fastback.shaded.org.eclipse.jgit.errors.ConfigInvalidException;
import net.pcal.fastback.shaded.org.eclipse.jgit.errors.LockFailedException;
import net.pcal.fastback.shaded.org.eclipse.jgit.internal.JGitText;
import net.pcal.fastback.shaded.org.eclipse.jgit.internal.storage.file.FileSnapshot;
import net.pcal.fastback.shaded.org.eclipse.jgit.internal.storage.file.LockFile;
import net.pcal.fastback.shaded.org.eclipse.jgit.lib.Config;
import net.pcal.fastback.shaded.org.eclipse.jgit.lib.Constants;
import net.pcal.fastback.shaded.org.eclipse.jgit.lib.ObjectId;
import net.pcal.fastback.shaded.org.eclipse.jgit.lib.StoredConfig;
import net.pcal.fastback.shaded.org.eclipse.jgit.util.FS;
import net.pcal.fastback.shaded.org.eclipse.jgit.util.FileUtils;
import net.pcal.fastback.shaded.org.eclipse.jgit.util.IO;
import net.pcal.fastback.shaded.org.eclipse.jgit.util.RawParseUtils;

public class FileBasedConfig
extends StoredConfig {
    private final File configFile;
    private final FS fs;
    private boolean utf8Bom;
    private volatile FileSnapshot snapshot;
    private volatile ObjectId hash;
    private AtomicBoolean exists = new AtomicBoolean();

    public FileBasedConfig(File cfgLocation, FS fs) {
        this(null, cfgLocation, fs);
    }

    public FileBasedConfig(Config base, File cfgLocation, FS fs) {
        super(base);
        this.configFile = cfgLocation;
        this.fs = fs;
        this.snapshot = FileSnapshot.DIRTY;
        this.hash = ObjectId.zeroId();
    }

    @Override
    protected boolean notifyUponTransientChanges() {
        return false;
    }

    public final File getFile() {
        return this.configFile;
    }

    boolean exists() {
        return this.exists.get();
    }

    @Override
    public void setStringList(String section, String subsection, String name, List<String> values) {
        super.setStringList(section, subsection, name, values);
    }

    @Override
    public void unsetSection(String section, String subsection) {
        super.unsetSection(section, subsection);
    }

    @Override
    public void load() throws IOException, ConfigInvalidException {
        try {
            FileSnapshot[] lastSnapshot = new FileSnapshot[1];
            Boolean wasRead = FileUtils.readWithRetries(this.getFile(), f -> {
                FileSnapshot newSnapshot;
                FileSnapshot oldSnapshot = this.snapshot;
                fileSnapshotArray[0] = newSnapshot = FileSnapshot.saveNoConfig(f);
                byte[] in = IO.readFully(f);
                ObjectId newHash = FileBasedConfig.hash(in);
                if (this.hash.equals(newHash)) {
                    if (oldSnapshot.equals(newSnapshot)) {
                        oldSnapshot.setClean(newSnapshot);
                    } else {
                        this.snapshot = newSnapshot;
                    }
                } else {
                    String decoded;
                    if (this.isUtf8(in)) {
                        decoded = RawParseUtils.decode(StandardCharsets.UTF_8, in, 3, in.length);
                        this.utf8Bom = true;
                    } else {
                        decoded = RawParseUtils.decode(in);
                    }
                    this.fromText(decoded);
                    this.snapshot = newSnapshot;
                    this.hash = newHash;
                }
                return Boolean.TRUE;
            });
            if (wasRead == null) {
                this.clear();
                this.snapshot = lastSnapshot[0];
            }
            this.exists.set(wasRead != null);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigInvalidException(MessageFormat.format(JGitText.get().cannotReadFile, this.getFile()), e);
        }
    }

    @Override
    public void save() throws IOException {
        byte[] out;
        String text = this.toText();
        if (this.utf8Bom) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            bos.write(239);
            bos.write(187);
            bos.write(191);
            bos.write(text.getBytes(StandardCharsets.UTF_8));
            out = bos.toByteArray();
        } else {
            out = Constants.encode(text);
        }
        LockFile lf = new LockFile(this.getFile());
        try {
            if (!lf.lock()) {
                throw new LockFailedException(this.getFile());
            }
            lf.setNeedSnapshotNoConfig(true);
            lf.write(out);
            if (!lf.commit()) {
                throw new IOException(MessageFormat.format(JGitText.get().cannotCommitWriteTo, this.getFile()));
            }
        }
        finally {
            lf.unlock();
        }
        this.snapshot = lf.getCommitSnapshot();
        this.hash = FileBasedConfig.hash(out);
        this.fireConfigChangedEvent();
    }

    @Override
    public void clear() {
        this.hash = FileBasedConfig.hash(new byte[0]);
        super.clear();
    }

    private static ObjectId hash(byte[] rawText) {
        return ObjectId.fromRaw(Constants.newMessageDigest().digest(rawText));
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + this.getFile().getPath() + "]";
    }

    public boolean isOutdated() {
        return this.snapshot.isModified(this.getFile());
    }

    @Override
    protected byte[] readIncludedConfig(String relPath) throws ConfigInvalidException {
        File file = relPath.startsWith("~/") ? this.fs.resolve(this.fs.userHome(), relPath.substring(2)) : this.fs.resolve(this.configFile.getParentFile(), relPath);
        if (!file.exists()) {
            return null;
        }
        try {
            return IO.readFully(file);
        }
        catch (IOException ioe) {
            throw new ConfigInvalidException(MessageFormat.format(JGitText.get().cannotReadFile, relPath), ioe);
        }
    }
}

