/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.shaded.org.eclipse.jgit.revwalk;

import net.pcal.fastback.shaded.org.eclipse.jgit.revwalk.RevObject;

class BlockObjQueue {
    private BlockFreeList free = new BlockFreeList();
    private Block head;
    private Block tail;

    BlockObjQueue() {
    }

    void add(RevObject c) {
        Block b = this.tail;
        if (b == null) {
            b = this.free.newBlock();
            b.add(c);
            this.head = b;
            this.tail = b;
            return;
        }
        if (b.isFull()) {
            this.tail.next = b = this.free.newBlock();
            this.tail = b;
        }
        b.add(c);
    }

    RevObject next() {
        Block b = this.head;
        if (b == null) {
            return null;
        }
        RevObject c = b.pop();
        if (b.isEmpty()) {
            this.head = b.next;
            if (this.head == null) {
                this.tail = null;
            }
            this.free.freeBlock(b);
        }
        return c;
    }

    static final class Block {
        private static final int BLOCK_SIZE = 256;
        Block next;
        final RevObject[] objects = new RevObject[256];
        int headIndex;
        int tailIndex;

        Block() {
        }

        boolean isFull() {
            return this.tailIndex == 256;
        }

        boolean isEmpty() {
            return this.headIndex == this.tailIndex;
        }

        void add(RevObject c) {
            this.objects[this.tailIndex++] = c;
        }

        RevObject pop() {
            return this.objects[this.headIndex++];
        }

        void clear() {
            this.next = null;
            this.headIndex = 0;
            this.tailIndex = 0;
        }
    }

    static final class BlockFreeList {
        private Block next;

        BlockFreeList() {
        }

        Block newBlock() {
            Block b = this.next;
            if (b == null) {
                return new Block();
            }
            this.next = b.next;
            b.clear();
            return b;
        }

        void freeBlock(Block b) {
            b.next = this.next;
            this.next = b;
        }
    }
}

