/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.shaded.org.eclipse.jgit.internal.diffmergetool;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Map;
import net.pcal.fastback.shaded.org.eclipse.jgit.errors.NoWorkTreeException;
import net.pcal.fastback.shaded.org.eclipse.jgit.internal.diffmergetool.ExternalToolUtils;
import net.pcal.fastback.shaded.org.eclipse.jgit.internal.diffmergetool.ToolException;
import net.pcal.fastback.shaded.org.eclipse.jgit.util.FS;
import net.pcal.fastback.shaded.org.eclipse.jgit.util.FS_POSIX;
import net.pcal.fastback.shaded.org.eclipse.jgit.util.FS_Win32;
import net.pcal.fastback.shaded.org.eclipse.jgit.util.FS_Win32_Cygwin;
import net.pcal.fastback.shaded.org.eclipse.jgit.util.StringUtils;
import net.pcal.fastback.shaded.org.eclipse.jgit.util.SystemReader;

public class CommandExecutor {
    private FS fs;
    private boolean checkExitCode;
    private File commandFile;
    private boolean useMsys2;

    public CommandExecutor(FS fs, boolean checkExitCode) {
        this.fs = fs;
        this.checkExitCode = checkExitCode;
    }

    public FS.ExecutionResult run(String command, File workingDir, Map<String, String> env) throws ToolException, IOException, InterruptedException {
        String[] commandArray = this.createCommandArray(command);
        try {
            FS.ExecutionResult result;
            int rc;
            ProcessBuilder pb = this.fs.runInShell(commandArray[0], Arrays.copyOfRange(commandArray, 1, commandArray.length));
            pb.directory(workingDir);
            Map<String, String> envp = pb.environment();
            if (env != null) {
                envp.putAll(env);
            }
            if ((rc = (result = this.fs.execute(pb, null)).getRc()) != 0) {
                boolean execError = this.isCommandExecutionError(rc);
                if (this.checkExitCode || execError) {
                    throw new ToolException("JGit: tool execution return code: " + rc + "\n" + "checkExitCode: " + this.checkExitCode + "\n" + "execError: " + execError + "\n" + "stderr: \n" + new String(result.getStderr().toByteArray(), SystemReader.getInstance().getDefaultCharset()), result, execError);
                }
            }
            FS.ExecutionResult executionResult = result;
            return executionResult;
        }
        finally {
            this.deleteCommandArray();
        }
    }

    public boolean checkExecutable(String path, File workingDir, Map<String, String> env) throws ToolException, IOException, InterruptedException {
        this.checkUseMsys2(path);
        String command = null;
        if (this.fs instanceof FS_Win32 && !this.useMsys2) {
            Path p = Paths.get(path, new String[0]);
            if (p.isAbsolute() && Files.isExecutable(p)) {
                return true;
            }
            command = "where " + ExternalToolUtils.quotePath(path);
        } else {
            command = "which " + ExternalToolUtils.quotePath(path);
        }
        boolean available = true;
        try {
            FS.ExecutionResult rc = this.run(command, workingDir, env);
            if (rc.getRc() != 0) {
                available = false;
            }
        }
        catch (IOException | InterruptedException | NoWorkTreeException | ToolException exception) {
            // empty catch block
        }
        return available;
    }

    private void deleteCommandArray() {
        this.deleteCommandFile();
    }

    private String[] createCommandArray(String command) throws ToolException, IOException {
        String[] commandArray = null;
        this.checkUseMsys2(command);
        this.createCommandFile(command);
        if (this.fs instanceof FS_POSIX) {
            commandArray = new String[]{this.commandFile.getCanonicalPath()};
        } else if (this.fs instanceof FS_Win32) {
            commandArray = this.useMsys2 ? new String[]{"bash.exe", "-c", this.commandFile.getCanonicalPath().replace("\\", "/")} : new String[]{this.commandFile.getCanonicalPath()};
        } else if (this.fs instanceof FS_Win32_Cygwin) {
            commandArray = new String[]{this.commandFile.getCanonicalPath().replace("\\", "/")};
        } else {
            throw new ToolException("JGit: file system not supported: " + this.fs.toString());
        }
        return commandArray;
    }

    private void checkUseMsys2(String command) {
        this.useMsys2 = false;
        String useMsys2Str = System.getProperty("jgit.usemsys2bash");
        if (!StringUtils.isEmptyOrNull(useMsys2Str)) {
            this.useMsys2 = useMsys2Str.equalsIgnoreCase("auto") ? command.contains(".sh") : Boolean.parseBoolean(useMsys2Str);
        }
    }

    private void createCommandFile(String command) throws ToolException, IOException {
        String fileExtension = null;
        if (this.useMsys2 || this.fs instanceof FS_POSIX || this.fs instanceof FS_Win32_Cygwin) {
            fileExtension = ".sh";
        } else if (this.fs instanceof FS_Win32) {
            fileExtension = ".cmd";
            command = "@echo off" + System.lineSeparator() + command + System.lineSeparator() + "exit /B %ERRORLEVEL%";
        } else {
            throw new ToolException("JGit: file system not supported: " + this.fs.toString());
        }
        this.commandFile = File.createTempFile(".__", "__jgit_tool" + fileExtension);
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileOutputStream outStream = new FileOutputStream(this.commandFile);){
            byte[] strToBytes = command.getBytes(SystemReader.getInstance().getDefaultCharset());
            ((OutputStream)outStream).write(strToBytes);
            ((OutputStream)outStream).close();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.commandFile.setExecutable(true);
    }

    private void deleteCommandFile() {
        if (this.commandFile != null && this.commandFile.exists()) {
            this.commandFile.delete();
        }
    }

    private boolean isCommandExecutionError(int rc) {
        return this.useMsys2 || this.fs instanceof FS_POSIX || this.fs instanceof FS_Win32_Cygwin ? rc == 126 || rc == 127 : this.fs instanceof FS_Win32 && rc == 9009;
    }
}

