/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.shaded.org.eclipse.jgit.api;

import java.io.IOException;
import java.net.URISyntaxException;
import net.pcal.fastback.shaded.org.eclipse.jgit.api.GitCommand;
import net.pcal.fastback.shaded.org.eclipse.jgit.api.errors.GitAPIException;
import net.pcal.fastback.shaded.org.eclipse.jgit.api.errors.JGitInternalException;
import net.pcal.fastback.shaded.org.eclipse.jgit.lib.Repository;
import net.pcal.fastback.shaded.org.eclipse.jgit.lib.StoredConfig;
import net.pcal.fastback.shaded.org.eclipse.jgit.transport.RefSpec;
import net.pcal.fastback.shaded.org.eclipse.jgit.transport.RemoteConfig;
import net.pcal.fastback.shaded.org.eclipse.jgit.transport.URIish;

public class RemoteAddCommand
extends GitCommand<RemoteConfig> {
    private String name;
    private URIish uri;

    protected RemoteAddCommand(Repository repo) {
        super(repo);
    }

    public RemoteAddCommand setName(String name) {
        this.name = name;
        return this;
    }

    public RemoteAddCommand setUri(URIish uri) {
        this.uri = uri;
        return this;
    }

    @Override
    public RemoteConfig call() throws GitAPIException {
        this.checkCallable();
        try {
            StoredConfig config = this.repo.getConfig();
            RemoteConfig remote = new RemoteConfig(config, this.name);
            RefSpec refSpec = new RefSpec();
            refSpec = refSpec.setForceUpdate(true);
            refSpec = refSpec.setSourceDestination("refs/heads/*", "refs/remotes/" + this.name + "/*");
            remote.addFetchRefSpec(refSpec);
            remote.addURI(this.uri);
            remote.update(config);
            config.save();
            return remote;
        }
        catch (IOException | URISyntaxException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }
}

