/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.mod.forge;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.pcal.fastback.commands.Commands;
import net.pcal.fastback.logging.SystemLogger;
import net.pcal.fastback.logging.UserMessage;
import net.pcal.fastback.mod.LifecycleListener;
import net.pcal.fastback.mod.MinecraftProvider;
import net.pcal.fastback.mod.forge.Slf4jSystemLogger;
import net.pcal.fastback.mod.forge.SshHacks;
import org.slf4j.LoggerFactory;

class ForgeCommonProvider
implements MinecraftProvider {
    static final String MOD_ID = "fastback";
    private MinecraftServer logicalServer;
    private LifecycleListener lifecycleListener = null;
    private Runnable autoSaveListener;
    private boolean isWorldSaveEnabled;

    ForgeCommonProvider() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::onDedicatedServerStartupEvent);
        MinecraftForge.EVENT_BUS.addListener(this::onServerStartupEvent);
        MinecraftForge.EVENT_BUS.addListener(this::onServerStoppingEvent);
        MinecraftForge.EVENT_BUS.addListener(this::onRegisterCommandEvent);
    }

    private void onDedicatedServerStartupEvent(FMLDedicatedServerSetupEvent event) {
        this.onInitialize();
    }

    private void onServerStartupEvent(ServerStartedEvent event) {
        this.logicalServer = event.getServer();
        Objects.requireNonNull(this.lifecycleListener).onWorldStart();
    }

    private void onServerStoppingEvent(ServerStoppingEvent event) {
        Objects.requireNonNull(this.lifecycleListener).onWorldStop();
        this.logicalServer = null;
    }

    private void onRegisterCommandEvent(RegisterCommandsEvent event) {
        CommandDispatcher commandDispatcher = event.getDispatcher();
        LiteralArgumentBuilder<CommandSourceStack> backupCommand = Commands.createBackupCommand(permName -> x -> true);
        commandDispatcher.register(backupCommand);
    }

    void onInitialize() {
        SystemLogger.Singleton.register(new Slf4jSystemLogger(LoggerFactory.getLogger((String)MOD_ID)));
        this.lifecycleListener = MinecraftProvider.register(this);
        SystemLogger.syslog().debug("registered backup command");
        this.lifecycleListener.onInitialize();
        SshHacks.ensureSshSessionFactoryIsAvailable();
        SystemLogger.syslog().info("Fastback initialized");
        SystemLogger.syslog().warn("------------------------------------------------------------------------------------");
        SystemLogger.syslog().warn("Thanks for trying the new Forge version of Fastback.  For help, go to:");
        SystemLogger.syslog().warn("https://pcal43.github.io/fastback/");
        SystemLogger.syslog().warn("Please note that this is an alpha release.  A list of known issues is available here:");
        SystemLogger.syslog().warn("https://github.com/pcal43/fastback/issues?q=is%3Aissue+is%3Aopen+label%3Aforge");
        SystemLogger.syslog().warn("------------------------------------------------------------------------------------");
    }

    @Override
    public boolean isClient() {
        return false;
    }

    @Override
    public void setHudText(UserMessage userMessage) {
    }

    @Override
    public void clearHudText() {
    }

    @Override
    public void setMessageScreenText(UserMessage userMessage) {
    }

    void renderOverlayText(GuiGraphics drawContext) {
    }

    @Override
    public String getModVersion() {
        return "0.15.3+1.20.1-alpha";
    }

    void onAutoSaveComplete() {
        SystemLogger.syslog().debug("onAutoSaveComplete");
        this.autoSaveListener.run();
    }

    @Override
    public Path getWorldDirectory() {
        if (this.logicalServer == null) {
            throw new IllegalStateException("minecraftServer is null");
        }
        LevelStorageSource.LevelStorageAccess session = this.logicalServer.f_129744_;
        Path out = session.getWorldDir().toAbsolutePath().normalize();
        return out;
    }

    @Override
    public void setWorldSaveEnabled(boolean enabled) {
        for (ServerLevel world : this.logicalServer.m_129785_()) {
            world.f_8564_ = !enabled;
        }
    }

    @Override
    public void saveWorld() {
        if (this.logicalServer == null) {
            throw new IllegalStateException();
        }
        this.logicalServer.m_195514_(false, true, true);
    }

    @Override
    public void sendBroadcast(UserMessage userMessage) {
        if (this.logicalServer != null && this.logicalServer.m_6982_()) {
            this.logicalServer.m_6846_().m_240416_(MinecraftProvider.messageToText(userMessage), false);
        }
    }

    @Override
    public void setAutoSaveListener(Runnable runnable) {
        this.autoSaveListener = Objects.requireNonNull(runnable);
    }

    @Override
    public Path getSavesDir() {
        if (this.isClient()) {
            return this.logicalServer.m_6237_().toPath().resolve("saves");
        }
        return null;
    }

    @Override
    public String getWorldName() {
        LevelSummary ls = this.logicalServer.f_129744_.m_78308_();
        if (ls == null) {
            return null;
        }
        LevelSettings li = ls.m_164913_();
        if (li == null) {
            return null;
        }
        return li.m_46917_();
    }

    @Override
    public void addBackupProperties(Map<String, String> props) {
        props.put("fastback-version", this.getModVersion());
        if (this.logicalServer != null) {
            props.put("minecraft-version", this.logicalServer.m_7630_());
            props.put("minecraft-game-mode", String.valueOf(this.logicalServer.m_129910_().m_5464_()));
            props.put("minecraft-level-name", this.logicalServer.m_129910_().m_5462_());
        }
    }

    @Override
    public Collection<Path> getModsBackupPaths() {
        ArrayList<Path> out = new ArrayList<Path>();
        return out;
    }
}

