/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.mod;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.pcal.fastback.logging.UserMessage;
import net.pcal.fastback.mod.LifecycleListener;
import net.pcal.fastback.mod.Mod;
import net.pcal.fastback.mod.ModImpl;

public interface MinecraftProvider {
    public static LifecycleListener register(MinecraftProvider sp) {
        ModImpl mod = new ModImpl(sp);
        Mod.Singleton.register(mod);
        return mod;
    }

    public String getModVersion();

    public Path getSavesDir();

    public Path getWorldDirectory();

    public String getWorldName();

    public boolean isClient();

    public void sendBroadcast(UserMessage var1);

    public void setWorldSaveEnabled(boolean var1);

    public void saveWorld();

    public void setHudText(UserMessage var1);

    public void clearHudText();

    public void setMessageScreenText(UserMessage var1);

    public void setAutoSaveListener(Runnable var1);

    public void addBackupProperties(Map<String, String> var1);

    public Collection<Path> getModsBackupPaths();

    default public void sendChat(UserMessage message, CommandSourceStack scs) {
        if (message.style() == UserMessage.UserMessageStyle.ERROR) {
            scs.m_81352_(MinecraftProvider.messageToText(message));
        } else {
            scs.m_288197_(() -> MinecraftProvider.messageToText(message), false);
        }
    }

    public static Component messageToText(UserMessage m) {
        MutableComponent out = m.localized() != null ? Component.m_237110_((String)m.localized().key(), (Object[])m.localized().params()) : Component.m_237113_((String)m.raw());
        switch (m.style()) {
            case ERROR: {
                out.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131268_((String)"red")));
                break;
            }
            case WARNING: {
                out.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131268_((String)"yellow")));
                break;
            }
            case JGIT: {
                out.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131268_((String)"gray")));
                break;
            }
            case NATIVE_GIT: {
                out.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131268_((String)"green")));
                break;
            }
            case BROADCAST: {
                out.m_6270_(Style.f_131099_.m_131155_(Boolean.valueOf(true)));
                break;
            }
            default: {
                out.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131268_((String)"white")));
            }
        }
        return out;
    }
}

