/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.mod;

import java.nio.file.Path;
import java.time.Duration;
import net.pcal.fastback.commands.SchedulableAction;
import net.pcal.fastback.config.FastbackConfigKey;
import net.pcal.fastback.config.GitConfig;
import net.pcal.fastback.logging.SystemLogger;
import net.pcal.fastback.logging.UserLogger;
import net.pcal.fastback.mod.Mod;
import net.pcal.fastback.repo.Repo;
import net.pcal.fastback.repo.RepoFactory;
import net.pcal.fastback.utils.Executor;

class AutosaveListener
implements Runnable {
    private long lastBackupTime = System.currentTimeMillis();

    AutosaveListener() {
    }

    @Override
    public void run() {
        try (UserLogger ulog = UserLogger.forAutosave();){
            Executor.executor().execute(Executor.ExecutionLock.WRITE, ulog, () -> {
                try {
                    RepoFactory rf = RepoFactory.rf();
                    Path worldSaveDir = Mod.mod().getWorldDirectory();
                    if (!rf.isGitRepo(worldSaveDir)) {
                        return;
                    }
                    try (Repo repo = rf.load(worldSaveDir);){
                        GitConfig config = repo.getConfig();
                        if (!config.getBoolean(FastbackConfigKey.IS_BACKUP_ENABLED)) {
                            return;
                        }
                        SchedulableAction autobackAction = SchedulableAction.forConfigValue(config, FastbackConfigKey.AUTOBACK_ACTION);
                        if (autobackAction == null || autobackAction == SchedulableAction.NONE) {
                            return;
                        }
                        Duration waitTime = Duration.ofMinutes(config.getInt(FastbackConfigKey.AUTOBACK_WAIT_MINUTES));
                        Duration timeRemaining = waitTime.minus(Duration.ofMillis(System.currentTimeMillis() - this.lastBackupTime));
                        if (!timeRemaining.isZero() && !timeRemaining.isNegative()) {
                            SystemLogger.syslog().debug("Skipping auto-backup until at least " + timeRemaining.toSeconds() / 60L + " more minutes have elapsed.");
                            return;
                        }
                        SystemLogger.syslog().info("Starting auto-backup");
                        autobackAction.getTask(repo, ulog).call();
                    }
                    this.lastBackupTime = System.currentTimeMillis();
                }
                catch (Exception e) {
                    SystemLogger.syslog().error("auto-backup failed.", e);
                }
            });
        }
    }
}

