/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.v3.rendering.ui.widget.editbox;

import de.keksuccino.fancymenu.mixin.client.IMixinEditBox;
import de.keksuccino.fancymenu.v3.input.CharacterFilter;
import de.keksuccino.fancymenu.v3.rendering.DrawableColor;
import de.keksuccino.fancymenu.v3.rendering.ui.UIBase;
import de.keksuccino.fancymenu.v3.rendering.ui.widget.UniqueWidget;
import java.awt.Color;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtendedEditBox
extends EditBox
implements UniqueWidget {
    protected CharacterFilter characterFilter;
    protected CharacterRenderFormatter characterRenderFormatter;
    protected DrawableColor backgroundColor = DrawableColor.of(new Color(0, 0, 0));
    protected DrawableColor borderNormalColor = DrawableColor.of(new Color(-6250336));
    protected DrawableColor borderFocusedColor = DrawableColor.of(new Color(255, 255, 255));
    protected DrawableColor f_94103_ = DrawableColor.of(new Color(0xE0E0E0));
    protected DrawableColor f_94104_ = DrawableColor.of(new Color(0x707070));
    protected DrawableColor suggestionTextColor = DrawableColor.of(new Color(-8355712));
    protected boolean textShadow = true;
    protected final Font f_94092_;
    @Nullable
    protected String identifier;

    public ExtendedEditBox(Font font, int x, int y, int width, int height, Component hint) {
        super(font, x, y, width, height, hint);
        this.f_94092_ = font;
    }

    public ExtendedEditBox(Font font, int x, int y, int width, int height, @Nullable EditBox editBox, Component hint) {
        super(font, x, y, width, height, editBox, hint);
        this.f_94092_ = font;
    }

    public void m_87963_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        IMixinEditBox access = (IMixinEditBox)((Object)this);
        boolean bordered = access.getBorderedFancyMenu();
        if (this.m_94213_()) {
            Component hint;
            graphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, this.backgroundColor.getColorInt());
            if (bordered) {
                int borderColor = this.m_93696_() ? this.borderFocusedColor.getColorInt() : this.borderNormalColor.getColorInt();
                UIBase.renderBorder(graphics.m_280168_(), (float)(this.m_252754_() - 1), (float)(this.m_252907_() - 1), (float)(this.m_252754_() + this.f_93618_ + 1), (float)(this.m_252907_() + this.f_93619_ + 1), 1.0f, borderColor, true, true, true, true);
            }
            int textColor = access.getIsEditableFancyMenu() ? this.f_94103_.getColorInt() : this.f_94104_.getColorInt();
            int cursorPos = this.m_94207_() - access.getDisplayPosFancyMenu();
            int highlightPos = access.getHighlightPosFancyMenu() - access.getDisplayPosFancyMenu();
            String text = this.f_94092_.m_92834_(this.m_94155_().substring(access.getDisplayPosFancyMenu()), this.m_94210_());
            boolean isCursorInsideVisibleText = cursorPos >= 0 && cursorPos <= text.length();
            boolean isCursorVisible = this.m_93696_() && access.getFrameFancyMenu() / 6 % 2 == 0 && isCursorInsideVisibleText;
            int textX = bordered ? this.m_252754_() + 4 : this.m_252754_();
            int textY = bordered ? this.m_252907_() + (this.f_93619_ - 8) / 2 : this.m_252907_();
            int textXAfterCursor = textX;
            if (highlightPos > text.length()) {
                highlightPos = text.length();
            }
            int textCharacterRenderIndex = access.getDisplayPosFancyMenu();
            if (!text.isEmpty()) {
                String textBeforeCursor = isCursorInsideVisibleText ? text.substring(0, cursorPos) : text;
                MutableComponent beforeCursorComp = Component.m_237113_((String)"");
                if (this.characterRenderFormatter == null) {
                    beforeCursorComp = Component.m_237113_((String)textBeforeCursor);
                } else {
                    for (char c : textBeforeCursor.toCharArray()) {
                        MutableComponent comp = this.characterRenderFormatter.formatComponent(this, Component.m_237113_((String)String.valueOf(c)), textCharacterRenderIndex, c, text, this.m_94155_());
                        beforeCursorComp.m_7220_((Component)comp);
                        ++textCharacterRenderIndex;
                    }
                }
                textXAfterCursor = graphics.m_280614_(this.f_94092_, (Component)beforeCursorComp, textX, textY, textColor, this.textShadow);
            }
            boolean renderSmallCursor = this.m_94207_() < this.m_94155_().length() || this.m_94155_().length() >= access.getMaxLengthFancyMenu();
            int finalTextXAfterCursor = textXAfterCursor;
            if (!isCursorInsideVisibleText) {
                finalTextXAfterCursor = cursorPos > 0 ? textX + this.f_93618_ : textX;
            } else if (renderSmallCursor) {
                finalTextXAfterCursor = textXAfterCursor - 1;
                if (this.textShadow) {
                    --textXAfterCursor;
                }
            }
            if (!text.isEmpty() && isCursorInsideVisibleText && cursorPos < text.length()) {
                String textAfterCursor = text.substring(cursorPos);
                MutableComponent afterCursorComp = Component.m_237113_((String)"");
                if (this.characterRenderFormatter == null) {
                    afterCursorComp = Component.m_237113_((String)textAfterCursor);
                } else {
                    for (char c : textAfterCursor.toCharArray()) {
                        MutableComponent comp = this.characterRenderFormatter.formatComponent(this, Component.m_237113_((String)String.valueOf(c)), textCharacterRenderIndex, c, text, this.m_94155_());
                        afterCursorComp.m_7220_((Component)comp);
                        ++textCharacterRenderIndex;
                    }
                }
                graphics.m_280614_(this.f_94092_, (Component)afterCursorComp, textXAfterCursor, textY, textColor, this.textShadow);
            }
            if ((hint = access.getHintFancyMenu()) != null && text.isEmpty() && !this.m_93696_()) {
                graphics.m_280614_(this.f_94092_, hint, textXAfterCursor, textY, textColor, this.textShadow);
            }
            if (!renderSmallCursor && access.getSuggestionFancyMenu() != null) {
                graphics.m_280056_(this.f_94092_, access.getSuggestionFancyMenu(), finalTextXAfterCursor - 1, textY, this.suggestionTextColor.getColorInt(), this.textShadow);
            }
            if (isCursorVisible) {
                if (renderSmallCursor) {
                    graphics.m_280509_(finalTextXAfterCursor, textY - 1, finalTextXAfterCursor + 1, textY + 1 + 9, textColor);
                } else {
                    Objects.requireNonNull(this.f_94092_);
                    Objects.requireNonNull(this.f_94092_);
                    graphics.m_280509_(finalTextXAfterCursor, textY + 9 - 2, finalTextXAfterCursor + 5, textY + 9 - 1, textColor);
                }
            }
            if (highlightPos != cursorPos) {
                int l1 = textX + this.f_94092_.m_92895_(text.substring(0, highlightPos));
                access.invokeRenderHighlightFancyMenu(graphics, finalTextXAfterCursor, textY - 1, l1 - 1, textY + 1 + 9);
            }
        }
    }

    public void setHeight(int height) {
        this.f_93619_ = height;
    }

    public int getDisplayPosition() {
        return ((IMixinEditBox)((Object)this)).getDisplayPosFancyMenu();
    }

    public void setDisplayPosition(int position) {
        ((IMixinEditBox)((Object)this)).setDisplayPosFancyMenu(position);
    }

    @Nullable
    public CharacterFilter getCharacterFilter() {
        return this.characterFilter;
    }

    public ExtendedEditBox setCharacterFilter(@Nullable CharacterFilter characterFilter) {
        this.characterFilter = characterFilter;
        return this;
    }

    public boolean hasTextShadow() {
        return this.textShadow;
    }

    public ExtendedEditBox setTextShadow(boolean textShadow) {
        this.textShadow = textShadow;
        return this;
    }

    @NotNull
    public DrawableColor getBackgroundColor() {
        return this.backgroundColor;
    }

    public ExtendedEditBox setBackgroundColor(@NotNull DrawableColor backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    @NotNull
    public DrawableColor getBorderNormalColor() {
        return this.borderNormalColor;
    }

    public ExtendedEditBox setBorderNormalColor(@NotNull DrawableColor borderNormalColor) {
        this.borderNormalColor = borderNormalColor;
        return this;
    }

    @NotNull
    public DrawableColor getBorderFocusedColor() {
        return this.borderFocusedColor;
    }

    public ExtendedEditBox setBorderFocusedColor(@NotNull DrawableColor borderFocusedColor) {
        this.borderFocusedColor = borderFocusedColor;
        return this;
    }

    @Nullable
    public CharacterRenderFormatter getCharacterRenderFormatter() {
        return this.characterRenderFormatter;
    }

    public ExtendedEditBox setCharacterRenderFormatter(@Nullable CharacterRenderFormatter characterRenderFormatter) {
        this.characterRenderFormatter = characterRenderFormatter;
        return this;
    }

    @NotNull
    public DrawableColor getTextColor() {
        return this.f_94103_;
    }

    public ExtendedEditBox setTextColor(@NotNull DrawableColor textColor) {
        this.f_94103_ = textColor;
        return this;
    }

    @NotNull
    public DrawableColor getTextColorUneditable() {
        return this.f_94104_;
    }

    public ExtendedEditBox setTextColorUneditable(@NotNull DrawableColor textColorUneditable) {
        this.f_94104_ = textColorUneditable;
        return this;
    }

    @NotNull
    public DrawableColor getSuggestionTextColor() {
        return this.suggestionTextColor;
    }

    public ExtendedEditBox setSuggestionTextColor(@NotNull DrawableColor suggestionTextColor) {
        this.suggestionTextColor = suggestionTextColor;
        return this;
    }

    @Deprecated
    public void m_94202_(int color) {
        this.f_94103_ = DrawableColor.of(new Color(color));
    }

    @Deprecated
    public void m_94205_(int color) {
        this.f_94104_ = DrawableColor.of(new Color(color));
    }

    public boolean m_5534_(char character, int modifiers) {
        if (this.characterFilter != null && !this.characterFilter.isAllowedChar(character)) {
            return false;
        }
        return super.m_5534_(character, modifiers);
    }

    public void m_94164_(@NotNull String textToWrite) {
        if (this.characterFilter != null) {
            textToWrite = this.characterFilter.filterForAllowedChars(textToWrite);
        }
        super.m_94164_(textToWrite);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        return false;
    }

    public ExtendedEditBox setWidgetIdentifierFancyMenu(@Nullable String identifier) {
        this.identifier = identifier;
        return this;
    }

    @Override
    @Nullable
    public String getWidgetIdentifierFancyMenu() {
        return this.identifier;
    }

    @FunctionalInterface
    public static interface CharacterRenderFormatter {
        @NotNull
        public MutableComponent formatComponent(@NotNull ExtendedEditBox var1, @NotNull MutableComponent var2, int var3, char var4, @NotNull String var5, @NotNull String var6);
    }
}

