/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.panorama;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import com.mojang.math.Axis;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.properties.PropertiesSerializer;
import de.keksuccino.konkrete.properties.PropertiesSet;
import de.keksuccino.konkrete.resources.ExternalTextureResourceLocation;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;

public class ExternalTexturePanoramaRenderer {
    private ExternalTextureResourceLocation overlay_texture;
    private float time;
    private String name = null;
    public String dir;
    private boolean prepared = false;
    private List<ExternalTextureResourceLocation> pano = new ArrayList<ExternalTextureResourceLocation>();
    private float speed = 1.0f;
    private double fov = 85.0;
    private float angle = 25.0f;
    private Minecraft mc = Minecraft.m_91087_();
    public float opacity = 1.0f;

    public ExternalTexturePanoramaRenderer(String panoDir) {
        this.dir = panoDir;
        File props = new File(this.dir + "/properties.txt");
        if (props.exists()) {
            PropertiesSet s = PropertiesSerializer.getProperties((String)props.getPath());
            if (s != null) {
                List l = s.getPropertiesOfType("panorama-meta");
                if (l != null && !l.isEmpty()) {
                    String an;
                    String fo;
                    String sp;
                    this.name = ((PropertiesSection)l.get(0)).getEntryValue("name");
                    if (this.name == null) {
                        System.out.println("############## ERROR [FANCYMENU] ##############");
                        System.out.println("Missing 'name' value in properties file for panorama cube: " + this.dir);
                        System.out.println("###############################################");
                    }
                    if ((sp = ((PropertiesSection)l.get(0)).getEntryValue("speed")) != null && MathUtils.isFloat((String)sp)) {
                        this.speed = Float.parseFloat(sp);
                    }
                    if ((fo = ((PropertiesSection)l.get(0)).getEntryValue("fov")) != null && MathUtils.isDouble((String)fo)) {
                        this.fov = Double.parseDouble(fo);
                    }
                    if ((an = ((PropertiesSection)l.get(0)).getEntryValue("angle")) != null && MathUtils.isFloat((String)an)) {
                        this.angle = Float.parseFloat(an);
                    }
                } else {
                    System.out.println("############## ERROR [FANCYMENU] ##############");
                    System.out.println("Missing 'panorama-meta' section in properties file for panorama cube: " + this.dir);
                    System.out.println("###############################################");
                }
            } else {
                System.out.println("############## ERROR [FANCYMENU] ##############");
                System.out.println("An error happened while trying to get properties for panorama cube: " + this.dir);
                System.out.println("###############################################");
            }
        } else {
            System.out.println("############## ERROR [FANCYMENU] ##############");
            System.out.println("Properties file not found for panorama cube: " + this.dir);
            System.out.println("###############################################");
        }
    }

    public void preparePanorama() {
        File imagesDir;
        if (!this.prepared && this.name != null && (imagesDir = new File(this.dir + "/panorama")).exists() && imagesDir.isDirectory()) {
            for (int i = 0; i < 6; ++i) {
                File f = new File(this.dir + "/panorama/panorama_" + i + ".png");
                if (!f.exists() || !f.isFile()) {
                    System.out.println("############## ERROR [FANCYMENU] ##############");
                    System.out.println("Missing panorama image 'panorama_" + i + ".png' for panorama cube: " + this.name);
                    System.out.println("###############################################");
                    return;
                }
                ExternalTextureResourceLocation r = new ExternalTextureResourceLocation(f.getPath());
                this.pano.add(r);
            }
            File overlay = new File(this.dir + "/overlay.png");
            if (overlay.exists()) {
                this.overlay_texture = new ExternalTextureResourceLocation(overlay.getPath());
            }
            this.prepared = true;
        }
    }

    public void render(GuiGraphics graphics) {
        try {
            this.renderRaw(graphics, this.opacity);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void renderRaw(GuiGraphics graphics, float panoramaAlpha) {
        if (this.prepared) {
            this.time += Minecraft.m_91087_().m_91297_() * this.speed;
            float pitch = Mth.m_14031_((float)(this.time * 0.001f)) * 5.0f + this.angle;
            float yaw = -this.time * 0.1f;
            float fovf = (float)this.fov * ((float)Math.PI / 180);
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder bufferBuilder = tesselator.m_85915_();
            Matrix4f matrix4f = new Matrix4f().setPerspective(fovf, (float)this.mc.m_91268_().m_85441_() / (float)this.mc.m_91268_().m_85442_(), 0.05f, 10.0f);
            RenderSystem.backupProjectionMatrix();
            RenderSystem.setProjectionMatrix((Matrix4f)matrix4f, (VertexSorting)VertexSorting.f_276450_);
            PoseStack matrix = RenderSystem.getModelViewStack();
            matrix.m_85836_();
            matrix.m_166856_();
            matrix.m_252781_(Axis.f_252529_.m_252977_(180.0f));
            RenderSystem.applyModelViewMatrix();
            RenderSystem.setShader(GameRenderer::m_172820_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.opacity);
            RenderSystem.enableBlend();
            RenderSystem.disableCull();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.defaultBlendFunc();
            for (int j = 0; j < 4; ++j) {
                matrix.m_85836_();
                float k = ((float)(j % 2) / 2.0f - 0.5f) / 256.0f;
                float l = ((float)(j / 2) / 2.0f - 0.5f) / 256.0f;
                matrix.m_252880_(k, l, 0.0f);
                matrix.m_252781_(Axis.f_252529_.m_252977_(pitch));
                matrix.m_252781_(Axis.f_252436_.m_252977_(yaw));
                RenderSystem.applyModelViewMatrix();
                for (int n = 0; n < 6; ++n) {
                    ExternalTextureResourceLocation r = this.pano.get(n);
                    if (r == null) continue;
                    if (!r.isReady()) {
                        r.loadTexture();
                    }
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)r.getResourceLocation());
                    bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
                    int o = Math.round(255.0f * panoramaAlpha) / (j + 1);
                    if (n == 0) {
                        bufferBuilder.m_5483_(-1.0, -1.0, 1.0).m_7421_(0.0f, 0.0f).m_6122_(255, 255, 255, o).m_5752_();
                        bufferBuilder.m_5483_(-1.0, 1.0, 1.0).m_7421_(0.0f, 1.0f).m_6122_(255, 255, 255, o).m_5752_();
                        bufferBuilder.m_5483_(1.0, 1.0, 1.0).m_7421_(1.0f, 1.0f).m_6122_(255, 255, 255, o).m_5752_();
                        bufferBuilder.m_5483_(1.0, -1.0, 1.0).m_7421_(1.0f, 0.0f).m_6122_(255, 255, 255, o).m_5752_();
                    }
                    if (n == 1) {
                        bufferBuilder.m_5483_(1.0, -1.0, 1.0).m_7421_(0.0f, 0.0f).m_6122_(255, 255, 255, o).m_5752_();
                        bufferBuilder.m_5483_(1.0, 1.0, 1.0).m_7421_(0.0f, 1.0f).m_6122_(255, 255, 255, o).m_5752_();
                        bufferBuilder.m_5483_(1.0, 1.0, -1.0).m_7421_(1.0f, 1.0f).m_6122_(255, 255, 255, o).m_5752_();
                        bufferBuilder.m_5483_(1.0, -1.0, -1.0).m_7421_(1.0f, 0.0f).m_6122_(255, 255, 255, o).m_5752_();
                    }
                    if (n == 2) {
                        bufferBuilder.m_5483_(1.0, -1.0, -1.0).m_7421_(0.0f, 0.0f).m_6122_(255, 255, 255, o).m_5752_();
                        bufferBuilder.m_5483_(1.0, 1.0, -1.0).m_7421_(0.0f, 1.0f).m_6122_(255, 255, 255, o).m_5752_();
                        bufferBuilder.m_5483_(-1.0, 1.0, -1.0).m_7421_(1.0f, 1.0f).m_6122_(255, 255, 255, o).m_5752_();
                        bufferBuilder.m_5483_(-1.0, -1.0, -1.0).m_7421_(1.0f, 0.0f).m_6122_(255, 255, 255, o).m_5752_();
                    }
                    if (n == 3) {
                        bufferBuilder.m_5483_(-1.0, -1.0, -1.0).m_7421_(0.0f, 0.0f).m_6122_(255, 255, 255, o).m_5752_();
                        bufferBuilder.m_5483_(-1.0, 1.0, -1.0).m_7421_(0.0f, 1.0f).m_6122_(255, 255, 255, o).m_5752_();
                        bufferBuilder.m_5483_(-1.0, 1.0, 1.0).m_7421_(1.0f, 1.0f).m_6122_(255, 255, 255, o).m_5752_();
                        bufferBuilder.m_5483_(-1.0, -1.0, 1.0).m_7421_(1.0f, 0.0f).m_6122_(255, 255, 255, o).m_5752_();
                    }
                    if (n == 4) {
                        bufferBuilder.m_5483_(-1.0, -1.0, -1.0).m_7421_(0.0f, 0.0f).m_6122_(255, 255, 255, o).m_5752_();
                        bufferBuilder.m_5483_(-1.0, -1.0, 1.0).m_7421_(0.0f, 1.0f).m_6122_(255, 255, 255, o).m_5752_();
                        bufferBuilder.m_5483_(1.0, -1.0, 1.0).m_7421_(1.0f, 1.0f).m_6122_(255, 255, 255, o).m_5752_();
                        bufferBuilder.m_5483_(1.0, -1.0, -1.0).m_7421_(1.0f, 0.0f).m_6122_(255, 255, 255, o).m_5752_();
                    }
                    if (n == 5) {
                        bufferBuilder.m_5483_(-1.0, 1.0, 1.0).m_7421_(0.0f, 0.0f).m_6122_(255, 255, 255, o).m_5752_();
                        bufferBuilder.m_5483_(-1.0, 1.0, -1.0).m_7421_(0.0f, 1.0f).m_6122_(255, 255, 255, o).m_5752_();
                        bufferBuilder.m_5483_(1.0, 1.0, -1.0).m_7421_(1.0f, 1.0f).m_6122_(255, 255, 255, o).m_5752_();
                        bufferBuilder.m_5483_(1.0, 1.0, 1.0).m_7421_(1.0f, 0.0f).m_6122_(255, 255, 255, o).m_5752_();
                    }
                    tesselator.m_85914_();
                }
                matrix.m_85849_();
                RenderSystem.applyModelViewMatrix();
                RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            }
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            RenderSystem.restoreProjectionMatrix();
            matrix.m_85849_();
            RenderSystem.applyModelViewMatrix();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableCull();
            RenderSystem.enableDepthTest();
            if (this.overlay_texture != null) {
                if (!this.overlay_texture.isReady()) {
                    this.overlay_texture.loadTexture();
                }
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.opacity);
                RenderSystem.enableBlend();
                Screen screen = Minecraft.m_91087_().f_91080_;
                if (screen == null) {
                    screen = new TitleScreen();
                }
                graphics.m_280163_(this.overlay_texture.getResourceLocation(), 0, 0, 0.0f, 0.0f, screen.f_96543_, Minecraft.m_91087_().f_91080_.f_96544_, Minecraft.m_91087_().f_91080_.f_96543_, Minecraft.m_91087_().f_91080_.f_96544_);
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public String getName() {
        return this.name;
    }

    public void setSpeed(float speed) {
        if (speed < 0.0f) {
            speed = 0.0f;
        }
        this.speed = speed;
    }

    public void setFov(double fov) {
        if (fov > 179.0) {
            fov = 179.0;
        }
        this.fov = fov;
    }

    public void setAngle(float angle) {
        this.angle = angle;
    }
}

