/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.item.items.playerentity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import de.keksuccino.fancymenu.menu.fancy.item.items.playerentity.render.PlayerEntityModel;
import de.keksuccino.fancymenu.menu.fancy.item.items.playerentity.render.PlayerEntityProperties;
import de.keksuccino.fancymenu.menu.fancy.item.items.playerentity.render.layers.PlayerEntityCapeLayer;
import de.keksuccino.fancymenu.menu.fancy.item.items.playerentity.render.layers.PlayerEntityRenderLayer;
import de.keksuccino.fancymenu.menu.fancy.item.items.playerentity.render.layers.PlayerEntityShoulderParrotLayer;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class PlayerEntityItemRenderer
extends PlayerRenderer {
    private static final EntityModelSet ENTITY_MODEL_SET = Minecraft.m_91087_().m_167973_();
    private static final EntityRendererProvider.Context RENDER_CONTEXT = new EntityRendererProvider.Context(Minecraft.m_91087_().m_91290_(), Minecraft.m_91087_().m_91291_(), Minecraft.m_91087_().m_91289_(), Minecraft.m_91087_().m_91290_().m_234586_(), Minecraft.m_91087_().m_91098_(), ENTITY_MODEL_SET, Minecraft.m_91087_().f_91062_);
    public final PlayerEntityProperties properties;
    public final PlayerEntityModel playerModel;

    public PlayerEntityItemRenderer(boolean slim) {
        super(RENDER_CONTEXT, slim);
        this.properties = new PlayerEntityProperties(slim);
        this.playerModel = new PlayerEntityModel(RENDER_CONTEXT.m_174023_(slim ? ModelLayers.f_171166_ : ModelLayers.f_171162_), slim, this.properties);
        this.m_115326_(new PlayerEntityShoulderParrotLayer(this, RENDER_CONTEXT.m_174027_(), this.properties));
        this.m_115326_(new PlayerEntityCapeLayer(this, this.properties));
    }

    public void renderPlayerEntityItem(double d11, double d12, double d13, float f11, float f12, PoseStack pose, MultiBufferSource bufferSource, int i11) {
        try {
            Vec3 vec3 = this.m_7860_((AbstractClientPlayer)null, f12);
            double d2 = d11 + vec3.m_7096_();
            double d3 = d12 + vec3.m_7098_();
            double d0 = d13 + vec3.m_7094_();
            pose.m_85836_();
            pose.m_85837_(d2, d3, d0);
            this.render(f11, f12, pose, bufferSource, i11);
            pose.m_85837_(-vec3.m_7096_(), -vec3.m_7098_(), -vec3.m_7094_());
            pose.m_85849_();
        }
        catch (Exception ex) {
            CrashReport crashreport = CrashReport.m_127521_((Throwable)ex, (String)"FancyMenu: Rendering player entity item");
            CrashReportCategory crashreportcategory1 = crashreport.m_127514_("Renderer details");
            crashreportcategory1.m_128159_("Rotation", (Object)Float.valueOf(f11));
            crashreportcategory1.m_128159_("Delta", (Object)Float.valueOf(f12));
            throw new ReportedException(crashreport);
        }
    }

    protected void render(float f11, float f12, PoseStack graphics, MultiBufferSource bufferSource, int i11) {
        this.setModelProperties();
        this.innerRender(f11, f12, graphics, bufferSource, i11);
    }

    protected void innerRender(float f11, float f12, PoseStack graphics, MultiBufferSource bufferSource, int i11) {
        Direction direction;
        boolean shouldSit;
        graphics.m_85836_();
        this.playerModel.f_102609_ = shouldSit = this.properties.shouldSit;
        this.playerModel.f_102610_ = this.properties.isBaby;
        float f = Mth.m_14189_((float)f12, (float)this.properties.yBodyRotO, (float)this.properties.yBodyRot);
        float f1 = Mth.m_14189_((float)f12, (float)this.properties.yHeadRotO, (float)this.properties.yHeadRot);
        float f2 = f1 - f;
        float f6 = Mth.m_14179_((float)f12, (float)this.properties.xRotO, (float)this.properties.xRot);
        if (this.properties.hasPose(Pose.SLEEPING) && (direction = this.properties.getBedOrientation()) != null) {
            float f4 = this.properties.getEyeHeight(Pose.STANDING) - 0.1f;
            graphics.m_252880_((float)(-direction.m_122429_()) * f4, 0.0f, (float)(-direction.m_122431_()) * f4);
        }
        float f7 = f12;
        this.setupRotations(graphics, f7, f, f12);
        graphics.m_85841_(-1.0f, -1.0f, 1.0f);
        this.scale(graphics, f12);
        graphics.m_252880_(0.0f, -1.501f, 0.0f);
        float f8 = 0.0f;
        float f5 = 0.0f;
        if (!shouldSit) {
            f8 = Mth.m_14179_((float)f12, (float)this.properties.animationSpeedOld, (float)this.properties.animationSpeed);
            f5 = this.properties.animationPosition - this.properties.animationSpeed * (1.0f - f12);
            if (this.properties.isBaby) {
                f5 *= 3.0f;
            }
            if (f8 > 1.0f) {
                f8 = 1.0f;
            }
        }
        this.playerModel.setupAnimWithoutEntity(f5, f8, f7, f2, f6);
        Minecraft minecraft = Minecraft.m_91087_();
        boolean flag = !this.properties.invisible;
        boolean flag1 = false;
        boolean glowing = this.properties.glowing;
        RenderType rendertype = this.getRenderType(null, flag, flag1, glowing);
        if (rendertype != null) {
            VertexConsumer vertexconsumer = bufferSource.m_6299_(rendertype);
            int i = OverlayTexture.m_118093_((int)OverlayTexture.m_118088_((float)this.m_6931_(null, f12)), (int)OverlayTexture.m_118096_((boolean)false));
            this.playerModel.m_7695_(graphics, vertexconsumer, i11, i, 1.0f, 1.0f, 1.0f, flag1 ? 0.15f : 1.0f);
        }
        if (!this.properties.isSpectator()) {
            for (RenderLayer renderlayer : this.f_115291_) {
                if (!(renderlayer instanceof PlayerEntityRenderLayer)) continue;
                renderlayer.m_6494_(graphics, bufferSource, i11, null, f5, f8, f12, f7, f2, f6);
            }
        }
        graphics.m_85849_();
        if (this.properties.showDisplayName) {
            this.m_7649_((AbstractClientPlayer)null, this.properties.displayName, graphics, bufferSource, i11);
        }
    }

    protected void scale(PoseStack graphics, float f11) {
        float f = 0.9375f;
        graphics.m_85841_(0.9375f, 0.9375f, 0.9375f);
    }

    private void setModelProperties() {
        PlayerEntityModel playermodel = this.playerModel;
        if (this.properties.isSpectator()) {
            playermodel.m_8009_(false);
            playermodel.f_102808_.f_104207_ = true;
            playermodel.f_102809_.f_104207_ = true;
        } else {
            playermodel.m_8009_(true);
            playermodel.f_102809_.f_104207_ = this.properties.isModelPartShown(PlayerModelPart.HAT);
            playermodel.f_103378_.f_104207_ = this.properties.isModelPartShown(PlayerModelPart.JACKET);
            playermodel.f_103376_.f_104207_ = this.properties.isModelPartShown(PlayerModelPart.LEFT_PANTS_LEG);
            playermodel.f_103377_.f_104207_ = this.properties.isModelPartShown(PlayerModelPart.RIGHT_PANTS_LEG);
            playermodel.f_103374_.f_104207_ = this.properties.isModelPartShown(PlayerModelPart.LEFT_SLEEVE);
            playermodel.f_103375_.f_104207_ = this.properties.isModelPartShown(PlayerModelPart.RIGHT_SLEEVE);
            playermodel.f_102817_ = this.properties.isCrouching();
            HumanoidModel.ArmPose humanoidmodel$armpose = PlayerEntityItemRenderer.getArmPose(this.properties, InteractionHand.MAIN_HAND);
            HumanoidModel.ArmPose humanoidmodel$armpose1 = PlayerEntityItemRenderer.getArmPose(this.properties, InteractionHand.OFF_HAND);
            if (humanoidmodel$armpose.m_102897_()) {
                HumanoidModel.ArmPose armPose = humanoidmodel$armpose1 = this.properties.getOffhandItem().m_41619_() ? HumanoidModel.ArmPose.EMPTY : HumanoidModel.ArmPose.ITEM;
            }
            if (this.properties.getMainArm() == HumanoidArm.RIGHT) {
                playermodel.f_102816_ = humanoidmodel$armpose;
                playermodel.f_102815_ = humanoidmodel$armpose1;
            } else {
                playermodel.f_102816_ = humanoidmodel$armpose1;
                playermodel.f_102815_ = humanoidmodel$armpose;
            }
        }
    }

    private static HumanoidModel.ArmPose getArmPose(PlayerEntityProperties props, InteractionHand interactionHand) {
        ItemStack itemstack = props.getItemInHand(interactionHand);
        if (itemstack.m_41619_()) {
            return HumanoidModel.ArmPose.EMPTY;
        }
        if (props.getUsedItemHand() == interactionHand && props.getUseItemRemainingTicks() > 0L) {
            UseAnim useanim = itemstack.m_41780_();
            if (useanim == UseAnim.BLOCK) {
                return HumanoidModel.ArmPose.BLOCK;
            }
            if (useanim == UseAnim.BOW) {
                return HumanoidModel.ArmPose.BOW_AND_ARROW;
            }
            if (useanim == UseAnim.SPEAR) {
                return HumanoidModel.ArmPose.THROW_SPEAR;
            }
            if (useanim == UseAnim.CROSSBOW && interactionHand == props.getUsedItemHand()) {
                return HumanoidModel.ArmPose.CROSSBOW_CHARGE;
            }
            if (useanim == UseAnim.SPYGLASS) {
                return HumanoidModel.ArmPose.SPYGLASS;
            }
            if (useanim == UseAnim.TOOT_HORN) {
                return HumanoidModel.ArmPose.TOOT_HORN;
            }
        } else if (itemstack.m_41720_() instanceof CrossbowItem && CrossbowItem.m_40932_((ItemStack)itemstack)) {
            return HumanoidModel.ArmPose.CROSSBOW_HOLD;
        }
        return HumanoidModel.ArmPose.ITEM;
    }

    public Vec3 m_7860_(@Nullable AbstractClientPlayer entity, float f11) {
        return this.properties.isCrouching() ? new Vec3(0.0, -0.125, 0.0) : Vec3.f_82478_;
    }

    @Nullable
    protected RenderType getRenderType(@Nullable AbstractClientPlayer entity, boolean visible, boolean isVisibleToPlayer, boolean glowing) {
        ResourceLocation resourcelocation = this.m_5478_(entity);
        if (isVisibleToPlayer) {
            return RenderType.m_110467_((ResourceLocation)resourcelocation);
        }
        if (visible) {
            return this.playerModel.m_103119_(resourcelocation);
        }
        return glowing ? RenderType.m_110491_((ResourceLocation)resourcelocation) : null;
    }

    public ResourceLocation m_5478_(@Nullable AbstractClientPlayer entity) {
        return this.properties.getSkinTextureLocation();
    }

    protected void m_7649_(@Nullable AbstractClientPlayer entity, Component content, PoseStack graphics, MultiBufferSource bufferSource, int p_114502_) {
        boolean flag = !this.properties.isCrouching();
        float f = this.properties.getDimensions().f_20378_ + 0.5f;
        boolean i = false;
        graphics.m_85836_();
        graphics.m_252880_(0.0f, f, 0.0f);
        graphics.m_85841_(-0.025f, -0.025f, 0.025f);
        Matrix4f graphics4f = graphics.m_85850_().m_252922_();
        float f1 = Minecraft.m_91087_().f_91066_.m_92141_(0.25f);
        int j = (int)(f1 * 255.0f) << 24;
        Font font = this.m_114481_();
        float f2 = -font.m_92852_((FormattedText)content) / 2;
        font.m_272077_(content, f2, (float)i, 0x20FFFFFF, false, graphics4f, bufferSource, flag ? Font.DisplayMode.SEE_THROUGH : Font.DisplayMode.NORMAL, j, p_114502_);
        if (flag) {
            font.m_272077_(content, f2, (float)i, -1, false, graphics4f, bufferSource, Font.DisplayMode.NORMAL, 0, p_114502_);
        }
        graphics.m_85849_();
    }

    protected void setupRotations(PoseStack graphics, float f11, float f12, float f13) {
        if (!this.properties.hasPose(Pose.SLEEPING)) {
            graphics.m_252781_(Axis.f_252436_.m_252977_(180.0f - f12));
        }
    }
}

