/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.helper;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.menu.fancy.helper.SetupSharingEngine;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.MenuBar;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.popup.FMPopup;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.gui.content.scrollarea.ScrollArea;
import de.keksuccino.konkrete.gui.content.scrollarea.ScrollAreaEntry;
import de.keksuccino.konkrete.input.KeyboardData;
import de.keksuccino.konkrete.input.KeyboardHandler;
import de.keksuccino.konkrete.input.MouseInput;
import de.keksuccino.konkrete.localization.Locals;
import java.awt.Color;
import java.io.File;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;

public class ChooseSavedSetupPopup
extends FMPopup {
    public Color overlayColor = new Color(26, 26, 26);
    protected ScrollArea scroll;
    protected Consumer<File> callback;
    protected AdvancedButton chooseButton;
    protected AdvancedButton closeButton;
    protected SetupEntry focused;
    protected int lastWidth = 0;
    protected int lastHeight = 0;

    public ChooseSavedSetupPopup(Consumer<File> callback) {
        super(240);
        this.callback = callback;
        KeyboardHandler.addKeyPressedListener(this::onEscapePressed);
        this.updateScrollList();
        this.chooseButton = new AdvancedButton(0, 0, 100, 20, Locals.localize((String)"popup.choosefile.choose", (String[])new String[0]), true, press -> {
            if (this.focused != null) {
                this.close();
            }
        });
        this.addButton(this.chooseButton);
        this.colorizePopupButton(this.chooseButton);
        this.closeButton = new AdvancedButton(0, 0, 100, 20, Locals.localize((String)"popup.yesno.cancel", (String[])new String[0]), true, press -> {
            if (this.callback != null) {
                this.callback.accept(null);
            }
            this.setDisplayed(false);
        });
        this.addButton(this.closeButton);
        this.colorizePopupButton(this.closeButton);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, Screen renderIn) {
        SetupSharingEngine.SetupProperties sp;
        File props;
        SetupEntry hoveredEntry;
        super.render(graphics, mouseX, mouseY, renderIn);
        if (this.lastWidth != renderIn.f_96543_ || this.lastHeight != renderIn.f_96544_) {
            this.updateScrollList();
            this.focused = null;
        }
        this.lastWidth = renderIn.f_96543_;
        this.lastHeight = renderIn.f_96544_;
        this.scroll.height = renderIn.f_96544_ - 100;
        this.scroll.y = 40;
        this.scroll.x = renderIn.f_96543_ / 2 - this.scroll.width / 2;
        this.scroll.render(graphics);
        graphics.m_280509_(0, 0, renderIn.f_96543_, 40, this.overlayColor.getRGB());
        graphics.m_280509_(0, renderIn.f_96544_ - 60, renderIn.f_96543_, renderIn.f_96544_, this.overlayColor.getRGB());
        graphics.m_280137_(Minecraft.m_91087_().f_91062_, "\u00a7l" + Locals.localize((String)"fancymenu.helper.setupsharing.import.choosefromsaved", (String[])new String[0]), renderIn.f_96543_ / 2, 17, Color.WHITE.getRGB());
        this.chooseButton.f_93620_ = renderIn.f_96543_ / 2 - this.chooseButton.m_5711_() - 5;
        this.chooseButton.f_93621_ = renderIn.f_96544_ - 40;
        this.closeButton.f_93620_ = renderIn.f_96543_ / 2 + 5;
        this.closeButton.f_93621_ = renderIn.f_96544_ - 40;
        this.renderButtons(graphics, mouseX, mouseY);
        if (this.focused != null && !this.focused.focused) {
            this.focused = null;
        }
        if ((hoveredEntry = this.getHoveredEntry()) != null && (props = new File(hoveredEntry.setupFolder.getPath() + "/setup.properties")).isFile() && (sp = SetupSharingEngine.deserializePropertiesFile(props.getPath())) != null) {
            String modified = "???";
            try {
                LocalDateTime dt = LocalDateTime.ofInstant(Instant.ofEpochMilli(hoveredEntry.setupFolder.lastModified()), ZoneId.systemDefault());
                DateTimeFormatter dtf = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM);
                dtf.withZone(ZoneId.systemDefault());
                dtf.withLocale(Locale.getDefault());
                modified = dt.format(dtf);
            }
            catch (Exception e3) {
                e3.printStackTrace();
            }
            String[] desc = new String[]{Locals.localize((String)"fancymenu.helper.setupsharing.import.choosefromsaved.tooltip", (String[])new String[0]), " ", Locals.localize((String)"fancymenu.helper.setupsharing.import.choosefromsaved.tooltip.datemodified", (String[])new String[]{modified}), Locals.localize((String)"fancymenu.helper.setupsharing.import.choosefromsaved.tooltip.mcversion", (String[])new String[]{sp.mcVersion}), Locals.localize((String)"fancymenu.helper.setupsharing.import.choosefromsaved.tooltip.fmversion", (String[])new String[]{sp.fmVersion}), Locals.localize((String)"fancymenu.helper.setupsharing.import.choosefromsaved.tooltip.modloader", (String[])new String[]{sp.modLoader})};
            ChooseSavedSetupPopup.renderDescription(graphics, MouseInput.getMouseX(), MouseInput.getMouseY(), desc);
        }
    }

    protected SetupEntry getHoveredEntry() {
        for (ScrollAreaEntry e : this.scroll.getEntries()) {
            if (!e.isHoveredOrFocused()) continue;
            return (SetupEntry)e;
        }
        return null;
    }

    public void updateScrollList() {
        this.scroll = new ScrollArea(0, 0, 200, 0);
        this.scroll.backgroundColor = new Color(255, 255, 255, 20);
        File f = SetupSharingEngine.FM_SETUPS_DIR;
        if (f.isDirectory()) {
            for (File setupDir : f.listFiles()) {
                if (!SetupSharingEngine.isValidSetup(setupDir.getPath())) continue;
                this.scroll.addEntry((ScrollAreaEntry)new SetupEntry(this, setupDir));
            }
        }
    }

    public void close() {
        this.setDisplayed(false);
        if (this.callback != null) {
            if (this.focused != null) {
                this.callback.accept(this.focused.setupFolder);
            } else {
                this.callback.accept(null);
            }
        }
    }

    public void onEscapePressed(KeyboardData d) {
        if (d.keycode == 256 && this.isDisplayed()) {
            if (this.callback != null) {
                this.callback.accept(null);
            }
            this.setDisplayed(false);
        }
    }

    private static void renderDescription(GuiGraphics graphics, int mouseX, int mouseY, String ... desc) {
        if (desc != null) {
            int width = 10;
            int height = 10;
            for (String s : desc) {
                int i = Minecraft.m_91087_().f_91062_.m_92895_(s) + 10;
                if (i > width) {
                    width = i;
                }
                height += 10;
            }
            mouseY += 5;
            if (Minecraft.m_91087_().f_91080_.f_96543_ < (mouseX += 5) + width) {
                mouseX -= width + 10;
            }
            if (Minecraft.m_91087_().f_91080_.f_96544_ < mouseY + height) {
                mouseY -= height + 10;
            }
            RenderSystem.enableBlend();
            ChooseSavedSetupPopup.renderDescriptionBackground(graphics, mouseX, mouseY, width, height);
            int i2 = 5;
            for (String s : desc) {
                graphics.m_280488_(Minecraft.m_91087_().f_91062_, s, mouseX + 5, mouseY + i2, -1);
                i2 += 10;
            }
        }
    }

    private static void renderDescriptionBackground(GuiGraphics graphics, int x, int y, int width, int height) {
        Color borderColor = Color.WHITE;
        Color backColor = new Color(26, 26, 26, 250);
        graphics.m_280509_(x, y, x + width, y + height, backColor.getRGB());
        graphics.m_280509_(x, y, x + 1, y + height, borderColor.getRGB());
        graphics.m_280509_(x, y, x + width, y + 1, borderColor.getRGB());
        graphics.m_280509_(x + width - 1, y, x + width, y + height, borderColor.getRGB());
        graphics.m_280509_(x, y + height - 1, x + width, y + height, borderColor.getRGB());
    }

    public static class SetupEntry
    extends ScrollAreaEntry {
        public ChooseSavedSetupPopup chooser;
        protected File setupFolder;
        protected int clickTick = 0;
        protected boolean clickPre = false;
        protected boolean click = false;
        protected boolean focused = false;

        public SetupEntry(ChooseSavedSetupPopup chooser, File setupFolder) {
            super(chooser.scroll);
            this.chooser = chooser;
            this.setupFolder = setupFolder;
        }

        public void render(GuiGraphics graphics) {
            if (this.isHoveredOrFocused() && this.isVisible() && MouseInput.isLeftMouseDown()) {
                this.focused = true;
                this.chooser.focused = this;
                if (!this.click) {
                    this.clickPre = true;
                    this.clickTick = 0;
                }
            }
            if (!this.isHoveredOrFocused() && MouseInput.isLeftMouseDown()) {
                this.focused = false;
            }
            super.render(graphics);
        }

        public void renderEntry(GuiGraphics graphics) {
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            graphics.m_280163_(MenuBar.FM_LOGO_TEXTURE, this.x, this.y, 0.0f, 0.0f, 20, 20, 20, 20);
            Font font = Minecraft.m_91087_().f_91062_;
            Object name = this.setupFolder.getName();
            int maxNameWidth = this.getWidth() - 30 - 8;
            if (font.m_92895_((String)name) > maxNameWidth) {
                name = font.m_92834_((String)name, maxNameWidth) + "..";
            }
            graphics.m_280488_(font, (String)name, this.x + 30, this.y + 7, -1);
            if (!MouseInput.isLeftMouseDown() && this.clickPre) {
                this.click = true;
                this.clickPre = false;
                this.clickTick = 0;
            }
            if (this.click) {
                if (this.clickTick < 15) {
                    ++this.clickTick;
                } else {
                    this.click = false;
                    this.clickTick = 0;
                }
                if (MouseInput.isLeftMouseDown() && this.isHoveredOrFocused()) {
                    this.onClick();
                    this.click = false;
                    this.clickTick = 0;
                }
            }
            if (this.focused) {
                this.renderBorder(graphics);
            }
        }

        private void renderBorder(GuiGraphics graphics) {
            graphics.m_280509_(this.x, this.y, this.x + 1, this.y + this.getHeight(), Color.WHITE.getRGB());
            graphics.m_280509_(this.x + this.getWidth() - 1, this.y, this.x + this.getWidth(), this.y + this.getHeight(), Color.WHITE.getRGB());
            graphics.m_280509_(this.x, this.y, this.x + this.getWidth(), this.y + 1, Color.WHITE.getRGB());
            graphics.m_280509_(this.x, this.y + this.getHeight() - 1, this.x + this.getWidth(), this.y + this.getHeight(), Color.WHITE.getRGB());
        }

        public void onClick() {
            this.chooser.close();
        }

        public int getHeight() {
            return 20;
        }
    }
}

