/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element.elements.button.custombutton;

import de.keksuccino.fancymenu.customization.action.blocks.GenericExecutableBlock;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.element.ExecutableElement;
import de.keksuccino.fancymenu.customization.element.elements.button.custombutton.ButtonEditorElement;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementContainer;
import de.keksuccino.fancymenu.customization.placeholder.PlaceholderParser;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinAbstractWidget;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.Tooltip;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.TooltipHandler;
import de.keksuccino.fancymenu.util.rendering.ui.widget.CustomizableSlider;
import de.keksuccino.fancymenu.util.rendering.ui.widget.CustomizableWidget;
import de.keksuccino.fancymenu.util.rendering.ui.widget.NavigatableWidget;
import de.keksuccino.fancymenu.util.resource.RenderableResource;
import de.keksuccino.fancymenu.util.resource.ResourceSupplier;
import de.keksuccino.fancymenu.util.resource.resources.audio.IAudio;
import de.keksuccino.fancymenu.util.resource.resources.texture.ITexture;
import de.keksuccino.fancymenu.util.threading.MainThreadTaskExecutor;
import de.keksuccino.konkrete.input.StringUtils;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_7919;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ButtonElement
extends AbstractElement
implements ExecutableElement {
    private static final Logger LOGGER = LogManager.getLogger();
    @Nullable
    private class_339 widget;
    public ResourceSupplier<IAudio> clickSound;
    public ResourceSupplier<IAudio> hoverSound;
    @Nullable
    public String label;
    @Nullable
    public String hoverLabel;
    public String tooltip;
    public ResourceSupplier<ITexture> backgroundTextureNormal;
    public ResourceSupplier<ITexture> backgroundTextureHover;
    public ResourceSupplier<ITexture> backgroundTextureInactive;
    public String backgroundAnimationNormal;
    public String backgroundAnimationHover;
    public String backgroundAnimationInactive;
    public boolean loopBackgroundAnimations = true;
    public boolean restartBackgroundAnimationsOnHover = true;
    public boolean nineSliceCustomBackground = false;
    public int nineSliceBorderX = 5;
    public int nineSliceBorderY = 5;
    public boolean navigatable = true;
    @NotNull
    public GenericExecutableBlock actionExecutor = new GenericExecutableBlock();
    @NotNull
    public LoadingRequirementContainer activeStateSupplier = new LoadingRequirementContainer();

    public ButtonElement(ElementBuilder<ButtonElement, ButtonEditorElement> builder) {
        super(builder);
    }

    @Override
    public void tick() {
        if (this.getWidget() == null) {
            return;
        }
        this.updateWidget();
    }

    @Override
    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        if (this.getWidget() == null) {
            return;
        }
        this.updateWidget();
        if (!this.shouldRender()) {
            return;
        }
        if (ButtonElement.isEditor()) {
            class_7919 cachedVanillaTooltip = this.getWidget().method_51254();
            boolean cachedVisible = this.getWidget().field_22764;
            boolean cachedActive = this.getWidget().field_22763;
            this.getWidget().field_22764 = true;
            this.getWidget().field_22763 = true;
            this.getWidget().method_47400(null);
            MainThreadTaskExecutor.executeInMainThread(() -> {
                this.getWidget().field_22764 = cachedVisible;
                this.getWidget().field_22763 = cachedActive;
                this.getWidget().method_47400(cachedVanillaTooltip);
            }, MainThreadTaskExecutor.ExecuteTiming.POST_CLIENT_TICK);
        }
        this.renderElementWidget(graphics, mouseX, mouseY, partial);
        RenderingUtils.resetShaderColor(graphics);
    }

    @Override
    public void tickVisibleInvisible() {
        super.tickVisibleInvisible();
        if (this.getWidget() != null) {
            this.updateWidget();
        }
    }

    protected void renderElementWidget(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        if (this.getWidget() != null) {
            if (this.getWidget().method_25364() <= 0) {
                return;
            }
            if (this.getWidget().method_25368() <= 0) {
                return;
            }
            this.getWidget().method_25394(graphics, mouseX, mouseY, partial);
        }
    }

    @Override
    @Nullable
    public List<class_364> getWidgetsToRegister() {
        if (this.getWidget() == null) {
            return null;
        }
        return List.of(this.getWidget());
    }

    public void updateWidget() {
        this.updateWidgetActiveState();
        this.updateWidgetVisibility();
        this.updateWidgetAlpha();
        this.updateWidgetTooltip();
        this.updateWidgetLabels();
        this.updateWidgetHoverSound();
        this.updateWidgetClickSound();
        this.updateWidgetTexture();
        this.updateWidgetSize();
        this.updateWidgetPosition();
        this.updateWidgetNavigatable();
    }

    public void updateWidgetActiveState() {
        if (this.getWidget() == null) {
            return;
        }
        this.getWidget().field_22763 = this.activeStateSupplier.requirementsMet();
    }

    public void updateWidgetNavigatable() {
        class_339 class_3392 = this.getWidget();
        if (class_3392 instanceof NavigatableWidget) {
            NavigatableWidget w = (NavigatableWidget)class_3392;
            w.setNavigatable(this.navigatable);
        }
    }

    public void updateWidgetVisibility() {
        class_339 class_3392 = this.getWidget();
        if (class_3392 instanceof CustomizableWidget) {
            CustomizableWidget w = (CustomizableWidget)class_3392;
            w.setHiddenFancyMenu(!this.shouldRender());
        }
    }

    public void updateWidgetAlpha() {
        if (this.getWidget() == null) {
            return;
        }
        this.getWidget().method_25350(this.opacity);
    }

    public void updateWidgetPosition() {
        if (this.getWidget() == null) {
            return;
        }
        this.getWidget().method_46421(this.getAbsoluteX());
        this.getWidget().method_46419(this.getAbsoluteY());
    }

    public void updateWidgetSize() {
        if (this.getWidget() == null) {
            return;
        }
        this.getWidget().method_25358(this.getAbsoluteWidth());
        ((IMixinAbstractWidget)this.getWidget()).setHeightFancyMenu(this.getAbsoluteHeight());
    }

    public void updateWidgetTooltip() {
        if (this.tooltip != null && this.getWidget() != null && this.getWidget().method_49606() && this.getWidget().field_22764 && this.shouldRender() && !ButtonElement.isEditor()) {
            String tooltip = this.tooltip.replace("%n%", "\n");
            TooltipHandler.INSTANCE.addWidgetTooltip(this.getWidget(), Tooltip.of(StringUtils.splitLines((String)PlaceholderParser.replacePlaceholders(tooltip), (String)"\n")), false, true);
        }
    }

    public void updateWidgetLabels() {
        if (this.getWidget() == null) {
            return;
        }
        if (this.label != null) {
            this.getWidget().method_25355(ButtonElement.buildComponent(this.label));
        } else {
            this.getWidget().method_25355((class_2561)class_2561.method_43473());
        }
        if (this.hoverLabel != null && this.getWidget().method_25367() && this.getWidget().field_22763) {
            this.getWidget().method_25355(ButtonElement.buildComponent(this.hoverLabel));
        }
    }

    public void updateWidgetHoverSound() {
        class_339 class_3392 = this.getWidget();
        if (class_3392 instanceof CustomizableWidget) {
            CustomizableWidget w = (CustomizableWidget)class_3392;
            w.setHoverSoundFancyMenu(this.hoverSound != null ? this.hoverSound.get() : null);
        }
    }

    public void updateWidgetClickSound() {
        class_339 class_3392 = this.getWidget();
        if (class_3392 instanceof CustomizableWidget) {
            CustomizableWidget w = (CustomizableWidget)class_3392;
            w.setCustomClickSoundFancyMenu(this.clickSound != null ? this.clickSound.get() : null);
        }
    }

    public void updateWidgetTexture() {
        class_339 class_3392;
        RenderableResource backNormal = null;
        RenderableResource backHover = null;
        RenderableResource backInactive = null;
        if (this.backgroundTextureNormal != null) {
            backNormal = this.backgroundTextureNormal.get();
        }
        if (this.backgroundTextureHover != null) {
            backHover = this.backgroundTextureHover.get();
        }
        if (this.backgroundTextureInactive != null) {
            backInactive = this.backgroundTextureInactive.get();
        }
        if ((class_3392 = this.getWidget()) instanceof CustomizableWidget) {
            CustomizableWidget w = (CustomizableWidget)class_3392;
            class_339 class_3393 = this.getWidget();
            if (class_3393 instanceof CustomizableSlider) {
                CustomizableSlider s = (CustomizableSlider)class_3393;
                s.setNineSliceCustomSliderBackground_FancyMenu(this.nineSliceCustomBackground);
                s.setNineSliceSliderBackgroundBorderX_FancyMenu(this.nineSliceBorderX);
                s.setNineSliceSliderBackgroundBorderY_FancyMenu(this.nineSliceBorderY);
            } else {
                w.setNineSliceCustomBackground_FancyMenu(this.nineSliceCustomBackground);
                w.setNineSliceBorderX_FancyMenu(this.nineSliceBorderX);
                w.setNineSliceBorderY_FancyMenu(this.nineSliceBorderY);
            }
            w.setCustomBackgroundNormalFancyMenu(backNormal);
            w.setCustomBackgroundHoverFancyMenu(backHover);
            w.setCustomBackgroundInactiveFancyMenu(backInactive);
            w.setCustomBackgroundResetBehaviorFancyMenu(this.restartBackgroundAnimationsOnHover ? CustomizableWidget.CustomBackgroundResetBehavior.RESET_ON_HOVER : CustomizableWidget.CustomBackgroundResetBehavior.RESET_NEVER);
        }
    }

    @Nullable
    public class_339 getWidget() {
        return this.widget;
    }

    public void setWidget(@Nullable class_339 widget) {
        this.widget = widget;
    }

    @Override
    @NotNull
    public GenericExecutableBlock getExecutableBlock() {
        return this.actionExecutor;
    }
}

