/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.background.backgrounds.image;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.background.MenuBackground;
import de.keksuccino.fancymenu.customization.background.MenuBackgroundBuilder;
import de.keksuccino.fancymenu.util.rendering.AspectRatio;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.resource.ResourceSupplier;
import de.keksuccino.fancymenu.util.resource.resources.texture.ITexture;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import org.jetbrains.annotations.NotNull;

public class ImageMenuBackground
extends MenuBackground {
    private static final DrawableColor BACKGROUND_COLOR = DrawableColor.BLACK;
    public ResourceSupplier<ITexture> textureSupplier;
    public ResourceSupplier<ITexture> fallbackTextureSupplier;
    public boolean slideLeftRight = false;
    public boolean repeat = false;
    protected double slidePos = 0.0;
    protected boolean slideMoveBack = false;
    protected boolean slideStop = false;
    protected int slideTick = 0;

    public ImageMenuBackground(MenuBackgroundBuilder<ImageMenuBackground> builder) {
        super(builder);
    }

    @Override
    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        ITexture fallback;
        ITexture background;
        RenderSystem.enableBlend();
        graphics.method_25294(0, 0, ImageMenuBackground.getScreenWidth(), ImageMenuBackground.getScreenHeight(), BACKGROUND_COLOR.getColorIntWithAlpha(this.opacity));
        RenderingUtils.resetShaderColor(graphics);
        class_2960 resourceLocation = null;
        ITexture tex = null;
        AspectRatio ratio = new AspectRatio(10, 10);
        if (this.textureSupplier != null && (background = this.textureSupplier.get()) != null) {
            tex = background;
            ratio = background.getAspectRatio();
            resourceLocation = background.getResourceLocation();
        }
        if (resourceLocation == null && this.fallbackTextureSupplier != null && (fallback = this.fallbackTextureSupplier.get()) != null) {
            tex = fallback;
            ratio = fallback.getAspectRatio();
            resourceLocation = fallback.getResourceLocation();
        }
        if (resourceLocation != null) {
            RenderSystem.enableBlend();
            graphics.method_51422(1.0f, 1.0f, 1.0f, this.opacity);
            if (this.repeat) {
                RenderingUtils.blitRepeat(graphics, resourceLocation, 0, 0, ImageMenuBackground.getScreenWidth(), ImageMenuBackground.getScreenHeight(), tex.getWidth(), tex.getHeight());
            } else if (this.slideLeftRight) {
                int w = ratio.getAspectRatioWidth(ImageMenuBackground.getScreenHeight());
                if (this.slidePos + (double)(w - ImageMenuBackground.getScreenWidth()) <= 0.0) {
                    this.slideMoveBack = true;
                }
                if (this.slidePos >= 0.0) {
                    this.slideMoveBack = false;
                }
                if (this.slidePos + (double)(w - ImageMenuBackground.getScreenWidth()) < 0.0) {
                    this.slidePos = -(w - ImageMenuBackground.getScreenWidth());
                }
                if (this.slidePos > 0.0) {
                    this.slidePos = 0.0;
                }
                if (!this.slideStop) {
                    if (this.slideTick >= 1) {
                        this.slideTick = 0;
                        this.slidePos = this.slideMoveBack ? (this.slidePos += 0.5) : (this.slidePos -= 0.5);
                        if (this.slidePos + (double)(w - ImageMenuBackground.getScreenWidth()) == 0.0) {
                            this.slideStop = true;
                        }
                        if (this.slidePos == 0.0) {
                            this.slideStop = true;
                        }
                    } else {
                        ++this.slideTick;
                    }
                } else if (this.slideTick >= 300) {
                    this.slideStop = false;
                    this.slideTick = 0;
                } else {
                    ++this.slideTick;
                }
                if (w <= ImageMenuBackground.getScreenWidth()) {
                    if (this.keepBackgroundAspectRatio) {
                        this.renderKeepAspectRatio(graphics, ratio, resourceLocation);
                    } else {
                        graphics.method_25290(resourceLocation, 0, 0, 0.0f, 0.0f, ImageMenuBackground.getScreenWidth(), ImageMenuBackground.getScreenHeight(), ImageMenuBackground.getScreenWidth(), ImageMenuBackground.getScreenHeight());
                    }
                } else {
                    RenderingUtils.blitF(graphics, resourceLocation, (float)this.slidePos, 0.0f, 0.0f, 0.0f, w, ImageMenuBackground.getScreenHeight(), w, ImageMenuBackground.getScreenHeight());
                }
            } else if (this.keepBackgroundAspectRatio) {
                this.renderKeepAspectRatio(graphics, ratio, resourceLocation);
            } else {
                graphics.method_25290(resourceLocation, 0, 0, 0.0f, 0.0f, ImageMenuBackground.getScreenWidth(), ImageMenuBackground.getScreenHeight(), ImageMenuBackground.getScreenWidth(), ImageMenuBackground.getScreenHeight());
            }
        }
        RenderingUtils.resetShaderColor(graphics);
    }

    protected void renderKeepAspectRatio(@NotNull class_332 graphics, @NotNull AspectRatio ratio, @NotNull class_2960 resourceLocation) {
        int[] size = ratio.getAspectRatioSizeByMinimumSize(ImageMenuBackground.getScreenWidth(), ImageMenuBackground.getScreenHeight());
        int x = 0;
        if (size[0] > ImageMenuBackground.getScreenWidth()) {
            x = -((size[0] - ImageMenuBackground.getScreenWidth()) / 2);
        }
        int y = 0;
        if (size[1] > ImageMenuBackground.getScreenHeight()) {
            y = -((size[1] - ImageMenuBackground.getScreenHeight()) / 2);
        }
        graphics.method_25290(resourceLocation, x, y, 0.0f, 0.0f, size[0], size[1], size[0], size[1]);
    }
}

