/*
 * Decompiled with CFR 0.152.
 */
package wraith.fwaystones.util;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_155;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import wraith.fwaystones.access.PlayerEntityMixinAccess;
import wraith.fwaystones.access.WaystoneValue;
import wraith.fwaystones.block.WaystoneBlock;
import wraith.fwaystones.block.WaystoneBlockEntity;
import wraith.fwaystones.integration.event.WaystoneEvents;
import wraith.fwaystones.util.Utils;
import wraith.fwaystones.util.WaystonePacketHandler;

public class WaystoneStorage {
    public static final String ID = "fw_waystones";
    public final ConcurrentHashMap<String, WaystoneValue> WAYSTONES = new ConcurrentHashMap();
    private final class_18 state;
    private final MinecraftServer server;

    public WaystoneStorage(MinecraftServer server) {
        if (server == null) {
            this.server = null;
            this.state = null;
            return;
        }
        this.server = server;
        class_18 pState = new class_18(){

            public class_2487 method_75(class_2487 tag) {
                return WaystoneStorage.this.toTag(tag);
            }
        };
        this.state = this.server.method_3847(class_3218.field_25179).method_17983().method_17924(nbtCompound -> {
            this.fromTag((class_2487)nbtCompound);
            return pState;
        }, () -> pState, ID);
        this.loadWaystones();
    }

    private class_18 createState() {
        return new class_18(){

            public class_2487 method_75(class_2487 tag) {
                return WaystoneStorage.this.toTag(tag);
            }
        };
    }

    private class_18 stateFromNbt(class_2487 nbt) {
        class_18 state = this.createState();
        this.fromTag(nbt);
        return state;
    }

    public void fromTag(class_2487 tag) {
        if (tag == null || !tag.method_10545("fwaystones")) {
            return;
        }
        this.WAYSTONES.clear();
        HashSet<String> globals = new HashSet<String>();
        for (class_2520 element : tag.method_10554("global_waystones", 8)) {
            globals.add(element.method_10714());
        }
        class_2499 waystones = tag.method_10554("fwaystones", 10);
        for (int i = 0; i < waystones.size(); ++i) {
            class_2487 waystoneTag = waystones.method_10602(i);
            if (!waystoneTag.method_10545("hash") || !waystoneTag.method_10545("name") || !waystoneTag.method_10545("dimension") || !waystoneTag.method_10545("position")) continue;
            String name = waystoneTag.method_10558("name");
            String hash = waystoneTag.method_10558("hash");
            String dimension = waystoneTag.method_10558("dimension");
            int[] coordinates = waystoneTag.method_10561("position");
            int color = waystoneTag.method_10573("color", 3) ? waystoneTag.method_10550("color") : Utils.getRandomColor();
            class_2338 pos = new class_2338(coordinates[0], coordinates[1], coordinates[2]);
            this.WAYSTONES.put(hash, new Lazy(name, pos, hash, dimension, color, globals.contains(hash)));
        }
    }

    public class_2487 toTag(class_2487 tag) {
        if (tag == null) {
            tag = new class_2487();
        }
        class_2499 waystones = new class_2499();
        for (Map.Entry<String, WaystoneValue> waystone : this.WAYSTONES.entrySet()) {
            String hash = waystone.getKey();
            WaystoneValue entity = waystone.getValue();
            if (!entity.getHash().equals(hash)) continue;
            class_2487 waystoneTag = new class_2487();
            waystoneTag.method_10582("hash", hash);
            waystoneTag.method_10582("name", entity.getWaystoneName());
            waystoneTag.method_10569("color", entity.getColor());
            class_2338 pos = entity.way_getPos();
            waystoneTag.method_10572("position", Arrays.asList(pos.method_10263(), pos.method_10264(), pos.method_10260()));
            waystoneTag.method_10582("dimension", entity.getWorldName());
            waystones.add((Object)waystoneTag);
        }
        tag.method_10566("fwaystones", (class_2520)waystones);
        class_2499 globals = new class_2499();
        List<String> globalWaystones = this.getGlobals();
        for (String globalWaystone : globalWaystones) {
            globals.add((Object)class_2519.method_23256((String)globalWaystone));
        }
        tag.method_10566("global_waystones", (class_2520)globals);
        return tag;
    }

    public void tryAddWaystone(WaystoneBlockEntity waystone) {
        if (waystone == null) {
            return;
        }
        if (this.WAYSTONES.containsValue(waystone)) {
            return;
        }
        boolean alreadyExists = this.WAYSTONES.containsKey(waystone.getHash());
        this.WAYSTONES.put(waystone.getHash(), waystone);
        this.saveWaystones(!alreadyExists);
    }

    public void addWaystones(HashSet<WaystoneBlockEntity> waystones) {
        boolean added = false;
        for (WaystoneBlockEntity waystone : waystones) {
            if (waystone == null) continue;
            added = true;
            this.tryAddWaystone(waystone);
        }
        if (added) {
            this.saveWaystones(true);
        }
    }

    public void saveWaystones(boolean sync) {
        if (this.server == null) {
            return;
        }
        class_3218 world = this.server.method_3847(class_3218.field_25179);
        this.state.method_80();
        if (sync) {
            this.sendToAllPlayers();
        }
        world.method_17983().method_125();
    }

    public void loadWaystones() {
        if (this.server == null) {
            return;
        }
        class_3218 world = this.server.method_3847(class_3218.field_25179);
        try {
            class_2487 compoundTag = world.method_17983().method_17923(ID, class_155.method_16673().method_48020());
            this.state.method_75(compoundTag.method_10562("data"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        world.method_17983().method_125();
    }

    public void sendToAllPlayers() {
        if (this.server == null) {
            return;
        }
        for (class_3222 player : this.server.method_3760().method_14571()) {
            this.sendToPlayer(player);
        }
    }

    public void sendToPlayer(class_3222 player) {
        class_2540 data = PacketByteBufs.create();
        data.method_10794(this.toTag(new class_2487()));
        ServerPlayNetworking.send((class_3222)player, (class_2960)WaystonePacketHandler.WAYSTONE_PACKET, (class_2540)data);
    }

    public void removeWaystone(String hash) {
        ((WaystoneEvents.RemoveWaystone)WaystoneEvents.REMOVE_WAYSTONE_EVENT.invoker()).onRemove(hash);
        this.WAYSTONES.remove(hash);
        this.saveWaystones(false);
        this.forgetForAllPlayers(hash);
    }

    public void removeWorldWaystones(String dimension) {
        if (this.server == null) {
            return;
        }
        this.WAYSTONES.forEach((hash, waystone) -> {
            if (waystone.getWorldName().equals(dimension)) {
                WaystoneBlockEntity entity = waystone.getEntity();
                if (entity != null) {
                    entity.setOwner(null);
                }
                this.removeWaystone((String)hash);
            }
        });
    }

    public void forgetForAllPlayers(String hash) {
        if (this.server == null) {
            return;
        }
        for (class_3222 player : this.server.method_3760().method_14571()) {
            ((PlayerEntityMixinAccess)player).fabricWaystones$forgetWaystone(hash);
        }
    }

    public void removeWaystone(WaystoneBlockEntity waystone) {
        this.removeWaystone(waystone.getHash());
    }

    public boolean removeIfInvalid(String hash) {
        if (this.WAYSTONES.containsKey(hash) && this.getWaystoneEntity(hash) == null) {
            this.removeWaystone(hash);
            return true;
        }
        return false;
    }

    public void renameWaystone(String hash, String name) {
        if (this.WAYSTONES.containsKey(hash)) {
            WaystoneValue waystone = this.WAYSTONES.get(hash);
            waystone.getEntity().setName(name);
            ((WaystoneEvents.UpdateWaystone)WaystoneEvents.RENAME_WAYSTONE_EVENT.invoker()).onUpdate(hash);
            this.saveWaystones(true);
        }
    }

    public void recolorWaystone(String hash, int color) {
        if (this.WAYSTONES.containsKey(hash)) {
            this.WAYSTONES.get(hash).setColor(color);
            this.saveWaystones(true);
        }
    }

    @Nullable
    public WaystoneBlockEntity getWaystoneEntity(String hash) {
        WaystoneValue value = this.getWaystoneData(hash);
        return value != null ? value.getEntity() : null;
    }

    @Nullable
    public WaystoneValue getWaystoneData(String hash) {
        return this.WAYSTONES.getOrDefault(hash, null);
    }

    public boolean containsHash(String hash) {
        return this.WAYSTONES.containsKey(hash);
    }

    public List<String> getGlobals() {
        return this.WAYSTONES.entrySet().stream().filter(entry -> ((WaystoneValue)entry.getValue()).isGlobal()).map(Map.Entry::getKey).toList();
    }

    public boolean isGlobal(String hash) {
        return this.WAYSTONES.containsKey(hash) && this.WAYSTONES.get(hash).isGlobal();
    }

    public void toggleGlobal(String hash) {
        WaystoneBlockEntity waystone = this.getWaystoneEntity(hash);
        if (waystone == null) {
            return;
        }
        waystone.toggleGlobal();
        this.sendToAllPlayers();
    }

    public void setOwner(String hash, class_1657 owner) {
        if (this.WAYSTONES.containsKey(hash)) {
            this.WAYSTONES.get(hash).getEntity().setOwner(owner);
        }
    }

    public HashSet<String> getAllHashes() {
        return new HashSet<String>(this.WAYSTONES.keySet());
    }

    public int getCount() {
        return this.WAYSTONES.size();
    }

    @Nullable
    public String getName(String hash) {
        WaystoneValue value = this.getWaystoneData(hash);
        return value != null ? value.getWaystoneName() : null;
    }

    final class Lazy
    implements WaystoneValue {
        final String name;
        final class_2338 pos;
        final String hash;
        final String dimension;
        final boolean isGlobal;
        int color;
        WaystoneBlockEntity entity;
        class_1937 world;

        Lazy(String name, class_2338 pos, String hash, String dimension, int color, boolean global) {
            this.name = name;
            this.pos = pos;
            this.hash = hash;
            this.dimension = dimension;
            this.color = color;
            this.isGlobal = global;
        }

        @Override
        public WaystoneBlockEntity getEntity() {
            if (WaystoneStorage.this.server == null) {
                return null;
            }
            if (this.entity == null) {
                for (class_3218 world : WaystoneStorage.this.server.method_3738()) {
                    if (!Utils.getDimensionName((class_1937)world).equals(this.dimension)) continue;
                    WaystoneBlockEntity entity = WaystoneBlock.getEntity((class_1937)world, this.pos);
                    if (entity == null) break;
                    WaystoneStorage.this.tryAddWaystone(entity);
                    this.entity = entity;
                    this.world = world;
                    break;
                }
            }
            return this.entity;
        }

        @Override
        public String getWaystoneName() {
            return this.name;
        }

        @Override
        public class_2338 way_getPos() {
            return this.pos;
        }

        @Override
        public String getWorldName() {
            return this.dimension;
        }

        @Override
        public String getHash() {
            return this.hash;
        }

        @Override
        public int getColor() {
            return this.color;
        }

        @Override
        public void setColor(int color) {
            this.color = color;
        }

        @Override
        public boolean isGlobal() {
            return this.isGlobal;
        }
    }
}

