/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.network.packet.server;

import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.item.AlbumItem;
import io.github.mortuusars.exposure.network.PacketDirection;
import io.github.mortuusars.exposure.network.packet.IPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public record AlbumSignC2SP(String title) implements IPacket
{
    public static final ResourceLocation ID = Exposure.resource("album_sign");

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    public static AlbumSignC2SP fromBuffer(FriendlyByteBuf buffer) {
        return new AlbumSignC2SP(buffer.m_130277_());
    }

    @Override
    public FriendlyByteBuf toBuffer(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.title);
        return buffer;
    }

    @Override
    public boolean handle(PacketDirection direction, @Nullable Player player) {
        InteractionHand hand;
        AlbumItem albumItem;
        Preconditions.checkState((player != null ? 1 : 0) != 0, (Object)"Cannot handle packet: Player was null");
        Item item = player.m_21120_(InteractionHand.MAIN_HAND).m_41720_();
        if (item instanceof AlbumItem && (albumItem = (AlbumItem)item).isEditable()) {
            hand = InteractionHand.MAIN_HAND;
        } else {
            AlbumItem albumItem2;
            item = player.m_21120_(InteractionHand.OFF_HAND).m_41720_();
            if (item instanceof AlbumItem && (albumItem2 = (AlbumItem)item).isEditable()) {
                hand = InteractionHand.OFF_HAND;
            } else {
                throw new IllegalStateException("Player receiving this packet should have an album in one of the hands.");
            }
        }
        ItemStack albumStack = player.m_21120_(hand);
        AlbumItem albumItem3 = (AlbumItem)albumStack.m_41720_();
        ItemStack signedAlbum = albumItem3.sign(albumStack, this.title, player.m_7755_().getString());
        player.m_21008_(hand, signedAlbum);
        player.m_9236_().m_6269_(null, (Entity)player, SoundEvents.f_12565_, SoundSource.PLAYERS, 0.8f, 1.0f);
        return true;
    }
}

