/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.network.packet.client;

import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.network.PacketDirection;
import io.github.mortuusars.exposure.network.packet.IPacket;
import io.github.mortuusars.exposure.sound.OnePerPlayerSounds;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public record PlayOnePerPlayerSoundS2CP(UUID sourcePlayerId, SoundEvent soundEvent, SoundSource source, float volume, float pitch) implements IPacket
{
    public static final ResourceLocation ID = Exposure.resource("play_one_per_player_sound");

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public FriendlyByteBuf toBuffer(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.sourcePlayerId);
        buffer.m_130085_(this.soundEvent.m_11660_());
        buffer.m_130068_((Enum)this.source);
        buffer.writeFloat(this.volume);
        buffer.writeFloat(this.pitch);
        return buffer;
    }

    public static PlayOnePerPlayerSoundS2CP fromBuffer(FriendlyByteBuf buffer) {
        UUID uuid = buffer.m_130259_();
        ResourceLocation soundEventLocation = buffer.m_130281_();
        @Nullable SoundEvent soundEvent = (SoundEvent)BuiltInRegistries.f_256894_.m_7745_(soundEventLocation);
        if (soundEvent == null) {
            soundEvent = (SoundEvent)SoundEvents.f_12209_.m_203334_();
        }
        return new PlayOnePerPlayerSoundS2CP(uuid, soundEvent, (SoundSource)buffer.m_130066_(SoundSource.class), buffer.readFloat(), buffer.readFloat());
    }

    @Override
    public boolean handle(PacketDirection direction, @Nullable Player player) {
        if (Minecraft.m_91087_().f_91073_ != null) {
            @Nullable Player sourcePlayer = Minecraft.m_91087_().f_91073_.m_46003_(this.sourcePlayerId);
            if (sourcePlayer != null) {
                Minecraft.m_91087_().execute(() -> OnePerPlayerSounds.play(sourcePlayer, this.soundEvent, this.source, this.volume, this.pitch));
            } else {
                Exposure.LOGGER.debug("Cannot play OnePerPlayer sound. SourcePlayer was not found by it's UUID.");
            }
        }
        return true;
    }
}

