/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.gui.screen.camera;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.camera.infrastructure.FocalRange;
import io.github.mortuusars.exposure.data.Lenses;
import io.github.mortuusars.exposure.data.filter.Filters;
import io.github.mortuusars.exposure.gui.screen.ItemListScreen;
import io.github.mortuusars.exposure.item.CameraItem;
import io.github.mortuusars.exposure.menu.CameraAttachmentsMenu;
import io.github.mortuusars.exposure.sound.OnePerPlayerSounds;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class CameraAttachmentsScreen
extends AbstractContainerScreen<CameraAttachmentsMenu> {
    public static final ResourceLocation TEXTURE = Exposure.resource("textures/gui/camera_attachments.png");
    protected final Player player;
    protected Map<Integer, Rect2i> slotPlaceholders = Collections.emptyMap();
    protected final HoveredElement flash = new HoveredElement(List.of(new Rect2i(96, 11, 28, 27)), () -> ((CameraAttachmentsMenu)this.m_6262_()).m_38853_(CameraItem.FLASH_ATTACHMENT.slot()).m_6657_());
    protected final HoveredElement filterOnLens = new HoveredElement(List.of(new Rect2i(114, 57, 13, 6), new Rect2i(110, 63, 17, 24)), () -> ((CameraAttachmentsMenu)this.m_6262_()).m_38853_(CameraItem.LENS_ATTACHMENT.slot()).m_6657_());
    protected final HoveredElement lens = new HoveredElement(List.of(new Rect2i(93, 48, 33, 34)), () -> ((CameraAttachmentsMenu)this.m_6262_()).m_38853_(CameraItem.LENS_ATTACHMENT.slot()).m_6657_());
    protected final HoveredElement filter = new HoveredElement(List.of(new Rect2i(110, 55, 13, 6), new Rect2i(106, 61, 17, 24)), () -> !((CameraAttachmentsMenu)this.m_6262_()).m_38853_(CameraItem.LENS_ATTACHMENT.slot()).m_6657_());
    protected final HoveredElement lensBuiltIn = new HoveredElement(List.of(new Rect2i(93, 48, 29, 32)), () -> !((CameraAttachmentsMenu)this.m_6262_()).m_38853_(CameraItem.LENS_ATTACHMENT.slot()).m_6657_());
    protected final HoveredElement viewfinder = new HoveredElement(List.of(new Rect2i(65, 25, 30, 12), new Rect2i(72, 31, 39, 11), new Rect2i(80, 42, 24, 5)), () -> true);

    public CameraAttachmentsScreen(CameraAttachmentsMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.player = playerInventory.f_35978_;
    }

    public void m_274333_() {
        OnePerPlayerSounds.play(this.player, Exposure.SoundEvents.CAMERA_GENERIC_CLICK.get(), SoundSource.PLAYERS, 0.9f, 0.9f);
    }

    protected void m_7856_() {
        this.f_97727_ = 185;
        this.f_97731_ = this.f_97727_ - 94;
        super.m_7856_();
        this.slotPlaceholders = Map.of(CameraItem.FILM_ATTACHMENT.slot(), new Rect2i(238, 0, 18, 18), CameraItem.FLASH_ATTACHMENT.slot(), new Rect2i(238, 18, 18, 18), CameraItem.LENS_ATTACHMENT.slot(), new Rect2i(238, 36, 18, 18), CameraItem.FILTER_ATTACHMENT.slot(), new Rect2i(238, 54, 18, 18));
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        for (Slot slot : ((CameraAttachmentsMenu)this.m_6262_()).f_38839_) {
            if (slot.m_8010_(this.player)) continue;
            guiGraphics.m_280480_(slot.m_7993_(), this.f_97735_ + slot.f_40220_, this.f_97736_ + slot.f_40221_);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            guiGraphics.m_280398_(TEXTURE, this.f_97735_ + slot.f_40220_ - 2, this.f_97736_ + slot.f_40221_ - 2, 350, 236.0f, 92.0f, 20, 20, 256, 256);
            RenderSystem.disableBlend();
        }
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    protected void m_7286_(@NotNull GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.m_280218_(TEXTURE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        this.renderSlotPlaceholders(guiGraphics, mouseX, mouseY, partialTick);
        this.renderAttachments(guiGraphics, mouseX, mouseY, partialTick);
        for (Slot slot : ((CameraAttachmentsMenu)this.m_6262_()).f_38839_) {
            if (slot.m_8010_(this.player)) continue;
            guiGraphics.m_280218_(TEXTURE, this.f_97735_ + slot.f_40220_ - 2, this.f_97736_ + slot.f_40221_ - 2, 236, 72, 20, 20);
        }
        RenderSystem.disableBlend();
    }

    private void renderAttachments(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int filterY;
        boolean hasLens;
        if (((CameraAttachmentsMenu)this.m_6262_()).m_38853_(CameraItem.FLASH_ATTACHMENT.slot()).m_6657_()) {
            int vOffset = this.isMouseOver(this.flash, mouseX, mouseY) ? 28 : 0;
            guiGraphics.m_280218_(TEXTURE, this.f_97735_ + 96, this.f_97736_ + 11, 176, vOffset, 28, 28);
        }
        if (hasLens = ((CameraAttachmentsMenu)this.m_6262_()).m_38853_(CameraItem.LENS_ATTACHMENT.slot()).m_6657_()) {
            int vOffset = this.isMouseOver(this.lens, mouseX, mouseY) && !this.isMouseOver(this.filterOnLens, mouseX, mouseY) ? 37 : 0;
            guiGraphics.m_280218_(TEXTURE, this.f_97735_ + 93, this.f_97736_ + 47, 176, 56 + vOffset, 35, 37);
        } else if (this.isMouseOver(this.lensBuiltIn, mouseX, mouseY) && !this.isMouseOver(this.filter, mouseX, mouseY)) {
            guiGraphics.m_280218_(TEXTURE, this.f_97735_ + 93, this.f_97736_ + 47, 176, 130, 31, 35);
        }
        Slot filterSlot = ((CameraAttachmentsMenu)this.m_6262_()).m_38853_(CameraItem.FILTER_ATTACHMENT.slot());
        int filterX = hasLens ? 102 : 98;
        int n = filterY = hasLens ? 54 : 52;
        if (filterSlot.m_6657_()) {
            Filters.of(filterSlot.m_7993_()).ifPresent(filter -> {
                int tintRGB = filter.getTintColor();
                float r = (float)(tintRGB >> 16 & 0xFF) / 255.0f;
                float g = (float)(tintRGB >> 8 & 0xFF) / 255.0f;
                float b = (float)(tintRGB & 0xFF) / 255.0f;
                if (this.isMouseOver(this.filterOnLens, mouseX, mouseY) || this.isMouseOver(this.filter, mouseX, mouseY)) {
                    r *= 1.35f;
                    g *= 1.35f;
                    b *= 1.35f;
                }
                RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)1.0f);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                ResourceLocation filterTexture = filter.getAttachmentTexture();
                guiGraphics.m_280163_(filterTexture, this.f_97735_ + filterX, this.f_97736_ + filterY, 0.0f, 0.0f, 32, 32, 32, 32);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            });
        } else if (this.isMouseOver(this.filterOnLens, mouseX, mouseY)) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            guiGraphics.m_280218_(TEXTURE, this.f_97735_ + 110, this.f_97736_ + 58, 176, 165, 15, 23);
        } else if (this.isMouseOver(this.filter, mouseX, mouseY)) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            guiGraphics.m_280218_(TEXTURE, this.f_97735_ + 106, this.f_97736_ + 56, 176, 165, 15, 23);
        }
        if (this.isMouseOver(this.viewfinder, mouseX, mouseY) && !this.isMouseOver(this.flash, mouseX, mouseY)) {
            guiGraphics.m_280218_(TEXTURE, this.f_97735_ + 65, this.f_97736_ + 24, 42, 185, 49, 26);
        }
    }

    protected boolean isMouseOver(HoveredElement element, int mouseX, int mouseY) {
        if (!element.isEnabled.get().booleanValue()) {
            return false;
        }
        mouseX -= this.f_97735_;
        mouseY -= this.f_97736_;
        for (Rect2i area : element.hoverArea) {
            if (mouseX < area.m_110085_() || mouseX >= area.m_110085_() + area.m_110090_() || mouseY < area.m_110086_() || mouseY >= area.m_110086_() + area.m_110091_()) continue;
            return true;
        }
        return false;
    }

    protected void renderSlotPlaceholders(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        for (int slotIndex : this.slotPlaceholders.keySet()) {
            Slot slot = ((CameraAttachmentsMenu)this.m_6262_()).m_38853_(slotIndex);
            if (slot.m_6657_()) continue;
            Rect2i placeholder = this.slotPlaceholders.get(slotIndex);
            guiGraphics.m_280218_(TEXTURE, this.f_97735_ + slot.f_40220_ - 1, this.f_97736_ + slot.f_40221_ - 1, placeholder.m_110085_(), placeholder.m_110086_(), placeholder.m_110090_(), placeholder.m_110091_());
        }
    }

    protected void m_280072_(GuiGraphics guiGraphics, int x, int y) {
        if (this.isMouseOver(this.flash, x, y)) {
            guiGraphics.m_280245_(this.f_96547_, this.f_96547_.m_92923_((FormattedText)Component.m_237115_((String)"gui.exposure.camera_attachments.flash.tooltip"), 230), x, y);
        } else if (this.isMouseOver(this.viewfinder, x, y)) {
            MutableComponent key = Component.m_237113_((String)ExposureClient.getCameraControlsKey().m_90863_().getString()).m_130940_(ChatFormatting.GRAY);
            MutableComponent middleClick = (Boolean)Config.Client.VIEWFINDER_MIDDLE_CLICK_CONTROLS.get() != false ? Component.m_237115_((String)"gui.exposure.camera_attachments.viewfinder.tooltip.or_middle_click") : Component.m_237119_();
            guiGraphics.m_280245_(this.f_96547_, this.f_96547_.m_92923_((FormattedText)Component.m_237110_((String)"gui.exposure.camera_attachments.viewfinder.tooltip", (Object[])new Object[]{key, middleClick}), 230), x, y);
        } else if (this.isMouseOver(this.filter, x, y) || this.isMouseOver(this.filterOnLens, x, y)) {
            guiGraphics.m_280245_(this.f_96547_, this.f_96547_.m_92923_((FormattedText)Component.m_237115_((String)"gui.exposure.camera_attachments.filter.tooltip"), 230), x, y);
        } else if (this.isMouseOver(this.lens, x, y) || this.isMouseOver(this.lensBuiltIn, x, y)) {
            guiGraphics.m_280245_(this.f_96547_, this.f_96547_.m_92923_((FormattedText)Component.m_237115_((String)"gui.exposure.camera_attachments.lens.tooltip"), 230), x, y);
        } else {
            super.m_280072_(guiGraphics, x, y);
        }
    }

    @NotNull
    protected List<Component> m_280553_(ItemStack stack) {
        List tooltip = super.m_280553_(stack);
        if (stack.m_204117_(Exposure.Tags.Items.LENSES) && this.f_97734_ != null && this.f_97734_.m_7993_().equals(stack)) {
            tooltip.add(Component.m_237110_((String)"gui.exposure.viewfinder.focal_length", (Object[])new Object[]{FocalRange.ofStack(stack).m_7912_()}).m_130940_(ChatFormatting.GOLD));
        }
        return tooltip;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int x = (int)mouseX;
        int y = (int)mouseY;
        if (this.isMouseOver(this.filter, x, y) || this.isMouseOver(this.filterOnLens, x, y)) {
            ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
            for (Holder holder : BuiltInRegistries.f_257033_.m_206058_(Exposure.Tags.Items.FILTERS)) {
                itemStacks.add(new ItemStack(holder));
            }
            ItemListScreen screen = new ItemListScreen((Screen)this, (Component)Component.m_237115_((String)"gui.exposure.filters"), itemStacks){

                @Override
                protected List<Component> getTooltipFromContainerItem(ItemStack stack) {
                    List<Component> tooltip = super.getTooltipFromContainerItem(stack);
                    if (Minecraft.m_91087_().f_91066_.f_92125_) {
                        Filters.of(stack).ifPresent(filter -> tooltip.add((Component)Component.m_237113_((String)filter.getShader().toString()).m_130940_(ChatFormatting.GRAY)));
                    }
                    return tooltip;
                }
            };
            Minecraft.m_91087_().m_91152_((Screen)screen);
            return true;
        }
        if (this.isMouseOver(this.lens, x, y) || this.isMouseOver(this.lensBuiltIn, x, y)) {
            ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
            for (Holder holder : BuiltInRegistries.f_257033_.m_206058_(Exposure.Tags.Items.LENSES)) {
                itemStacks.add(new ItemStack(holder));
            }
            Object screen = new ItemListScreen((Screen)this, (Component)Component.m_237115_((String)"gui.exposure.lenses"), itemStacks){

                @Override
                protected List<Component> getTooltipFromContainerItem(ItemStack stack) {
                    List<Component> tooltip = super.getTooltipFromContainerItem(stack);
                    Lenses.getFocalRangeOf(stack).ifPresent(fr -> tooltip.add((Component)Component.m_237110_((String)"gui.exposure.viewfinder.focal_length", (Object[])new Object[]{fr.m_7912_()}).m_130940_(ChatFormatting.GOLD)));
                    return tooltip;
                }
            };
            Minecraft.m_91087_().m_91152_(screen);
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public record HoveredElement(List<Rect2i> hoverArea, Supplier<Boolean> isEnabled) {
    }
}

