/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.gui.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.mortuusars.exposure.Exposure;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemListScreen
extends Screen {
    public static final ResourceLocation TEXTURE = Exposure.resource("textures/gui/item_list.png");
    protected final Screen parent;
    protected final List<ItemStack> items;
    protected int imageWidth = 176;
    protected int imageHeight = 166;
    protected int titleLabelX = 8;
    protected int titleLabelY = 6;
    protected int leftPos;
    protected int topPos;
    protected int rowsCount;
    @Nullable
    protected Slot hoveredSlot;
    protected List<Slot> slots = new ArrayList<Slot>();
    protected long openedAt;

    public ItemListScreen(Screen parent, Component title, List<ItemStack> items) {
        super(title);
        this.parent = parent;
        this.items = items;
        this.openedAt = Util.m_137550_();
        SimpleContainer container = new SimpleContainer((ItemStack[])items.toArray(ItemStack[]::new));
        List rows = Lists.partition(items, (int)9);
        this.rowsCount = rows.size();
        int rowX = 8;
        int rowY = 18;
        for (int row = 0; row < rows.size(); ++row) {
            List stacks = (List)rows.get(row);
            int rowXToCenterOffset = (162 - stacks.size() * 18) / 2;
            for (int column = 0; column < stacks.size(); ++column) {
                int slotIndex = row * 9 + column;
                this.slots.add(new Slot((Container)container, slotIndex, rowX + rowXToCenterOffset + column * 18, rowY){

                    public boolean m_5857_(ItemStack stack) {
                        return false;
                    }

                    public boolean m_8010_(Player player) {
                        return false;
                    }
                });
            }
            rowY += 18;
        }
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)Exposure.SoundEvents.CAMERA_GENERIC_CLICK.get(), (float)1.0f));
    }

    public boolean m_7043_() {
        return false;
    }

    protected void m_7856_() {
        this.imageWidth = 176;
        this.imageHeight = 24 + this.rowsCount * 18;
        this.leftPos = (this.f_96543_ - this.imageWidth) / 2;
        this.topPos = (this.f_96544_ - this.imageHeight) / 2;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        long currentTime = Util.m_137550_();
        float animProgress = Math.min(1.0f, (float)(currentTime - this.openedAt) / 200.0f);
        animProgress = 1.0f - (float)Math.pow(1.0f - animProgress, 3.5);
        int left = this.leftPos;
        int top = this.topPos;
        this.m_280273_(guiGraphics);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)this.f_96543_ / 2.0f, (float)this.f_96544_ / 2.0f, 0.0f);
        guiGraphics.m_280168_().m_85841_(animProgress, animProgress, animProgress);
        guiGraphics.m_280168_().m_252880_(-((float)this.f_96543_ / 2.0f), -((float)this.f_96544_ / 2.0f), 0.0f);
        this.renderBg(guiGraphics, partialTick, mouseX, mouseY);
        RenderSystem.disableDepthTest();
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)left, (float)top, 0.0f);
        this.hoveredSlot = null;
        for (Slot slot : this.slots) {
            if (slot.m_6659_()) {
                this.renderSlot(guiGraphics, slot);
            }
            if (!this.isHovering(slot, mouseX, mouseY) || !slot.m_6659_()) continue;
            this.hoveredSlot = slot;
            if (!this.hoveredSlot.m_280329_()) continue;
            ItemListScreen.renderSlotHighlight(guiGraphics, slot.f_40220_, slot.f_40221_, 0);
        }
        this.renderLabels(guiGraphics, mouseX, mouseY);
        guiGraphics.m_280168_().m_85849_();
        RenderSystem.enableDepthTest();
        guiGraphics.m_280168_().m_85849_();
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(@NotNull GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280218_(TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, 17);
        for (int i = 0; i < this.rowsCount; ++i) {
            guiGraphics.m_280218_(TEXTURE, this.leftPos, this.topPos + 17 + i * 18, 0, 17, this.imageWidth, 18);
        }
        guiGraphics.m_280218_(TEXTURE, this.leftPos, this.topPos + 17 + this.rowsCount * 18, 0, 35, this.imageWidth, 7);
        for (Slot slot : this.slots) {
            guiGraphics.m_280218_(TEXTURE, this.leftPos + slot.f_40220_ - 1, this.topPos + slot.f_40221_ - 1, 176, 0, 18, 18);
        }
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.m_280614_(this.f_96547_, this.f_96539_, this.titleLabelX, this.titleLabelY, 0x404040, false);
    }

    protected void renderSlot(GuiGraphics guiGraphics, Slot slot) {
        int x = slot.f_40220_;
        int y = slot.f_40221_;
        ItemStack itemStack = slot.m_7993_();
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 100.0f);
        guiGraphics.m_280256_(itemStack, x, y, slot.f_40220_ + slot.f_40221_ * this.imageWidth);
        guiGraphics.m_280302_(this.f_96547_, itemStack, x, y, null);
        guiGraphics.m_280168_().m_85849_();
    }

    public static void renderSlotHighlight(GuiGraphics guiGraphics, int x, int y, int blitOffset) {
        guiGraphics.m_285978_(RenderType.m_286086_(), x, y, x + 16, y + 16, -2130706433, -2130706433, blitOffset);
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int x, int y) {
        if (this.hoveredSlot != null && this.hoveredSlot.m_6657_()) {
            ItemStack itemStack = this.hoveredSlot.m_7993_();
            guiGraphics.m_280677_(this.f_96547_, this.getTooltipFromContainerItem(itemStack), itemStack.m_150921_(), x, y);
        }
    }

    protected List<Component> getTooltipFromContainerItem(ItemStack stack) {
        return AbstractContainerScreen.m_280152_((Minecraft)Minecraft.m_91087_(), (ItemStack)stack);
    }

    protected boolean isHovering(Slot slot, double mouseX, double mouseY) {
        return this.isHovering(slot.f_40220_, slot.f_40221_, 16, 16, mouseX, mouseY);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isHovering(int x, int y, int width, int height, double mouseX, double mouseY) {
        double d;
        double d2;
        int i = this.leftPos;
        int j = this.topPos;
        mouseX -= (double)i;
        if (!(d2 >= (double)(x - 1))) return false;
        if (!(mouseX < (double)(x + width + 1))) return false;
        mouseY -= (double)j;
        if (!(d >= (double)(y - 1))) return false;
        if (!(mouseY < (double)(y + height + 1))) return false;
        return true;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (Minecraft.m_91087_().f_91066_.f_92092_.m_90832_(keyCode, scanCode)) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_7379_() {
        Minecraft.m_91087_().m_91152_(this.parent);
    }
}

