/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.camera.capture.component;

import com.mojang.blaze3d.platform.NativeImage;
import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.camera.capture.Capture;
import io.github.mortuusars.exposure.camera.capture.component.ICaptureComponent;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;

public class BaseComponent
implements ICaptureComponent {
    private final boolean hideGuiValue;
    private boolean storedGuiHidden;
    private CameraType storedCameraType;

    public BaseComponent(boolean hideGuiOnCapture) {
        this.hideGuiValue = hideGuiOnCapture;
        this.storedGuiHidden = false;
        this.storedCameraType = CameraType.FIRST_PERSON;
    }

    public BaseComponent() {
        this(true);
    }

    @Override
    public int getFramesDelay(Capture capture) {
        return 1 + (Integer)Config.Client.CAPTURE_DELAY_FRAMES.get();
    }

    @Override
    public void onDelayFrame(Capture capture, int delayFramesLeft) {
        if (delayFramesLeft == Math.max(0, this.getFramesDelay(capture) - 1)) {
            Minecraft mc = Minecraft.m_91087_();
            this.storedGuiHidden = mc.f_91066_.f_92062_;
            this.storedCameraType = mc.f_91066_.m_92176_();
            mc.f_91066_.f_92062_ = this.hideGuiValue;
            CameraType cameraType = Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.THIRD_PERSON_FRONT ? CameraType.THIRD_PERSON_FRONT : CameraType.FIRST_PERSON;
            mc.f_91066_.m_92157_(cameraType);
        }
    }

    @Override
    public void imageTaken(Capture capture, NativeImage screenshot) {
        Minecraft mc = Minecraft.m_91087_();
        mc.f_91066_.f_92062_ = this.storedGuiHidden;
        mc.f_91066_.m_92157_(this.storedCameraType);
    }
}

