/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.camera.capture;

import com.google.common.collect.ImmutableList;
import io.github.mortuusars.exposure.Exposure;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;

public class CapturedFramesHistory {
    private static final ArrayList<CompoundTag> lastExposures = new ArrayList();
    private static int limit = 32;

    public static List<CompoundTag> get() {
        return ImmutableList.copyOf(lastExposures);
    }

    public static void add(CompoundTag frame) {
        if (frame.m_128461_("Id").isEmpty()) {
            Exposure.LOGGER.warn("{} - frame might not be valid. No ID is present.", (Object)frame);
        }
        lastExposures.add(0, frame);
        while (lastExposures.size() > limit) {
            lastExposures.remove(limit);
        }
    }

    public static int getLimit() {
        return limit;
    }

    public static void setLimit(int limit) {
        CapturedFramesHistory.limit = limit;
    }

    public static void clear() {
        lastExposures.clear();
    }
}

