/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.camera.capture;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.platform.NativeImage;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.camera.capture.component.ICaptureComponent;
import io.github.mortuusars.exposure.camera.capture.converter.IImageToMapColorsConverter;
import io.github.mortuusars.exposure.camera.capture.converter.SimpleColorConverter;
import io.github.mortuusars.exposure.camera.infrastructure.FilmType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Capture {
    protected FilmType type = FilmType.COLOR;
    protected int size = 320;
    protected float cropFactor = 1.142857f;
    protected float brightnessStops = 0.0f;
    protected boolean asyncCapturing = false;
    protected boolean asyncProcessing = true;
    protected ArrayList<ICaptureComponent> components = new ArrayList();
    protected IImageToMapColorsConverter converter = new SimpleColorConverter();
    protected Runnable onImageCaptured = () -> {};
    protected Runnable onCapturingFailed = () -> {};
    protected int ticksDelay = -1;
    protected int framesDelay = -1;
    protected long captureTick;
    protected long currentTick;
    protected boolean isCapturing = false;
    protected boolean done = false;

    @Nullable
    public abstract NativeImage captureImage();

    public boolean isDone() {
        return this.done;
    }

    public int getTicksDelay() {
        return (int)(this.captureTick - Objects.requireNonNull(Minecraft.m_91087_().f_91073_).m_46467_());
    }

    public int getFramesDelay() {
        return this.framesDelay;
    }

    public FilmType getFilmType() {
        return this.type;
    }

    public Capture setFilmType(FilmType type) {
        this.type = type;
        return this;
    }

    public int getSize() {
        return this.size;
    }

    public Capture setSize(int size) {
        Preconditions.checkArgument((size > 0 ? 1 : 0) != 0, (String)"'size [{}] is not valid' should be larger than 0.", (int)size);
        this.size = size;
        return this;
    }

    public float getCropFactor() {
        return this.cropFactor;
    }

    public Capture cropFactor(float cropFactor) {
        Preconditions.checkArgument((cropFactor != 0.0f ? 1 : 0) != 0, (String)"'cropFactor [{}] is not valid' should be larger than 0.", (Object)Float.valueOf(cropFactor));
        this.cropFactor = cropFactor;
        return this;
    }

    public float getBrightnessStops() {
        return this.brightnessStops;
    }

    public Capture setBrightnessStops(float brightnessStops) {
        this.brightnessStops = brightnessStops;
        return this;
    }

    public Capture setAsyncCapturing(boolean asyncCapturing) {
        this.asyncCapturing = asyncCapturing;
        return this;
    }

    public Capture setAsyncProcessing(boolean asyncProcessing) {
        this.asyncProcessing = asyncProcessing;
        return this;
    }

    public Capture addComponent(ICaptureComponent component) {
        this.components.add(component);
        return this;
    }

    public Capture addComponents(ICaptureComponent ... components) {
        this.components.addAll(Arrays.asList(components));
        return this;
    }

    public Capture setComponents(ICaptureComponent ... components) {
        this.components = Arrays.stream(components).collect(Collectors.toCollection(ArrayList::new));
        return this;
    }

    public Capture setComponents(Collection<ICaptureComponent> components) {
        this.components = new ArrayList<ICaptureComponent>(components);
        return this;
    }

    public Capture setConverter(IImageToMapColorsConverter converter) {
        this.converter = converter;
        return this;
    }

    public Capture onImageCaptured(Runnable runnable) {
        this.onImageCaptured = runnable;
        return this;
    }

    public Capture onCapturingFailed(Runnable runnable) {
        this.onCapturingFailed = runnable;
        return this;
    }

    public void initialize() {
        for (ICaptureComponent modifier : this.components) {
            this.ticksDelay = Math.max(this.ticksDelay, modifier.getTicksDelay(this));
            this.framesDelay = Math.max(this.framesDelay, modifier.getFramesDelay(this));
        }
        for (ICaptureComponent modifier : this.components) {
            modifier.initialize(this);
        }
        this.currentTick = Objects.requireNonNull(Minecraft.m_91087_().f_91073_).m_46467_();
        this.captureTick = this.currentTick + (long)this.ticksDelay;
        if (this.currentTick == this.captureTick && this.framesDelay <= 0) {
            for (ICaptureComponent modifier : this.components) {
                modifier.onDelayTick(this, 0);
                modifier.onDelayFrame(this, 0);
            }
        }
    }

    public synchronized void tick() {
        if (this.delayTick() || this.isCapturing) {
            return;
        }
        this.isCapturing = true;
        if (this.asyncCapturing) {
            new Thread(() -> {
                @Nullable NativeImage image = this.captureImage();
                this.onImageCaptured(image);
            }).start();
        } else {
            @Nullable NativeImage image = this.captureImage();
            this.onImageCaptured(image);
        }
    }

    protected boolean delayTick() {
        long lastTick = this.currentTick;
        this.currentTick = Objects.requireNonNull(Minecraft.m_91087_().f_91073_).m_46467_();
        if (this.ticksDelay > 0) {
            if (lastTick < this.currentTick) {
                --this.ticksDelay;
                for (ICaptureComponent modifier : this.components) {
                    modifier.onDelayTick(this, this.ticksDelay);
                }
                if (this.ticksDelay == 0 && this.framesDelay == 0) {
                    for (ICaptureComponent modifier : this.components) {
                        modifier.onDelayFrame(this, 0);
                    }
                }
            }
            return true;
        }
        if (this.framesDelay > 0) {
            --this.framesDelay;
            for (ICaptureComponent modifier : this.components) {
                modifier.onDelayFrame(this, this.framesDelay);
            }
            return true;
        }
        return false;
    }

    protected void onImageCaptured(@Nullable NativeImage image) {
        if (image == null) {
            this.done = true;
            this.isCapturing = false;
            this.onCapturingFailed.run();
            return;
        }
        this.onImageCaptured.run();
        if (this.asyncCapturing) {
            Minecraft.m_91087_().execute(() -> {
                for (ICaptureComponent modifier : this.components) {
                    modifier.imageTaken(this, image);
                }
            });
        } else {
            for (ICaptureComponent modifier : this.components) {
                modifier.imageTaken(this, image);
            }
        }
        if (this.asyncProcessing && !this.asyncCapturing) {
            new Thread(() -> this.processImage(image)).start();
        } else {
            this.processImage(image);
        }
        this.done = true;
        this.isCapturing = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public void processImage(@NotNull NativeImage image) {
        block28: {
            try {
                processedImage = this.scaleCropAndProcess(image);
                try {
                    if (processedImage == null) {
                        return;
                    }
                    modifiedImage = processedImage;
                    for (Object component : this.components) {
                        modifiedImage = component.modifyImage(this, modifiedImage);
                    }
                    pixels = this.converter.convert(this, modifiedImage);
                    for (ICaptureComponent component : this.components) {
                        component.teardown(this);
                    }
                    propertiesTag = new CompoundTag();
                    this.addSavedDataProperties(propertiesTag);
                    for (ICaptureComponent component : this.components) {
                        component.save(pixels, modifiedImage.m_84982_(), modifiedImage.m_85084_(), propertiesTag);
                    }
                }
                finally {
                    if (processedImage != null) {
                        processedImage.close();
                    }
                }
                ** try [egrp 6[TRYBLOCK] [4 : 282->322)] { 
            }
            catch (Exception e) {
                Exposure.LOGGER.error(e.toString());
                break block28;
            }
            finally {
                try {
                    for (ICaptureComponent component : this.components) {
                        component.end(this);
                    }
                }
                catch (Exception e) {
                    Exposure.LOGGER.error(e.toString());
                }
                this.isCapturing = false;
            }
lbl-1000:
            // 2 sources

            {
                for (ICaptureComponent component : this.components) {
                    component.end(this);
                }
            }
lbl31:
            // 1 sources

            catch (Exception e) {
                Exposure.LOGGER.error(e.toString());
            }
            this.isCapturing = false;
        }
    }

    protected void addSavedDataProperties(CompoundTag tag) {
        tag.m_128359_("Type", this.getFilmType().m_7912_());
    }

    @Nullable
    protected NativeImage scaleCropAndProcess(@NotNull NativeImage sourceImage) {
        NativeImage nativeImage;
        block8: {
            int sWidth = sourceImage.m_84982_();
            int sHeight = sourceImage.m_85084_();
            int sourceSize = Math.min(sWidth, sHeight);
            float crop = (float)sourceSize - (float)sourceSize / this.getCropFactor();
            sourceSize -= (int)crop;
            int sourceXStart = sWidth > sHeight ? (sWidth - sHeight) / 2 : 0;
            int sourceYStart = sHeight > sWidth ? (sHeight - sWidth) / 2 : 0;
            sourceXStart += (int)(crop / 2.0f);
            sourceYStart += (int)(crop / 2.0f);
            int size = this.getSize();
            NativeImage nativeImage2 = sourceImage;
            try {
                nativeImage = this.resizeWithModification(sourceImage, sourceXStart, sourceYStart, sourceSize, sourceSize, size, size);
                if (nativeImage2 == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (nativeImage2 != null) {
                        try {
                            nativeImage2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Exposure.LOGGER.error("Failed to process an image: {}", (Object)e.toString());
                    return null;
                }
            }
            nativeImage2.close();
        }
        return nativeImage;
    }

    public NativeImage resizeWithModification(NativeImage source, int sourceX, int sourceY, int sourceWidth, int sourceHeight, int resultWidth, int resultHeight) {
        NativeImage result = new NativeImage(source.m_85102_(), resultWidth, resultHeight, false);
        for (int x = 0; x < resultWidth; ++x) {
            float ratioX = (float)x / (float)resultWidth;
            int sourcePosX = (int)((float)sourceX + (float)sourceWidth * ratioX);
            for (int y = 0; y < resultHeight; ++y) {
                float ratioY = (float)y / (float)resultHeight;
                int sourcePosY = (int)((float)sourceY + (float)sourceHeight * ratioY);
                int colorABGR = source.m_84985_(sourcePosX, sourcePosY);
                for (ICaptureComponent component : this.components) {
                    colorABGR = component.modifyPixel(this, colorABGR);
                }
                result.m_84988_(x, y, colorABGR);
            }
        }
        return result;
    }
}

