/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.advancement.predicate;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import io.github.mortuusars.exposure.item.CameraItem;
import io.github.mortuusars.exposure.util.ItemAndStack;
import java.util.Objects;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class CameraPredicate {
    public static final CameraPredicate ANY = new CameraPredicate(ItemPredicate.f_45028_, MinMaxBounds.Doubles.f_154779_, MinMaxBounds.Ints.f_55364_, ItemPredicate.f_45028_, ItemPredicate.f_45028_, ItemPredicate.f_45028_, ItemPredicate.f_45028_);
    private final ItemPredicate camera;
    private final MinMaxBounds.Doubles shutterSpeedMS;
    private final MinMaxBounds.Ints focalLength;
    private final ItemPredicate film;
    private final ItemPredicate flash;
    private final ItemPredicate lens;
    private final ItemPredicate filter;

    public CameraPredicate(ItemPredicate camera, MinMaxBounds.Doubles shutterSpeedMS, MinMaxBounds.Ints focalLength, ItemPredicate film, ItemPredicate flash, ItemPredicate lens, ItemPredicate filter) {
        this.camera = camera;
        this.shutterSpeedMS = shutterSpeedMS;
        this.focalLength = focalLength;
        this.film = film;
        this.flash = flash;
        this.lens = lens;
        this.filter = filter;
    }

    public boolean matches(ItemAndStack<CameraItem> camera) {
        if (this.equals(ANY)) {
            return true;
        }
        ItemStack stack = camera.getStack();
        CameraItem item = camera.getItem();
        return this.camera.m_45049_(stack) && this.shutterSpeedMS.m_154810_((double)item.getShutterSpeed(stack).getMilliseconds()) && this.focalLength.m_55390_(Mth.m_14167_((float)item.getFocalLength(stack))) && this.film.m_45049_(item.getAttachment(stack, CameraItem.FILM_ATTACHMENT).orElse(ItemStack.f_41583_)) && this.flash.m_45049_(item.getAttachment(stack, CameraItem.FLASH_ATTACHMENT).orElse(ItemStack.f_41583_)) && this.lens.m_45049_(item.getAttachment(stack, CameraItem.LENS_ATTACHMENT).orElse(ItemStack.f_41583_)) && this.filter.m_45049_(item.getAttachment(stack, CameraItem.FILTER_ATTACHMENT).orElse(ItemStack.f_41583_));
    }

    public JsonElement serializeToJson() {
        if (this == ANY) {
            return JsonNull.INSTANCE;
        }
        JsonObject json = new JsonObject();
        json.add("camera", this.camera.m_45048_());
        json.add("shutter_speed_ms", this.shutterSpeedMS.m_55328_());
        json.add("focal_length", this.focalLength.m_55328_());
        json.add("film", this.film.m_45048_());
        json.add("flash", this.flash.m_45048_());
        json.add("lens", this.lens.m_45048_());
        json.add("filter", this.filter.m_45048_());
        return json;
    }

    public static CameraPredicate fromJson(@Nullable JsonElement json) {
        if (json == null || json.isJsonNull()) {
            return ANY;
        }
        JsonObject jsonObj = GsonHelper.m_13918_((JsonElement)json, (String)"camera");
        return new CameraPredicate(ItemPredicate.m_45051_((JsonElement)jsonObj.getAsJsonObject("camera")), MinMaxBounds.Doubles.m_154791_((JsonElement)jsonObj.getAsJsonObject("shutter_speed_ms")), MinMaxBounds.Ints.m_55373_((JsonElement)jsonObj.getAsJsonObject("focal_length")), ItemPredicate.m_45051_((JsonElement)jsonObj.getAsJsonObject("film")), ItemPredicate.m_45051_((JsonElement)jsonObj.getAsJsonObject("flash")), ItemPredicate.m_45051_((JsonElement)jsonObj.getAsJsonObject("lens")), ItemPredicate.m_45051_((JsonElement)jsonObj.getAsJsonObject("filter")));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CameraPredicate that = (CameraPredicate)o;
        return Objects.equals(this.camera, that.camera) && Objects.equals(this.shutterSpeedMS, that.shutterSpeedMS) && Objects.equals(this.focalLength, that.focalLength) && Objects.equals(this.film, that.film) && Objects.equals(this.flash, that.flash) && Objects.equals(this.lens, that.lens) && Objects.equals(this.filter, that.filter);
    }

    public int hashCode() {
        return Objects.hash(this.camera, this.shutterSpeedMS, this.focalLength, this.film, this.flash, this.lens, this.filter);
    }
}

