/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.camera.capture.component;

import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.camera.capture.component.ICaptureComponent;
import io.github.mortuusars.exposure.data.storage.ExposureSavedData;
import net.minecraft.class_2487;

public class ExposureStorageSaveComponent
implements ICaptureComponent {
    private final String exposureId;
    private final boolean sendToServer;

    public ExposureStorageSaveComponent(String exposureId, boolean sendToServer) {
        this.exposureId = exposureId;
        this.sendToServer = sendToServer;
    }

    @Override
    public boolean save(byte[] pixels, int width, int height, class_2487 properties) {
        long unixTime = System.currentTimeMillis() / 1000L;
        properties.method_10544("Timestamp", unixTime);
        ExposureSavedData exposureSavedData = new ExposureSavedData(width, height, pixels, properties);
        ExposureClient.getExposureStorage().put(this.exposureId, exposureSavedData);
        if (this.sendToServer) {
            ExposureClient.getExposureSender().send(this.exposureId, exposureSavedData);
        }
        return true;
    }
}

