/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.entityculling.util;

import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.ArrayUtils;

public final class ModLoaderUtil {
    public static void registerKeybind(KeyMapping keyBinding) {
        Minecraft.m_91087_().f_91066_.f_92059_ = (KeyMapping[])ArrayUtils.add((Object[])Minecraft.m_91087_().f_91066_.f_92059_, (Object)keyBinding);
    }

    public static void registerClientTickListener(final Runnable runnable) {
        MinecraftForge.EVENT_BUS.addListener((Consumer)new Consumer<TickEvent.ClientTickEvent>(){

            @Override
            public void accept(TickEvent.ClientTickEvent t) {
                if (t.phase != TickEvent.Phase.START) {
                    return;
                }
                runnable.run();
            }
        });
    }

    public static boolean isModLoaded(String name) {
        return ModList.get().isLoaded(name);
    }

    public static void disableDisplayTest() {
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> ModLoadingContext.get().getActiveContainer().getModInfo().getVersion().toString(), (remote, isServer) -> true));
    }

    public static void registerConfigScreen(Function<Screen, Screen> createScreen) {
        ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((mc, screen) -> (Screen)createScreen.apply((Screen)screen)));
    }

    public static void registerClientSetupListener(final Runnable runnable) {
        FMLJavaModLoadingContext.get().getModEventBus().addListener((Consumer)new Consumer<FMLClientSetupEvent>(){

            @Override
            public void accept(FMLClientSetupEvent t) {
                runnable.run();
            }
        });
    }

    public static <T extends Event> void registerForgeEvent(Consumer<T> handler) {
        MinecraftForge.EVENT_BUS.addListener(handler);
    }

    @Generated
    private ModLoaderUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

