/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.features.world.biome;

import java.util.Optional;
import me.jellysquid.mods.sodium.client.world.biome.BiomeColorMaps;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Biome.class})
public abstract class BiomeMixin {
    @Shadow
    @Final
    private BiomeSpecialEffects f_47443_;
    @Shadow
    @Final
    private Biome.ClimateSettings f_47437_;
    @Unique
    private boolean hasCustomGrassColor;
    @Unique
    private int customGrassColor;
    @Unique
    private boolean hasCustomFoliageColor;
    @Unique
    private int customFoliageColor;
    @Unique
    private int defaultColorIndex;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void setupColors(CallbackInfo ci) {
        Optional foliageColor;
        Optional grassColor = this.f_47443_.m_47984_();
        if (grassColor.isPresent()) {
            this.hasCustomGrassColor = true;
            this.customGrassColor = (Integer)grassColor.get();
        }
        if ((foliageColor = this.f_47443_.m_47981_()).isPresent()) {
            this.hasCustomFoliageColor = true;
            this.customFoliageColor = (Integer)foliageColor.get();
        }
        this.defaultColorIndex = this.getDefaultColorIndex();
    }

    @Overwrite
    public int m_47464_(double x, double z) {
        int color = this.hasCustomGrassColor ? this.customGrassColor : BiomeColorMaps.getGrassColor(this.defaultColorIndex);
        BiomeSpecialEffects.GrassColorModifier modifier = this.f_47443_.m_47987_();
        if (modifier != BiomeSpecialEffects.GrassColorModifier.NONE) {
            color = modifier.m_6583_(x, z, color);
        }
        return color;
    }

    @Overwrite
    public int m_47542_() {
        int color = this.hasCustomFoliageColor ? this.customFoliageColor : BiomeColorMaps.getFoliageColor(this.defaultColorIndex);
        return color;
    }

    @Unique
    private int getDefaultColorIndex() {
        double temperature = Mth.m_14036_((float)this.f_47437_.f_47681_(), (float)0.0f, (float)1.0f);
        double humidity = Mth.m_14036_((float)this.f_47437_.f_47683_(), (float)0.0f, (float)1.0f);
        return BiomeColorMaps.getIndex(temperature, humidity);
    }
}

