/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.util.workarounds;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import me.jellysquid.mods.sodium.client.gui.console.Console;
import me.jellysquid.mods.sodium.client.gui.console.message.MessageLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.ResourceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InGameChecks {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Sodium-InGameChecks");
    private static final List<String> VSH_FSH_BLACKLIST = Arrays.asList("rendertype_solid.vsh", "rendertype_solid.fsh", "rendertype_cutout_mipped.vsh", "rendertype_cutout_mipped.fsh", "rendertype_cutout.vsh", "rendertype_cutout.fsh", "rendertype_translucent.vsh", "rendertype_translucent.fsh", "rendertype_tripwire.vsh", "rendertype_tripwire.fsh");
    private static final List<String> GLSL_BLACKLIST = Arrays.asList("light.glsl", "fog.glsl");

    public static void checkIfCoreShaderLoaded(ResourceManager manager) {
        String message;
        HashMap detectedResourcePacks = new HashMap();
        Stream customResourcePacks = manager.m_7536_();
        customResourcePacks.forEach(resourcePack -> {
            if (!resourcePack.m_5542_().equals("vanilla") && !resourcePack.m_5542_().equals("fabric")) {
                String resourcePackName = resourcePack.m_5542_();
                resourcePack.m_8031_(PackType.CLIENT_RESOURCES, "minecraft", "shaders", (path, ignored) -> {
                    String shaderName = path.m_135815_().substring(path.m_135815_().lastIndexOf(47) + 1);
                    if (VSH_FSH_BLACKLIST.contains(shaderName)) {
                        if (!detectedResourcePacks.containsKey(resourcePackName)) {
                            detectedResourcePacks.put(resourcePackName, MessageLevel.SEVERE);
                        } else if (detectedResourcePacks.get(resourcePackName) == MessageLevel.WARN) {
                            detectedResourcePacks.replace(resourcePackName, MessageLevel.SEVERE);
                        }
                        LOGGER.error("Resource pack '" + resourcePackName + "' replaces core shader '" + shaderName + "'");
                    }
                    if (GLSL_BLACKLIST.contains(shaderName)) {
                        if (!detectedResourcePacks.containsKey(resourcePackName)) {
                            detectedResourcePacks.put(resourcePackName, MessageLevel.WARN);
                        }
                        LOGGER.warn("Resource pack '" + resourcePackName + "' replaces shader '" + shaderName + "'");
                    }
                });
            }
        });
        if (detectedResourcePacks.containsValue((Object)MessageLevel.SEVERE)) {
            InGameChecks.showConsoleMessage(Component.m_237115_((String)"sodium.console.core_shaders_error"), MessageLevel.SEVERE);
            for (Map.Entry entry : detectedResourcePacks.entrySet()) {
                if (entry.getValue() != MessageLevel.SEVERE) continue;
                message = ((String)entry.getKey()).startsWith("file/") ? ((String)entry.getKey()).substring(5) : (String)entry.getKey();
                InGameChecks.showConsoleMessage(Component.m_237113_((String)message), MessageLevel.SEVERE);
            }
        }
        if (detectedResourcePacks.containsValue((Object)MessageLevel.WARN)) {
            InGameChecks.showConsoleMessage(Component.m_237115_((String)"sodium.console.core_shaders_warn"), MessageLevel.WARN);
            for (Map.Entry entry : detectedResourcePacks.entrySet()) {
                if (entry.getValue() != MessageLevel.WARN) continue;
                message = ((String)entry.getKey()).startsWith("file/") ? ((String)entry.getKey()).substring(5) : (String)entry.getKey();
                InGameChecks.showConsoleMessage(Component.m_237113_((String)message), MessageLevel.WARN);
            }
        }
        if (!detectedResourcePacks.isEmpty()) {
            InGameChecks.showConsoleMessage(Component.m_237115_((String)"sodium.console.core_shaders_info"), MessageLevel.INFO);
        }
    }

    private static void showConsoleMessage(MutableComponent message, MessageLevel messageLevel) {
        Console.instance().logMessage(messageLevel, (Component)message, 20.0);
    }
}

