/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.compat.ccl;

import codechicken.lib.render.block.BlockRenderingRegistry;
import codechicken.lib.render.block.ICCBlockRenderer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.NotNull;

public class CCLCompat {
    public static Map<Holder<Block>, ICCBlockRenderer> customBlockRenderers;
    public static Map<Holder<Fluid>, ICCBlockRenderer> customFluidRenderers;
    public static List<ICCBlockRenderer> customGlobalRenderers;

    @NotNull
    public static List<ICCBlockRenderer> getCustomRenderers(@NotNull BlockAndTintGetter world, @NotNull BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        FluidState fluidState = state.m_60819_();
        Fluid fluid = fluidState.m_76152_();
        if (customGlobalRenderers == null) {
            return new ArrayList<ICCBlockRenderer>();
        }
        ArrayList<ICCBlockRenderer> renderers = new ArrayList<ICCBlockRenderer>(customGlobalRenderers);
        if (customBlockRenderers != null) {
            for (Map.Entry<Holder<Block>, ICCBlockRenderer> entry : customBlockRenderers.entrySet()) {
                Block entryBlock = (Block)entry.getKey().get();
                if (entryBlock != block) continue;
                renderers.add(entry.getValue());
            }
        }
        if (customFluidRenderers != null) {
            for (Map.Entry<Holder<Block>, ICCBlockRenderer> entry : customFluidRenderers.entrySet()) {
                Fluid entryFluid = (Fluid)entry.getKey().get();
                if (!entryFluid.m_6212_(fluid)) continue;
                renderers.add(entry.getValue());
            }
        }
        return renderers;
    }

    public static void init() {
        try {
            SodiumClientMod.logger().info("Retrieving block renderers");
            Field blockRenderersField = BlockRenderingRegistry.class.getDeclaredField("blockRenderers");
            blockRenderersField.setAccessible(true);
            customBlockRenderers = (Map)blockRenderersField.get(null);
            SodiumClientMod.logger().info("Retrieving fluid renderers");
            Field fluidRenderersField = BlockRenderingRegistry.class.getDeclaredField("fluidRenderers");
            fluidRenderersField.setAccessible(true);
            customFluidRenderers = (Map)fluidRenderersField.get(null);
            SodiumClientMod.logger().info("Retrieving global renderers");
            Field globalRenderersField = BlockRenderingRegistry.class.getDeclaredField("globalRenderers");
            globalRenderersField.setAccessible(true);
            customGlobalRenderers = (List)globalRenderersField.get(null);
        }
        catch (Throwable t) {
            SodiumClientMod.logger().error("Could not retrieve custom renderers");
        }
    }
}

