/*
 * Decompiled with CFR 0.152.
 */
package org.ladysnake.effective.cosmetics.particle;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_4003;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.ladysnake.effective.cosmetics.EffectiveCosmetics;
import org.ladysnake.effective.cosmetics.particle.type.LegacyFireflyParticleType;

@Environment(value=EnvType.CLIENT)
public class LegacyFireflyParticle
extends class_4003 {
    protected static final float BLINK_STEP = 0.05f;
    private final class_4002 spriteProvider;
    private final boolean isAttractedByLight = true;
    protected float nextAlphaGoal = 0.0f;
    protected double xTarget;
    protected double yTarget;
    protected double zTarget;
    protected int targetChangeCooldown = 0;
    protected int maxHeight;
    private class_2338 lightTarget;

    public LegacyFireflyParticle(class_638 world, double x, double y, double z, class_4002 spriteProvider) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.spriteProvider = spriteProvider;
        this.field_17867 *= 0.25f + this.field_3840.method_43057() * 0.5f;
        this.field_3847 = ThreadLocalRandom.current().nextInt(400, 1201);
        this.maxHeight = 4;
        this.field_3862 = true;
        this.method_18142(spriteProvider);
        this.field_3841 = 0.0f;
        this.field_3862 = false;
    }

    public static boolean canFlyThroughBlock(class_1937 world, class_2338 blockPos, class_2680 blockState) {
        return !blockState.method_26228((class_1922)world, blockPos);
    }

    public class_3999 method_18122() {
        return class_3999.field_17829;
    }

    public void method_3074(class_4588 vertexConsumer, class_4184 camera, float tickDelta) {
        Quaternionf quaternion2;
        class_243 vec3d = camera.method_19326();
        float f = (float)(class_3532.method_16436((double)tickDelta, (double)this.field_3858, (double)this.field_3874) - vec3d.method_10216());
        float g = (float)(class_3532.method_16436((double)tickDelta, (double)this.field_3838, (double)this.field_3854) - vec3d.method_10214());
        float h = (float)(class_3532.method_16436((double)tickDelta, (double)this.field_3856, (double)this.field_3871) - vec3d.method_10215());
        if (this.field_3839 == 0.0f) {
            quaternion2 = camera.method_23767();
        } else {
            quaternion2 = new Quaternionf((Quaternionfc)camera.method_23767());
            float i = class_3532.method_16439((float)tickDelta, (float)this.field_3857, (float)this.field_3839);
            quaternion2.rotateZ(i);
        }
        Vector3f Vec3f = new Vector3f(-1.0f, -1.0f, 0.0f);
        Vec3f.rotate((Quaternionfc)quaternion2);
        Vector3f[] Vec3fs = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float j = this.method_18132(tickDelta);
        for (int k = 0; k < 4; ++k) {
            Vector3f Vec3f2 = Vec3fs[k];
            Vec3f2.rotate((Quaternionfc)quaternion2);
            Vec3f2.mul(j);
            Vec3f2.add(f, g, h);
        }
        float minU = this.method_18133();
        float maxU = this.method_18134();
        float minV = this.method_18135();
        float maxV = this.method_18136();
        int l = 0xF000F0;
        float a = Math.min(1.0f, Math.max(0.0f, this.field_3841));
        vertexConsumer.method_22912((double)Vec3fs[0].x(), (double)Vec3fs[0].y(), (double)Vec3fs[0].z()).method_22913(maxU, minV + (maxV - minV) / 2.0f).method_22915(this.field_3861, this.field_3842, this.field_3859, a).method_22916(l).method_1344();
        vertexConsumer.method_22912((double)Vec3fs[1].x(), (double)Vec3fs[1].y(), (double)Vec3fs[1].z()).method_22913(maxU, minV).method_22915(this.field_3861, this.field_3842, this.field_3859, a).method_22916(l).method_1344();
        vertexConsumer.method_22912((double)Vec3fs[2].x(), (double)Vec3fs[2].y(), (double)Vec3fs[2].z()).method_22913(minU, minV).method_22915(this.field_3861, this.field_3842, this.field_3859, a).method_22916(l).method_1344();
        vertexConsumer.method_22912((double)Vec3fs[3].x(), (double)Vec3fs[3].y(), (double)Vec3fs[3].z()).method_22913(minU, minV + (maxV - minV) / 2.0f).method_22915(this.field_3861, this.field_3842, this.field_3859, a).method_22916(l).method_1344();
        vertexConsumer.method_22912((double)Vec3fs[0].x(), (double)Vec3fs[0].y(), (double)Vec3fs[0].z()).method_22913(maxU, maxV).method_22915(1.0f, 1.0f, 1.0f, 0.5f).method_22916(l).method_1344();
        vertexConsumer.method_22912((double)Vec3fs[1].x(), (double)Vec3fs[1].y(), (double)Vec3fs[1].z()).method_22913(maxU, minV + (maxV - minV) / 2.0f).method_22915(1.0f, 1.0f, 1.0f, 0.5f).method_22916(l).method_1344();
        vertexConsumer.method_22912((double)Vec3fs[2].x(), (double)Vec3fs[2].y(), (double)Vec3fs[2].z()).method_22913(minU, minV + (maxV - minV) / 2.0f).method_22915(1.0f, 1.0f, 1.0f, 0.5f).method_22916(l).method_1344();
        vertexConsumer.method_22912((double)Vec3fs[3].x(), (double)Vec3fs[3].y(), (double)Vec3fs[3].z()).method_22913(minU, maxV).method_22915(1.0f, 1.0f, 1.0f, 0.5f).method_22916(l).method_1344();
    }

    public void method_3070() {
        this.field_3858 = this.field_3874;
        this.field_3838 = this.field_3854;
        this.field_3856 = this.field_3871;
        if (!this.field_3851.method_8597().method_29960() && !EffectiveCosmetics.isNightTime((class_1937)this.field_3851) || this.field_3866++ >= this.field_3847) {
            this.nextAlphaGoal = 0.0f;
            if (this.field_3841 <= 0.01f) {
                this.method_3085();
            }
        }
        if (this.field_3841 > this.nextAlphaGoal - 0.05f && this.field_3841 < this.nextAlphaGoal + 0.05f) {
            this.nextAlphaGoal = this.field_3840.method_43057();
        } else if (this.nextAlphaGoal > this.field_3841) {
            this.field_3841 = Math.min(this.field_3841 + 0.05f, 1.0f);
        } else if (this.nextAlphaGoal < this.field_3841) {
            this.field_3841 = Math.max(this.field_3841 - 0.05f, 0.0f);
        }
        this.targetChangeCooldown -= new class_243(this.field_3874, this.field_3854, this.field_3871).method_1028(this.field_3858, this.field_3838, this.field_3856) < 0.0125 ? 10 : 1;
        if (this.field_3851.method_8510() % 20L == 0L && (this.xTarget == 0.0 && this.yTarget == 0.0 && this.zTarget == 0.0 || new class_243(this.field_3874, this.field_3854, this.field_3871).method_1028(this.xTarget, this.yTarget, this.zTarget) < 9.0 || this.targetChangeCooldown <= 0)) {
            this.selectBlockTarget();
        }
        class_243 targetVector = new class_243(this.xTarget - this.field_3874, this.yTarget - this.field_3854, this.zTarget - this.field_3871);
        double length = targetVector.method_1033();
        targetVector = targetVector.method_1021(0.1 / length);
        class_2338 blockPos = class_2338.method_49637((double)this.field_3874, (double)(this.field_3854 - 0.1), (double)this.field_3871);
        if (!LegacyFireflyParticle.canFlyThroughBlock((class_1937)this.field_3851, blockPos, this.field_3851.method_8320(blockPos))) {
            this.field_3852 = 0.9 * this.field_3852 + 0.1 * targetVector.field_1352;
            this.field_3869 = 0.05;
            this.field_3850 = 0.9 * this.field_3850 + 0.1 * targetVector.field_1350;
        } else {
            this.field_3852 = 0.9 * this.field_3852 + 0.1 * targetVector.field_1352;
            this.field_3869 = 0.9 * this.field_3869 + 0.1 * targetVector.field_1351;
            this.field_3850 = 0.9 * this.field_3850 + 0.1 * targetVector.field_1350;
        }
        if (!class_2338.method_49637((double)this.field_3874, (double)this.field_3854, (double)this.field_3871).equals((Object)this.getTargetPosition())) {
            this.method_3069(this.field_3852, this.field_3869, this.field_3850);
        }
    }

    private void selectBlockTarget() {
        if (this.lightTarget == null) {
            double groundLevel = 0.0;
            for (int i = 0; i < 20; ++i) {
                class_2680 checkedBlock;
                class_2338 checkedPos = class_2338.method_49637((double)this.field_3874, (double)(this.field_3854 - (double)i), (double)this.field_3871);
                if (LegacyFireflyParticle.canFlyThroughBlock((class_1937)this.field_3851, checkedPos, checkedBlock = this.field_3851.method_8320(checkedPos))) {
                    groundLevel = this.field_3854 - (double)i;
                }
                if (groundLevel != 0.0) break;
            }
            this.xTarget = this.field_3874 + this.field_3840.method_43059() * 10.0;
            this.yTarget = Math.min(Math.max(this.field_3854 + this.field_3840.method_43059() * 2.0, groundLevel), groundLevel + (double)this.maxHeight);
            this.zTarget = this.field_3871 + this.field_3840.method_43059() * 10.0;
            class_2338 targetPos = class_2338.method_49637((double)this.xTarget, (double)this.yTarget, (double)this.zTarget);
            if (!LegacyFireflyParticle.canFlyThroughBlock((class_1937)this.field_3851, targetPos, this.field_3851.method_8320(targetPos))) {
                this.yTarget += 1.0;
            }
            Objects.requireNonNull(this);
            this.lightTarget = this.getMostLitBlockAround();
        } else {
            this.xTarget = (double)this.lightTarget.method_10263() + this.field_3840.method_43059();
            this.yTarget = (double)this.lightTarget.method_10264() + this.field_3840.method_43059();
            this.zTarget = (double)this.lightTarget.method_10260() + this.field_3840.method_43059();
            this.field_3874 = this.lightTarget.method_10263();
            this.field_3854 = this.lightTarget.method_10264() + 1;
            this.field_3871 = this.lightTarget.method_10260();
            this.lightTarget = this.field_3851.method_8314(class_1944.field_9282, class_2338.method_49637((double)this.field_3874, (double)this.field_3854, (double)this.field_3871)) > 0 && !this.field_3851.method_8530() ? this.getMostLitBlockAround() : null;
        }
        this.targetChangeCooldown = this.field_3840.method_43054() % 100;
    }

    public class_2338 getTargetPosition() {
        return class_2338.method_49637((double)this.xTarget, (double)(this.yTarget + 0.5), (double)this.zTarget);
    }

    private class_2338 getMostLitBlockAround() {
        HashMap<class_2338, Integer> randBlocks = new HashMap<class_2338, Integer>();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    class_2338 bp = class_2338.method_49637((double)(this.field_3874 + (double)x), (double)(this.field_3854 + (double)y), (double)(this.field_3871 + (double)z));
                    randBlocks.put(bp, this.field_3851.method_8314(class_1944.field_9282, bp));
                }
            }
        }
        for (int i = 0; i < 15; ++i) {
            class_2338 randBP = class_2338.method_49637((double)(this.field_3874 + this.field_3840.method_43059() * 10.0), (double)(this.field_3854 + this.field_3840.method_43059() * 10.0), (double)(this.field_3871 + this.field_3840.method_43059() * 10.0));
            randBlocks.put(randBP, this.field_3851.method_8314(class_1944.field_9282, randBP));
        }
        return (class_2338)((Map.Entry)randBlocks.entrySet().stream().max((entry1, entry2) -> (Integer)entry1.getValue() > (Integer)entry2.getValue() ? 1 : -1).get()).getKey();
    }

    @Environment(value=EnvType.CLIENT)
    public static class DefaultFactory
    implements class_707<class_2400> {
        private final class_4002 spriteProvider;

        public DefaultFactory(class_4002 spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        @Nullable
        public class_703 createParticle(class_2400 parameters, class_638 world, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            LegacyFireflyParticle instance = new LegacyFireflyParticle(world, x, y, z, this.spriteProvider);
            if (parameters instanceof LegacyFireflyParticleType) {
                LegacyFireflyParticleType fireflyParameters = (LegacyFireflyParticleType)parameters;
                if (fireflyParameters.initialData != null) {
                    int color = fireflyParameters.initialData.color;
                    float r = (float)(color >> 16 & 0xFF) / 255.0f;
                    float g = (float)(color >> 8 & 0xFF) / 255.0f;
                    float b = (float)(color & 0xFF) / 255.0f;
                    instance.field_3861 = r;
                    instance.field_3842 = g;
                    instance.field_3859 = b;
                }
            }
            return instance;
        }
    }
}

