/*
 * Decompiled with CFR 0.152.
 */
package org.ladysnake.effective.core.world;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1113;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3959;
import net.minecraft.class_3999;
import net.minecraft.class_638;
import org.ladysnake.effective.core.Effective;
import org.ladysnake.effective.core.EffectiveConfig;
import org.ladysnake.effective.core.sound.WaterfallSoundInstance;
import org.ladysnake.effective.core.utils.EffectiveUtils;
import org.ladysnake.effective.core.world.Waterfall;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.render_types.LodestoneWorldParticleRenderType;
import team.lodestar.lodestone.systems.particle.world.type.LodestoneWorldParticleType;

@Environment(value=EnvType.CLIENT)
public class WaterfallCloudGenerators {
    public static final List<Waterfall> generators = new ArrayList<Waterfall>();
    public static final Object2IntMap<Waterfall> particlesToSpawn = new Object2IntOpenHashMap();
    private static class_1937 lastWorld = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addGenerator(class_3610 state, class_2338 pos) {
        if (pos == null || !EffectiveConfig.cascades || state.method_15772() != class_3612.field_15909 || generators.contains(pos)) {
            return;
        }
        Waterfall waterfall = WaterfallCloudGenerators.getWaterfallAt((class_1922)class_310.method_1551().field_1687, pos, state);
        if (waterfall.strength() > 0.0f) {
            List<Waterfall> list = generators;
            synchronized (list) {
                generators.removeIf(waterfallToRemove -> waterfallToRemove.blockPos().equals((Object)pos));
                generators.add(waterfall);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tick() {
        class_310 client = class_310.method_1551();
        class_638 world = client.field_1687;
        if (client.method_1493() || world == null) {
            return;
        }
        List<Waterfall> list = generators;
        synchronized (list) {
            if (world != lastWorld) {
                generators.clear();
                particlesToSpawn.clear();
                lastWorld = world;
            }
            WaterfallCloudGenerators.tickParticles((class_1937)world);
            if (world.method_8510() % 3L != 0L) {
                return;
            }
            generators.forEach(arg_0 -> WaterfallCloudGenerators.lambda$tick$1(client, (class_1937)world, arg_0));
            generators.removeIf(arg_0 -> WaterfallCloudGenerators.lambda$tick$2((class_1937)world, arg_0));
        }
    }

    private static void tickParticles(class_1937 world) {
        for (Waterfall waterfall : particlesToSpawn.keySet()) {
            if (waterfall == null) continue;
            particlesToSpawn.computeInt((Object)waterfall, (blockPos, integer) -> integer - 1);
            WaterfallCloudGenerators.addWaterfallCloud(world, waterfall);
        }
        particlesToSpawn.values().removeIf(integer -> integer < 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Waterfall getWaterfallAt(class_1922 world, class_2338 pos, class_3610 fluidState) {
        Waterfall NO_WATERFALL = new Waterfall(pos, 0.0f, true, new Color(0xFFFFFF));
        boolean isSilent = false;
        Color mistColor = new Color(0xFFFFFF);
        if (!EffectiveConfig.cascades || fluidState.method_15772() != class_3612.field_15909 || world == null) {
            return NO_WATERFALL;
        }
        class_310 client = class_310.method_1551();
        if (Math.sqrt(pos.method_10262((class_2382)client.field_1724.method_24515())) > (double)((Integer)client.field_1690.method_42503().method_41753() * 32)) {
            return NO_WATERFALL;
        }
        class_2338.class_2339 mutable = new class_2338.class_2339();
        if (world.method_8316((class_2338)mutable.method_25504((class_2382)pos, 0, -1, 0)).method_15772() != class_3612.field_15910) return NO_WATERFALL;
        if (world.method_8316((class_2338)mutable.method_25504((class_2382)pos, 0, -2, 0)).method_15772() == class_3612.field_15910) {
            isSilent = false;
        } else {
            if (!world.method_8320((class_2338)mutable.method_25504((class_2382)pos, 0, -2, 0)).method_26164(class_3481.field_15481)) return NO_WATERFALL;
            isSilent = true;
            mistColor = new Color(world.method_8320((class_2338)mutable.method_25504((class_2382)pos, (int)0, (int)-2, (int)0)).method_26205((class_1922)world, (class_2338)pos).field_16011);
        }
        boolean foundAir = false;
        block0: for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                class_2680 blockState;
                if (x == 0 && z == 0 || !(blockState = world.method_8320((class_2338)mutable.method_10103(pos.method_10263() + x, pos.method_10264(), pos.method_10260() + z))).method_26215()) continue;
                foundAir = true;
                continue block0;
            }
        }
        if (!foundAir) {
            return NO_WATERFALL;
        }
        float waterLandingSize = 0.0f;
        for (class_2350 direction : class_2350.values()) {
            if (direction.method_10166() == class_2350.class_2351.field_11052 || world.method_8316((class_2338)mutable.method_10103(pos.method_10263() + direction.method_10148(), pos.method_10264() - 1, pos.method_10260() + direction.method_10165())).method_15772() != class_3612.field_15910) continue;
            waterLandingSize += 1.0f;
        }
        if (!(waterLandingSize >= 1.0f)) return NO_WATERFALL;
        return new Waterfall(pos, fluidState.method_20785() + (waterLandingSize - 2.0f) / 2.0f, isSilent, mistColor);
    }

    public static void addWaterfallCloud(class_1937 world, Waterfall waterfall) {
        boolean isGlowingWater = EffectiveUtils.isGlowingWater(world, waterfall.blockPos());
        Color glowingWaterColor = EffectiveUtils.getGlowingWaterColor(world, waterfall.blockPos());
        Color white = new Color(0xFFFFFF);
        class_2338 blockPos = waterfall.blockPos();
        int i = 0;
        while ((float)i < EffectiveConfig.cascadeCloudDensity) {
            if (waterfall != null) {
                double offsetX = world.method_8409().method_43059() / 5.0;
                double offsetZ = world.method_8409().method_43059() / 5.0;
                WorldParticleBuilder.create((LodestoneWorldParticleType)Effective.WATERFALL_CLOUD).enableForcedSpawn().enableNoClip().setLightLevel(isGlowingWater ? 0xF000F0 : -1).setScaleData(GenericParticleData.create((float)(0.4f + waterfall.strength() * world.field_9229.method_43057())).build()).setColorData(ColorParticleData.create((Color)(isGlowingWater ? glowingWaterColor : white), (Color)(isGlowingWater ? glowingWaterColor : white)).build()).setLifetime(10).setRenderType((class_3999)LodestoneWorldParticleRenderType.TRANSPARENT.withDepthFade()).setMotion((double)(world.method_8409().method_43057() * waterfall.strength() / 10.0f) * Math.signum(offsetX), (double)(world.method_8409().method_43057() * waterfall.strength() / 10.0f), (double)(world.method_8409().method_43057() * waterfall.strength() / 10.0f) * Math.signum(offsetZ)).spawn(world, (double)blockPos.method_10263() + 0.5 + offsetX, (double)((float)blockPos.method_10264() + world.method_8409().method_43057()), (double)blockPos.method_10260() + 0.5 + offsetZ);
            }
            ++i;
        }
        if (EffectiveConfig.cascadeMistDensity > 0.0f && waterfall.strength() >= 1.6f && world.field_9229.method_43057() * 100.0f <= EffectiveConfig.cascadeMistDensity) {
            double offsetX = world.method_8409().method_43059() / 5.0;
            double offsetZ = world.method_8409().method_43059() / 5.0;
            WorldParticleBuilder.create((LodestoneWorldParticleType)Effective.MIST).enableForcedSpawn().setSpinData(SpinParticleData.create((float)((world.field_9229.method_43057() - world.field_9229.method_43057()) / 20.0f)).build()).setScaleData(GenericParticleData.create((float)(10.0f + world.field_9229.method_43057() * 5.0f)).build()).setTransparencyData(GenericParticleData.create((float)0.001f, (float)0.1f, (float)0.0f).setEasing(Easing.EXPO_OUT, Easing.SINE_OUT).build()).setLifetime(300).enableNoClip().setNaturalLighting().setRenderType((class_3999)LodestoneWorldParticleRenderType.TRANSPARENT.withDepthFade()).setColorData(ColorParticleData.create((Color)waterfall.mistColor(), (Color)waterfall.mistColor()).build()).setMotion((double)(world.method_8409().method_43057() / 15.0f) * Math.signum(offsetX), world.method_8409().method_43059() / 25.0, (double)(world.method_8409().method_43057() / 15.0f) * Math.signum(offsetZ)).spawn(world, (double)((float)blockPos.method_10263() + 0.5f), (double)((float)blockPos.method_10264() + 0.5f), (double)((float)blockPos.method_10260() + 0.5f));
        }
    }

    public static void scheduleParticleTick(Waterfall waterfall, int ticks) {
        if (waterfall.blockPos() != null) {
            particlesToSpawn.put((Object)waterfall, ticks);
        }
    }

    public static boolean canSeeWaterfall(class_1937 world, class_2338 waterfallPos, class_1657 player) {
        return world.method_17742(new class_3959(new class_243((double)waterfallPos.method_10263(), (double)waterfallPos.method_10264(), (double)waterfallPos.method_10260()), player.method_5836(class_310.method_1551().method_1488()), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)player)).method_17777().equals((Object)player.method_24515());
    }

    private static /* synthetic */ boolean lambda$tick$2(class_1937 world, Waterfall waterfall) {
        return waterfall == null || WaterfallCloudGenerators.getWaterfallAt((class_1922)world, waterfall.blockPos(), world.method_8316(waterfall.blockPos())).strength() <= 0.0f;
    }

    private static /* synthetic */ void lambda$tick$1(class_310 client, class_1937 world, Waterfall waterfall) {
        if (waterfall == null) {
            return;
        }
        WaterfallCloudGenerators.scheduleParticleTick(waterfall, 6);
        float distance = class_3532.method_15355((float)((float)client.field_1724.method_24515().method_10262((class_2382)waterfall.blockPos())));
        if (waterfall.isSilent() || distance > (float)EffectiveConfig.cascadeSoundDistanceBlocks || EffectiveConfig.cascadeSoundsVolume == 0 || EffectiveConfig.cascadeSoundDistanceBlocks == 0) {
            return;
        }
        if (EffectiveUtils.isInCave(world, waterfall.blockPos()) == EffectiveUtils.isInCave(world, client.field_1724.method_24515()) && world.field_9229.method_43048(200) == 0) {
            client.method_1483().method_4872((class_1113)WaterfallSoundInstance.ambient(Effective.AMBIENCE_WATERFALL, 1.2f + world.field_9229.method_43057() / 10.0f, waterfall.blockPos(), EffectiveConfig.cascadeSoundDistanceBlocks), (int)(distance / 2.0f));
        }
    }
}

