/*
 * Decompiled with CFR 0.152.
 */
package org.ladysnake.effective.core.world;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1536;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3612;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import org.ladysnake.effective.core.Effective;
import org.ladysnake.effective.core.EffectiveConfig;
import org.ladysnake.effective.core.particle.contracts.SplashParticleInitialData;
import org.ladysnake.effective.core.particle.types.SplashParticleType;
import org.ladysnake.effective.core.utils.EffectiveUtils;

@Environment(value=EnvType.CLIENT)
public final class SplashSpawner {
    public static void trySpawnSplash(class_1297 entity) {
        class_1297 topMostEntity;
        class_1297 class_12972 = topMostEntity = entity.method_5782() && entity.method_31483() != null ? entity.method_31483() : entity;
        if (!(topMostEntity instanceof class_1536)) {
            float amplifier = topMostEntity == entity ? 0.2f : 0.9f;
            class_243 impactVelocity = topMostEntity.method_18798();
            if (impactVelocity.method_1033() < (double)EffectiveConfig.splashThreshold) {
                return;
            }
            float splashIntensity = Math.min(1.0f, SplashSpawner.computeSplashIntensity(impactVelocity, amplifier));
            for (int y = -10; y < 10; ++y) {
                if (!SplashSpawner.isValidSplashPosition(entity, y)) continue;
                float splashY = (float)(Math.round(entity.method_23318()) + (long)y) + 0.9f;
                entity.method_37908().method_8486(entity.method_23317(), (double)splashY, entity.method_23321(), topMostEntity instanceof class_1657 ? class_3417.field_14810 : class_3417.field_14737, class_3419.field_15256, splashIntensity * 10.0f, 0.8f, true);
                SplashParticleInitialData data = new SplashParticleInitialData(topMostEntity.method_17681(), impactVelocity.method_10214());
                SplashSpawner.spawnSplash(entity.method_37908(), entity.method_23317(), splashY, entity.method_23321(), data);
                break;
            }
            SplashSpawner.spawnWaterEffects(entity);
        }
    }

    private static float computeSplashIntensity(class_243 impactVelocity, float f) {
        return (float)Math.sqrt(impactVelocity.field_1352 * impactVelocity.field_1352 * (double)0.2f + impactVelocity.field_1351 * impactVelocity.field_1351 + impactVelocity.field_1350 * impactVelocity.field_1350 * (double)0.2f) * f;
    }

    private static void spawnWaterEffects(class_1297 entity) {
        class_5819 random = entity.method_37908().method_8409();
        int j = 0;
        while ((float)j < entity.method_17681() * 25.0f) {
            EffectiveUtils.spawnWaterEffect(entity.method_37908(), new class_243(entity.method_23317() + random.method_43059() * (double)entity.method_17681() / 5.0, entity.method_23318(), entity.method_23321() + random.method_43059() * (double)entity.method_17681()), random.method_43059() / 15.0, random.method_43057() / 2.5f, random.method_43059() / 15.0, EffectiveUtils.WaterEffectType.DROPLET);
            ++j;
        }
    }

    private static boolean isValidSplashPosition(class_1297 entity, int yOffset) {
        class_2338 pos = class_2338.method_49637((double)entity.method_23317(), (double)(Math.round(entity.method_23318()) + (long)yOffset), (double)entity.method_23321());
        class_2680 blockState = entity.method_37908().method_8320(pos);
        if (blockState.method_26227().method_15772() == class_3612.field_15910 && blockState.method_26227().method_15771()) {
            return entity.method_37908().method_8320(pos.method_10084()).method_26215();
        }
        return false;
    }

    private static void spawnSplash(class_1937 world, double x, double y, double z, @Nullable SplashParticleInitialData data) {
        SplashParticleType splash = EffectiveUtils.isGlowingWater(world, class_2338.method_49637((double)x, (double)y, (double)z)) ? Effective.GLOW_SPLASH : Effective.SPLASH;
        world.method_8406(splash.setData(data), x, y, z, 0.0, 0.0, 0.0);
    }
}

