/*
 * Decompiled with CFR 0.152.
 */
package org.ladysnake.effective.core.particle;

import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_4003;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.ladysnake.effective.core.Effective;

@Environment(value=EnvType.CLIENT)
public class ChorusPetalParticle
extends class_4003 {
    private static final Random RANDOM = new Random();
    protected final float rotationFactor;
    private final float groundOffset;
    private boolean isInAir = true;

    public ChorusPetalParticle(class_638 world, double x, double y, double z, double velocityX, double velocityY, double velocityZ, class_4002 spriteProvider) {
        super(world, x, y, z, velocityX, velocityY, velocityZ);
        this.field_17867 *= 1.0f + RANDOM.nextFloat();
        this.field_3847 = 300 + this.field_3840.method_43048(60);
        this.field_3862 = true;
        int variant = RANDOM.nextInt(3);
        this.method_18141(spriteProvider.method_18138(variant, 2));
        if (velocityY == 0.0 && velocityX == 0.0 && velocityZ == 0.0) {
            this.field_3841 = 0.0f;
        }
        this.field_3869 = velocityY - 0.15 - (double)(this.field_3840.method_43057() / 10.0f);
        this.field_3852 = velocityX - 0.05 - (double)(this.field_3840.method_43057() / 10.0f);
        this.field_3850 = velocityZ - 0.05 - (double)(this.field_3840.method_43057() / 10.0f);
        this.rotationFactor = ((float)Math.random() - 0.5f) * 0.01f;
        this.field_3839 = this.field_3840.method_43057() * 360.0f;
        this.groundOffset = RANDOM.nextFloat() / 100.0f + 0.001f;
    }

    public void method_3074(class_4588 vertexConsumer, class_4184 camera, float tickDelta) {
        Quaternionf quaternion2;
        this.field_3861 = Math.max(this.field_3842, 0.3f);
        class_243 vec3d = camera.method_19326();
        float f = (float)(class_3532.method_16436((double)tickDelta, (double)this.field_3858, (double)this.field_3874) - vec3d.method_10216());
        float g = (float)(class_3532.method_16436((double)tickDelta, (double)this.field_3838, (double)this.field_3854) - vec3d.method_10214());
        float h = (float)(class_3532.method_16436((double)tickDelta, (double)this.field_3856, (double)this.field_3871) - vec3d.method_10215());
        float i = 0.0f;
        if (this.field_3839 == 0.0f) {
            quaternion2 = camera.method_23767();
        } else {
            quaternion2 = new Quaternionf((Quaternionfc)camera.method_23767());
            i = class_3532.method_16439((float)tickDelta, (float)this.field_3857, (float)this.field_3839);
            quaternion2.rotateZ(i);
        }
        Vector3f vec3f = new Vector3f(-1.0f, -1.0f, 0.0f);
        vec3f.rotate((Quaternionfc)quaternion2);
        Vector3f[] vector3fs = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float j = this.method_18132(tickDelta);
        if (this.isInAir) {
            for (k = 0; k < 4; ++k) {
                Vec3f2 = vector3fs[k];
                Vec3f2.rotate((Quaternionfc)quaternion2);
                Vec3f2.mul(j);
                Vec3f2.add(f, g, h);
            }
        } else {
            for (k = 0; k < 4; ++k) {
                Vec3f2 = vector3fs[k];
                Vec3f2.rotate((Quaternionfc)new Quaternionf().rotateXYZ((float)Math.toRadians(90.0), 0.0f, (float)Math.toRadians(this.field_3839)));
                Vec3f2.mul(j);
                Vec3f2.add(f, g + this.groundOffset, h);
            }
        }
        float minU = this.method_18133();
        float maxU = this.method_18134();
        float minV = this.method_18135();
        float maxV = this.method_18136();
        int l = 0xF000F0;
        vertexConsumer.method_22912((double)vector3fs[0].x(), (double)vector3fs[0].y(), (double)vector3fs[0].z()).method_22913(maxU, maxV).method_22915(this.field_3861, this.field_3842, this.field_3859, this.field_3841).method_22916(l).method_1344();
        vertexConsumer.method_22912((double)vector3fs[1].x(), (double)vector3fs[1].y(), (double)vector3fs[1].z()).method_22913(maxU, minV).method_22915(this.field_3861, this.field_3842, this.field_3859, this.field_3841).method_22916(l).method_1344();
        vertexConsumer.method_22912((double)vector3fs[2].x(), (double)vector3fs[2].y(), (double)vector3fs[2].z()).method_22913(minU, minV).method_22915(this.field_3861, this.field_3842, this.field_3859, this.field_3841).method_22916(l).method_1344();
        vertexConsumer.method_22912((double)vector3fs[3].x(), (double)vector3fs[3].y(), (double)vector3fs[3].z()).method_22913(minU, maxV).method_22915(this.field_3861, this.field_3842, this.field_3859, this.field_3841).method_22916(l).method_1344();
    }

    public class_3999 method_18122() {
        return class_3999.field_17829;
    }

    public void method_3070() {
        if (this.field_3866++ < this.field_3847) {
            this.field_3841 = Math.min(1.0f, this.field_3841 + 0.1f);
        }
        this.field_3858 = this.field_3874;
        this.field_3838 = this.field_3854;
        this.field_3856 = this.field_3871;
        this.method_3069(this.field_3852, this.field_3869, this.field_3850);
        this.field_3852 *= 0.99;
        this.field_3869 *= 0.99;
        this.field_3850 *= 0.99;
        this.field_3861 = (float)((double)this.field_3861 / 1.001);
        this.field_3842 = (float)((double)this.field_3842 / 1.002);
        if (this.field_3866 >= this.field_3847) {
            this.field_3841 = Math.max(0.0f, this.field_3841 - 0.1f);
            if (this.field_3841 <= 0.0f) {
                this.method_3085();
            }
        }
        this.field_3857 = this.field_3839;
        if ((this.field_3845 || this.field_3851.method_8316(class_2338.method_49637((double)this.field_3874, (double)this.field_3854, (double)this.field_3871)).method_15767(class_3486.field_15517)) && this.isInAir) {
            if (this.field_3851.method_8320(class_2338.method_49637((double)this.field_3874, (double)this.field_3854, (double)this.field_3871)).method_26204() == class_2246.field_10382) {
                for (int i = 0; i > -10; --i) {
                    class_2338 pos = class_2338.method_49637((double)this.field_3874, (double)(Math.round(this.field_3854) + (long)i), (double)this.field_3871);
                    if (this.field_3851.method_8320(pos).method_26204() != class_2246.field_10382 || !this.field_3851.method_8320(class_2338.method_49637((double)this.field_3874, (double)(Math.round(this.field_3854) + (long)i), (double)this.field_3871)).method_26227().method_15771() || !this.field_3851.method_8320(class_2338.method_49637((double)this.field_3874, (double)(Math.round(this.field_3854) + (long)i + 1L), (double)this.field_3871)).method_26215()) continue;
                    this.field_3851.method_8406((class_2394)Effective.RIPPLE, this.field_3874, (double)((float)(Math.round(this.field_3854) + (long)i) + 0.9f), this.field_3871, 0.0, 0.0, 0.0);
                    break;
                }
            }
            this.field_3852 = 0.0;
            this.field_3869 = 0.0;
            this.field_3850 = 0.0;
            this.isInAir = false;
        }
        if (this.field_3869 != 0.0) {
            this.field_3839 = (float)((double)this.field_3839 + Math.PI * Math.sin(this.rotationFactor * (float)this.field_3866) / 2.0);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class DefaultFactory
    implements class_707<class_2400> {
        private final class_4002 spriteProvider;

        public DefaultFactory(class_4002 spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public class_703 createParticle(class_2400 DefaultParticleType, class_638 clientWorld, double d, double e, double f, double g, double h, double i) {
            return new ChorusPetalParticle(clientWorld, d, e, f, g, h, i, this.spriteProvider);
        }
    }
}

