/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.treasure;

import com.google.common.collect.ImmutableSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.treasure.function.EnchantedBook;
import xiroc.dungeoncrawl.dungeon.treasure.function.MaterialBlocks;
import xiroc.dungeoncrawl.dungeon.treasure.function.RandomItem;
import xiroc.dungeoncrawl.dungeon.treasure.function.RandomPotion;
import xiroc.dungeoncrawl.dungeon.treasure.function.Shield;
import xiroc.dungeoncrawl.dungeon.treasure.function.SuspiciousStew;
import xiroc.dungeoncrawl.theme.SecondaryTheme;
import xiroc.dungeoncrawl.theme.Theme;

public interface Loot {
    public static final LootItemFunctionType ENCHANTED_BOOK = Loot.register("enchanted_book", new LootItemFunctionType((Serializer)new EnchantedBook.Serializer()));
    public static final LootItemFunctionType MATERIAL_BLOCKS = Loot.register("material_blocks", new LootItemFunctionType((Serializer)new MaterialBlocks.Serializer()));
    public static final LootItemFunctionType RANDOM_ITEM = Loot.register("random_item", new LootItemFunctionType((Serializer)new RandomItem.Serializer()));
    public static final LootItemFunctionType RANDOM_POTION = Loot.register("random_potion", new LootItemFunctionType((Serializer)new RandomPotion.Serializer()));
    public static final LootItemFunctionType SHIELD = Loot.register("shield", new LootItemFunctionType((Serializer)new Shield.Serializer()));
    public static final LootItemFunctionType SUSPICIOUS_STEW = Loot.register("suspicious_stew", new LootItemFunctionType((Serializer)new SuspiciousStew.Serializer()));
    public static final String LOOT_LEVEL = "loot_level";
    public static final ResourceLocation CHEST_FOOD = DungeonCrawl.locate("chests/food");
    public static final ResourceLocation CHEST_SECRET_ROOM = DungeonCrawl.locate("chests/secret_room");
    public static final ResourceLocation CHEST_SUPPLY = DungeonCrawl.locate("chests/supply");
    public static final ResourceLocation CHEST_TREASURE = DungeonCrawl.locate("chests/treasure");
    public static final ResourceLocation CHEST_STAGE_1 = DungeonCrawl.locate("chests/stage_1");
    public static final ResourceLocation CHEST_STAGE_2 = DungeonCrawl.locate("chests/stage_2");
    public static final ResourceLocation CHEST_STAGE_3 = DungeonCrawl.locate("chests/stage_3");
    public static final ResourceLocation CHEST_STAGE_4 = DungeonCrawl.locate("chests/stage_4");
    public static final ResourceLocation CHEST_STAGE_5 = DungeonCrawl.locate("chests/stage_5");
    public static final ImmutableSet<ResourceLocation> ALL_LOOT_TABLES = ImmutableSet.builder().add((Object)CHEST_FOOD).add((Object)CHEST_SECRET_ROOM).add((Object)CHEST_SUPPLY).add((Object)CHEST_TREASURE).add((Object)CHEST_STAGE_1).add((Object)CHEST_STAGE_2).add((Object)CHEST_STAGE_3).add((Object)CHEST_STAGE_4).add((Object)CHEST_STAGE_5).build();
    public static final ResourceLocation WITHER_SKELETON = DungeonCrawl.locate("monster_overrides/wither_skeleton");

    public static void init() {
    }

    private static LootItemFunctionType register(String name, LootItemFunctionType type) {
        return (LootItemFunctionType)Registry.m_122965_((Registry)BuiltInRegistries.f_256753_, (ResourceLocation)DungeonCrawl.locate(name), (Object)type);
    }

    public static void setLoot(LevelAccessor world, BlockPos pos, RandomizableContainerBlockEntity tile, ResourceLocation lootTable, Theme theme, SecondaryTheme secondaryTheme, RandomSource rand) {
        RandomizableContainerBlockEntity.m_222766_((BlockGetter)world, (RandomSource)rand, (BlockPos)pos, (ResourceLocation)lootTable);
        Loot.setLootInformation(tile.getPersistentData(), theme, secondaryTheme);
    }

    public static ResourceLocation getLootTable(int lootLevel, RandomSource rand) {
        return switch (lootLevel) {
            case 0 -> {
                if ((double)rand.m_188501_() < 0.1) {
                    yield BuiltInLootTables.f_78686_;
                }
                yield CHEST_STAGE_1;
            }
            case 1 -> {
                if ((double)rand.m_188501_() < 0.1) {
                    yield BuiltInLootTables.f_78742_;
                }
                yield CHEST_STAGE_2;
            }
            case 2 -> {
                if ((double)rand.m_188501_() < 0.1) {
                    yield BuiltInLootTables.f_78742_;
                }
                yield CHEST_STAGE_3;
            }
            case 3 -> {
                if ((double)rand.m_188501_() < 0.1) {
                    yield BuiltInLootTables.f_78762_;
                }
                yield CHEST_STAGE_4;
            }
            case 4 -> {
                if ((double)rand.m_188501_() < 0.1) {
                    yield BuiltInLootTables.f_78762_;
                }
                yield CHEST_STAGE_5;
            }
            default -> CHEST_STAGE_5;
        };
    }

    public static void setLootInformation(CompoundTag nbt, Theme theme, SecondaryTheme secondaryTheme) {
        CompoundTag data = new CompoundTag();
        data.m_128359_("theme", theme.getKey().toString());
        data.m_128359_("secondaryTheme", secondaryTheme.getKey().toString());
        nbt.m_128365_("dungeoncrawl", (Tag)data);
    }

    public static Tuple<Theme, SecondaryTheme> getLootInformation(CompoundTag nbt) {
        CompoundTag data = nbt.m_128469_("dungeoncrawl");
        return new Tuple((Object)Theme.getTheme(new ResourceLocation(data.m_128461_("theme"))), (Object)Theme.getSecondaryTheme(new ResourceLocation(data.m_128461_("secondaryTheme"))));
    }
}

