/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.decoration;

import com.google.gson.JsonObject;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.block.provider.BlockStateProvider;
import xiroc.dungeoncrawl.dungeon.decoration.FloorDecoration;
import xiroc.dungeoncrawl.dungeon.decoration.ScatteredDecoration;
import xiroc.dungeoncrawl.dungeon.decoration.VineDecoration;
import xiroc.dungeoncrawl.dungeon.model.DungeonModel;
import xiroc.dungeoncrawl.dungeon.piece.DungeonPiece;
import xiroc.dungeoncrawl.theme.JsonTheming;

public interface DungeonDecoration {
    public static final String VINE_DECORATION = "vines";
    public static final String SCATTERED_DECORATION = "scattered";
    public static final String FLOOR_DECORATION = "floor";
    public static final String FLOOR_NEXT_TO_SOLID_DECORATION = "floor_next_to_solid";

    public void decorate(DungeonModel var1, LevelAccessor var2, BlockPos var3, RandomSource var4, BoundingBox var5, BoundingBox var6, DungeonPiece var7);

    public JsonObject serialize();

    public static DungeonDecoration fromJson(JsonObject object, ResourceLocation file) {
        if (object.has("type")) {
            String type;
            switch (type = object.get("type").getAsString().toLowerCase()) {
                case "vines": {
                    return new VineDecoration(object.has("chance") ? object.get("chance").getAsFloat() : 0.35f);
                }
                case "scattered": {
                    BlockStateProvider blockStateProvider;
                    float chance;
                    float f = chance = object.has("chance") ? object.get("chance").getAsFloat() : 0.25f;
                    if (object.has("block")) {
                        blockStateProvider = JsonTheming.deserialize(object, "block", file);
                        if (blockStateProvider != null) {
                            return new ScatteredDecoration(blockStateProvider, chance);
                        }
                    } else {
                        DungeonCrawl.LOGGER.warn("Missing entry 'block'");
                        return null;
                    }
                }
                case "floor": {
                    BlockStateProvider blockStateProvider;
                    float chance;
                    float f = chance = object.has("chance") ? object.get("chance").getAsFloat() : 0.5f;
                    if (object.has("block")) {
                        blockStateProvider = JsonTheming.deserialize(object, "block", file);
                        if (blockStateProvider != null) {
                            return new FloorDecoration(blockStateProvider, chance);
                        }
                    } else {
                        DungeonCrawl.LOGGER.warn("Missing entry 'block'");
                        return null;
                    }
                }
                case "floor_next_to_solid": {
                    BlockStateProvider blockStateProvider;
                    float chance;
                    float f = chance = object.has("chance") ? object.get("chance").getAsFloat() : 0.5f;
                    if (object.has("block")) {
                        blockStateProvider = JsonTheming.deserialize(object, "block", file);
                        if (blockStateProvider == null) break;
                        return new FloorDecoration.NextToSolid(blockStateProvider, chance);
                    }
                    DungeonCrawl.LOGGER.warn("Missing entry 'block'");
                    return null;
                }
            }
            DungeonCrawl.LOGGER.warn("Unknown decoration type '{}'", (Object)type);
            return null;
        }
        return null;
    }

    public static BlockPos getRotatedBlockPos(int x, int y, int z, BlockPos base, DungeonModel model, Rotation rotation) {
        return switch (rotation) {
            case Rotation.CLOCKWISE_90 -> new BlockPos(base.m_123341_() + model.length - z - 1, base.m_123342_() + y, base.m_123343_() + x);
            case Rotation.CLOCKWISE_180 -> new BlockPos(base.m_123341_() + model.width - x - 1, base.m_123342_() + y, base.m_123343_() + model.length - z - 1);
            case Rotation.COUNTERCLOCKWISE_90 -> new BlockPos(base.m_123341_() + z, base.m_123342_() + y, base.m_123343_() + model.width - x - 1);
            default -> new BlockPos(base.m_123341_() + x, base.m_123342_() + y, base.m_123343_() + z);
        };
    }
}

