/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xiroc.dungeoncrawl.config.Config;
import xiroc.dungeoncrawl.dungeon.treasure.Loot;
import xiroc.dungeoncrawl.init.ModStructurePieceTypes;
import xiroc.dungeoncrawl.init.ModStructureTypes;
import xiroc.dungeoncrawl.util.ResourceReloadHandler;
import xiroc.dungeoncrawl.util.tools.Tools;

@Mod(value="dungeoncrawl")
public class DungeonCrawl {
    public static final String MOD_ID = "dungeoncrawl";
    public static final String NAME = "Dungeon Crawl";
    public static final String VERSION = "2.3.14";
    public static final Logger LOGGER = LogManager.getLogger((String)"Dungeon Crawl");

    public DungeonCrawl() {
        LOGGER.info("Here we go! Launching Dungeon Crawl {}...", (Object)VERSION);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        forgeEventBus.addListener(this::onAddReloadListener);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("Common Setup");
        Config.load(FMLPaths.CONFIGDIR.get().resolve("dungeon_crawl.toml"));
        if (((Boolean)Config.ENABLE_TOOLS.get()).booleanValue()) {
            MinecraftForge.EVENT_BUS.register((Object)new Tools());
        }
        event.enqueueWork(() -> {
            Loot.init();
            ModStructureTypes.register();
            ModStructurePieceTypes.init();
        });
    }

    private void onAddReloadListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new ResourceReloadHandler());
    }

    public static ResourceLocation locate(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    public static ResourceLocation key(ResourceLocation resourceLocation, String baseDirectory, String fileEnding) {
        String path = resourceLocation.m_135815_();
        return new ResourceLocation(resourceLocation.m_135827_(), path.substring(baseDirectory.length() + 1, path.length() - fileEnding.length()));
    }
}

