/*
 * Decompiled with CFR 0.152.
 */
package com.fizzware.dramaticdoors.forge;

import com.fizzware.dramaticdoors.forge.blocks.ShortDoorBlock;
import com.fizzware.dramaticdoors.forge.blocks.ShortWeatheringDoorBlock;
import com.fizzware.dramaticdoors.forge.blocks.TallDoorBlock;
import com.fizzware.dramaticdoors.forge.blocks.TallSlidingDoorBlock;
import com.fizzware.dramaticdoors.forge.blocks.TallStableDoorBlock;
import com.fizzware.dramaticdoors.forge.blocks.TallWeatheringDoorBlock;
import com.fizzware.dramaticdoors.forge.compat.Compats;
import com.fizzware.dramaticdoors.forge.items.ShortDoorItem;
import com.fizzware.dramaticdoors.forge.items.TallDoorItem;
import com.fizzware.dramaticdoors.forge.state.properties.SlidingDoorType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import org.jetbrains.annotations.Nullable;
import oshi.util.tuples.Pair;

public class DDRegistry {
    public static final List<Pair<String, Block>> DOOR_BLOCKS_TO_REGISTER = new ArrayList<Pair<String, Block>>();
    public static final List<Pair<String, Item>> DOOR_ITEMS_TO_REGISTER = new ArrayList<Pair<String, Item>>();
    public static final Item.Properties PROPERTIES = new Item.Properties();
    public static final ResourceKey<CreativeModeTab> MAIN_TAB = ResourceKey.m_135785_((ResourceKey)Registries.f_279569_, (ResourceLocation)new ResourceLocation("dramaticdoors", "main_tab"));
    public static final ResourceKey<CreativeModeTab> CHIPPED_TAB = ResourceKey.m_135785_((ResourceKey)Registries.f_279569_, (ResourceLocation)new ResourceLocation("dramaticdoors", "chipped_tab"));
    public static final ResourceKey<CreativeModeTab> MACAW_TAB = ResourceKey.m_135785_((ResourceKey)Registries.f_279569_, (ResourceLocation)new ResourceLocation("dramaticdoors", "macaw_tab"));
    public static final ResourceKey<CreativeModeTab> MANYIDEAS_TAB = ResourceKey.m_135785_((ResourceKey)Registries.f_279569_, (ResourceLocation)new ResourceLocation("dramaticdoors", "manyideas_tab"));

    public static void registerVanilla() {
        if (Compats.IMMERSIVE_WEATHERING_INSTALLED) {
            ShortWeatheringDoorBlock shortIronDoor = new ShortWeatheringDoorBlock(Blocks.f_50166_, BlockSetType.f_271132_, WeatheringCopper.WeatherState.UNAFFECTED);
            TallWeatheringDoorBlock tallIronDoor = new TallWeatheringDoorBlock(Blocks.f_50166_, BlockSetType.f_271132_, WeatheringCopper.WeatherState.UNAFFECTED);
            DOOR_BLOCKS_TO_REGISTER.add((Pair<String, Block>)new Pair((Object)"short_iron_door", (Object)shortIronDoor));
            DOOR_BLOCKS_TO_REGISTER.add((Pair<String, Block>)new Pair((Object)"tall_iron_door", (Object)tallIronDoor));
            DOOR_ITEMS_TO_REGISTER.add((Pair<String, Item>)new Pair((Object)"short_iron_door", (Object)new ShortDoorItem(shortIronDoor, PROPERTIES)));
            DOOR_ITEMS_TO_REGISTER.add((Pair<String, Item>)new Pair((Object)"tall_iron_door", (Object)new TallDoorItem(tallIronDoor, PROPERTIES)));
        } else {
            DDRegistry.registerDoorBlockAndItem("tall_iron_door", "short_iron_door", Blocks.f_50166_, BlockSetType.f_271132_, true);
        }
        DDRegistry.registerDoorBlockAndItem("tall_oak_door", "short_oak_door", Blocks.f_50154_, BlockSetType.f_271198_, true);
        DDRegistry.registerDoorBlockAndItem("tall_spruce_door", "short_spruce_door", Blocks.f_50484_, BlockSetType.f_271100_, true);
        DDRegistry.registerDoorBlockAndItem("tall_birch_door", "short_birch_door", Blocks.f_50485_, BlockSetType.f_271387_, true);
        DDRegistry.registerDoorBlockAndItem("tall_jungle_door", "short_jungle_door", Blocks.f_50486_, BlockSetType.f_271187_, true);
        DDRegistry.registerDoorBlockAndItem("tall_acacia_door", "short_acacia_door", Blocks.f_50487_, BlockSetType.f_271512_, true);
        DDRegistry.registerDoorBlockAndItem("tall_dark_oak_door", "short_dark_oak_door", Blocks.f_50488_, BlockSetType.f_271528_, true);
        DDRegistry.registerDoorBlockAndItem("tall_mangrove_door", "short_mangrove_door", Blocks.f_220853_, BlockSetType.f_271383_, true);
        DDRegistry.registerDoorBlockAndItem("tall_cherry_door", "short_cherry_door", Blocks.f_271169_, BlockSetType.f_271401_, true);
        DDRegistry.registerDoorBlockAndItem("tall_bamboo_door", "short_bamboo_door", Blocks.f_244648_, BlockSetType.f_271088_, true);
        DDRegistry.registerDoorBlockAndItem("tall_crimson_door", "short_crimson_door", Blocks.f_50671_, BlockSetType.f_271290_, true);
        DDRegistry.registerDoorBlockAndItem("tall_warped_door", "short_warped_door", Blocks.f_50672_, BlockSetType.f_271400_, true);
    }

    public static void registerDoorBlockAndItem(String tallname, @Nullable String shortname, Block block, BlockSetType blocksettype, boolean includeShort) {
        Item tempItem;
        Block tempBlock;
        if (includeShort) {
            tempBlock = DDRegistry.createDoorBlock(block, blocksettype, false);
            tempItem = DDRegistry.createDoorItem(tempBlock, false);
            DOOR_BLOCKS_TO_REGISTER.add((Pair<String, Block>)new Pair((Object)shortname, (Object)tempBlock));
            DOOR_ITEMS_TO_REGISTER.add((Pair<String, Item>)new Pair((Object)shortname, (Object)tempItem));
        }
        tempBlock = DDRegistry.createDoorBlock(block, blocksettype, true);
        tempItem = DDRegistry.createDoorItem(tempBlock, true);
        DOOR_BLOCKS_TO_REGISTER.add((Pair<String, Block>)new Pair((Object)tallname, (Object)tempBlock));
        DOOR_ITEMS_TO_REGISTER.add((Pair<String, Item>)new Pair((Object)tallname, (Object)tempItem));
    }

    public static void registerDoorBlockAndItem(String tallname, @Nullable String shortname, BlockBehaviour.Properties properties, BlockSetType blocksettype, boolean includeShort) {
        Item tempItem;
        Block tempBlock;
        if (includeShort) {
            tempBlock = DDRegistry.createDoorBlock(properties, blocksettype, false);
            tempItem = DDRegistry.createDoorItem(tempBlock, false);
            DOOR_BLOCKS_TO_REGISTER.add((Pair<String, Block>)new Pair((Object)shortname, (Object)tempBlock));
            DOOR_ITEMS_TO_REGISTER.add((Pair<String, Item>)new Pair((Object)shortname, (Object)tempItem));
        }
        tempBlock = DDRegistry.createDoorBlock(properties, blocksettype, true);
        tempItem = DDRegistry.createDoorItem(tempBlock, true);
        DOOR_BLOCKS_TO_REGISTER.add((Pair<String, Block>)new Pair((Object)tallname, (Object)tempBlock));
        DOOR_ITEMS_TO_REGISTER.add((Pair<String, Item>)new Pair((Object)tallname, (Object)tempItem));
    }

    public static void registerSlidingDoorBlockAndItem(String tallname, @Nullable String shortname, Block block, BlockSetType blocksettype, boolean includeShort) {
        DDRegistry.registerSlidingDoorBlockAndItem(tallname, shortname, block, blocksettype, includeShort, SlidingDoorType.MACAW);
    }

    public static void registerSlidingDoorBlockAndItem(String tallname, @Nullable String shortname, Block block, BlockSetType blocksettype, boolean includeShort, SlidingDoorType type) {
        Item tempItem;
        Block tempBlock;
        if (includeShort) {
            tempBlock = DDRegistry.createSlidingDoorBlock(block, blocksettype, false, type);
            tempItem = DDRegistry.createDoorItem(tempBlock, false);
            DOOR_BLOCKS_TO_REGISTER.add((Pair<String, Block>)new Pair((Object)shortname, (Object)tempBlock));
            DOOR_ITEMS_TO_REGISTER.add((Pair<String, Item>)new Pair((Object)shortname, (Object)tempItem));
        }
        tempBlock = DDRegistry.createSlidingDoorBlock(block, blocksettype, true, type);
        tempItem = DDRegistry.createDoorItem(tempBlock, true);
        DOOR_BLOCKS_TO_REGISTER.add((Pair<String, Block>)new Pair((Object)tallname, (Object)tempBlock));
        DOOR_ITEMS_TO_REGISTER.add((Pair<String, Item>)new Pair((Object)tallname, (Object)tempItem));
    }

    public static void registerStableDoorBlockAndItem(String tallname, @Nullable String shortname, Block block, BlockSetType blocksettype, boolean includeShort) {
        Block tempBlock = DDRegistry.createStableDoorBlock(block, blocksettype, true);
        Item tempItem = DDRegistry.createDoorItem(tempBlock, true);
        DOOR_BLOCKS_TO_REGISTER.add((Pair<String, Block>)new Pair((Object)tallname, (Object)tempBlock));
        DOOR_ITEMS_TO_REGISTER.add((Pair<String, Item>)new Pair((Object)tallname, (Object)tempItem));
        if (includeShort) {
            tempBlock = DDRegistry.createStableDoorBlock(block, blocksettype, false);
            tempItem = DDRegistry.createDoorItem(tempBlock, false);
            DOOR_BLOCKS_TO_REGISTER.add((Pair<String, Block>)new Pair((Object)shortname, (Object)tempBlock));
            DOOR_ITEMS_TO_REGISTER.add((Pair<String, Item>)new Pair((Object)shortname, (Object)tempItem));
        }
    }

    protected static Block createDoorBlock(Block block, BlockSetType blocksettype, boolean isTall) {
        return isTall ? new TallDoorBlock(block, blocksettype) : new ShortDoorBlock(block, blocksettype);
    }

    protected static Block createDoorBlock(BlockBehaviour.Properties properties, BlockSetType blocksettype, boolean isTall) {
        return isTall ? new TallDoorBlock(properties, blocksettype) : new ShortDoorBlock(properties, blocksettype);
    }

    protected static Item createDoorItem(Block block, boolean isTall) {
        return isTall ? new TallDoorItem(block, PROPERTIES) : new ShortDoorItem(block, PROPERTIES);
    }

    protected static Block createSlidingDoorBlock(Block block, BlockSetType blocksettype, boolean isTall, SlidingDoorType type) {
        if (!isTall) {
            throw new IllegalArgumentException("Short version of Macaw sliding doors are currently not supported.");
        }
        return isTall ? new TallSlidingDoorBlock(block, blocksettype, type) : null;
    }

    protected static Block createStableDoorBlock(Block block, BlockSetType blocksettype, boolean isTall) {
        if (!isTall) {
            throw new IllegalArgumentException("Short version of Macaw stable doors are currently not supported.");
        }
        return isTall ? new TallStableDoorBlock(block, blocksettype) : null;
    }

    public static Block getBlockByKey(ResourceLocation loc) {
        return DDRegistry.getBlockByKey(loc, Blocks.f_50154_);
    }

    public static Block getBlockByKey(ResourceLocation loc, Block fallback) {
        return BuiltInRegistries.f_256975_.m_7804_(loc) ? (Block)BuiltInRegistries.f_256975_.m_7745_(loc) : fallback;
    }

    public static Block getBlockFromResourceLocation(ResourceLocation resource) {
        return DDRegistry.getBlockFromResourceLocation(resource, Blocks.f_50154_);
    }

    public static Block getBlockFromResourceLocation(ResourceLocation resource, Block fallback) {
        return BuiltInRegistries.f_256975_.m_6612_(resource).orElse(fallback);
    }
}

