/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.doubledoors_common_forge.events;

import com.natamus.collective_common_forge.functions.BlockFunctions;
import com.natamus.collective_common_forge.functions.BlockPosFunctions;
import com.natamus.doubledoors_common_forge.util.Util;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.WeightedPressurePlateBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class DoorEvent {
    private static final List<BlockPos> prevpoweredpos = new ArrayList<BlockPos>();
    private static final HashMap<BlockPos, Integer> prevbuttonpos = new HashMap();

    public static void onNeighbourNotice(Level level, BlockPos blockPos, BlockState blockState, EnumSet<Direction> notifiedSides, boolean forceRedstoneUpdate) {
        BlockState oBlockState;
        if (level.f_46443_) {
            return;
        }
        BooleanProperty isPoweredProperty = BlockStateProperties.f_61448_;
        IntegerProperty weightPowerProperty = BlockStateProperties.f_61426_;
        Block block = blockState.m_60734_();
        if (!(block instanceof PressurePlateBlock) && !(block instanceof WeightedPressurePlateBlock)) {
            if (!(block instanceof ButtonBlock) && !(block instanceof LeverBlock)) {
                return;
            }
            if (!prevbuttonpos.containsKey(blockPos)) {
                prevbuttonpos.put(blockPos.m_7949_(), 1);
                return;
            }
            prevbuttonpos.remove(blockPos);
            if (!((Boolean)blockState.m_61143_((Property)isPoweredProperty)).booleanValue()) {
                if (!prevpoweredpos.contains(blockPos)) {
                    return;
                }
                prevpoweredpos.remove(blockPos);
            }
        } else if (block instanceof WeightedPressurePlateBlock ? (Integer)blockState.m_61143_((Property)weightPowerProperty) == 0 && !prevpoweredpos.contains(blockPos) : (Boolean)blockState.m_61143_((Property)isPoweredProperty) == false && !prevpoweredpos.contains(blockPos)) {
            return;
        }
        boolean blockStateprop = block instanceof WeightedPressurePlateBlock ? (Integer)blockState.m_61143_((Property)weightPowerProperty) > 0 : (Boolean)blockState.m_61143_((Property)isPoweredProperty);
        int radius = 1;
        BlockPos doorBlockPos = null;
        for (BlockPos aroundPos : BlockPosFunctions.getBlocksAround((BlockPos)blockPos, (boolean)false)) {
            oBlockState = level.m_8055_(aroundPos);
            if (!Util.isDoorBlock(oBlockState)) continue;
            doorBlockPos = aroundPos.m_7949_();
            break;
        }
        if (doorBlockPos == null) {
            for (BlockPos aroundPos : BlockPos.m_121976_((int)(blockPos.m_123341_() - radius), (int)(blockPos.m_123342_() - 1), (int)(blockPos.m_123343_() - radius), (int)(blockPos.m_123341_() + radius), (int)(blockPos.m_123342_() + 1), (int)(blockPos.m_123343_() + radius))) {
                oBlockState = level.m_8055_(aroundPos);
                if (!Util.isDoorBlock(oBlockState)) continue;
                doorBlockPos = aroundPos;
                break;
            }
        }
        if (doorBlockPos != null && Util.processDoor(null, level, doorBlockPos, level.m_8055_(doorBlockPos), blockStateprop) && blockStateprop) {
            prevpoweredpos.add(blockPos.m_7949_());
        }
    }

    public static void onDoorClick(Level level, Player player, InteractionHand interactionHand, BlockPos blockPos, BlockHitResult blockHitResult) {
        if (level.f_46443_) {
            return;
        }
        if (!interactionHand.equals((Object)InteractionHand.MAIN_HAND)) {
            return;
        }
        if (player.m_6047_()) {
            return;
        }
        BlockState clickState = level.m_8055_(blockPos);
        if (!Util.isDoorBlock(clickState)) {
            return;
        }
        if (!BlockFunctions.canOpenByHand((BlockState)clickState)) {
            return;
        }
        Util.processDoor(player, level, blockPos, clickState, null);
    }
}

