/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.world.pocket.type.addon;

import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_7134;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.world.pocket.type.Pocket;
import org.dimdev.dimdoors.world.pocket.type.addon.AddonProvider;
import org.dimdev.dimdoors.world.pocket.type.addon.AutoSyncedAddon;
import org.dimdev.dimdoors.world.pocket.type.addon.PocketAddon;

public class SkyAddon
implements AutoSyncedAddon {
    public static class_2960 ID = DimensionalDoors.id("sky");
    private class_2960 effect;
    private long dayTime = 6000L;
    private byte moonPhase;

    public boolean setEfffect(class_2960 effect) {
        this.effect = effect;
        return true;
    }

    public void setDayTime(long dayTime) {
        this.dayTime = dayTime;
    }

    public void setMoonPhase(byte moonPhase) {
        this.moonPhase = moonPhase;
    }

    @Override
    public PocketAddon fromNbt(class_2487 nbt) {
        Object tag = null;
        this.effect = !nbt.method_10545("effect") && nbt.method_10545("world") ? class_2960.method_12829((String)nbt.method_10558("world")) : (nbt.method_10545("effect") ? class_2960.method_12829((String)nbt.method_10558("effect")) : null);
        this.dayTime = nbt.method_10545("dayTime") ? nbt.method_10537("dayTime") : 12000L;
        this.moonPhase = nbt.method_10545("moonPhase") ? nbt.method_10571("moonPhase") : (byte)0;
        return this;
    }

    @Override
    public class_2487 toNbt(class_2487 nbt) {
        AutoSyncedAddon.super.toNbt(nbt);
        nbt.method_10582("effect", this.effect.toString());
        nbt.method_10544("dayTime", this.dayTime);
        nbt.method_10567("moonPhase", this.moonPhase);
        return nbt;
    }

    @Override
    public PocketAddon.PocketAddonType<? extends PocketAddon> getType() {
        return (PocketAddon.PocketAddonType)PocketAddon.PocketAddonType.SKY_ADDON.get();
    }

    @Override
    public class_2960 getId() {
        return ID;
    }

    public class_2960 getEffect() {
        return this.effect;
    }

    @Override
    public AutoSyncedAddon read(class_2540 buf) {
        this.effect = buf.method_10810();
        this.dayTime = buf.readLong();
        this.moonPhase = buf.readByte();
        return this;
    }

    @Override
    public class_2540 write(class_2540 buf) {
        buf.method_10812(this.effect);
        buf.writeLong(this.dayTime);
        buf.writeByte((int)this.moonPhase);
        return buf;
    }

    public static float timeOfDay(long dayTime) {
        double d = class_3532.method_15385((double)((double)dayTime / 24000.0 - 0.25));
        double e = 0.5 - Math.cos(d * Math.PI) / 2.0;
        return (float)(d * 2.0 + e) / 3.0f;
    }

    public float getSunAngle() {
        float f = this.getTimeOfDay();
        return f * ((float)Math.PI * 2);
    }

    public float getTimeOfDay() {
        return SkyAddon.timeOfDay(this.getDayTime());
    }

    private long getDayTime() {
        return this.dayTime;
    }

    public int getMoonPhase() {
        return this.moonPhase % 8;
    }

    public float getStarBrightness() {
        float f = this.getTimeOfDay();
        float g = 1.0f - (class_3532.method_15362((float)(f * ((float)Math.PI * 2))) * 2.0f + 0.25f);
        g = class_3532.method_15363((float)g, (float)0.0f, (float)1.0f);
        return g * g * 0.5f;
    }

    public static interface SkyPocket
    extends AddonProvider {
        default public boolean sky(class_2960 effect) {
            this.ensureIsPocket();
            if (!this.hasAddon(ID)) {
                SkyAddon addon = new SkyAddon();
                this.addAddon(addon);
                return addon.setEfffect(effect);
            }
            return ((SkyAddon)this.getAddon(ID)).setEfffect(effect);
        }
    }

    public static class SkyBuilderAddon
    implements PocketAddon.PocketBuilderAddon<SkyAddon> {
        private class_2960 effect = class_7134.field_37670;
        private long dayTime = 12000L;
        private byte moonPhase = 0;

        @Override
        public void apply(Pocket pocket) {
            SkyAddon addon = new SkyAddon();
            addon.effect = this.effect;
            addon.dayTime = this.dayTime;
            addon.moonPhase = this.moonPhase;
            pocket.addAddon(addon);
        }

        @Override
        public class_2960 getId() {
            return ID;
        }

        @Override
        public PocketAddon.PocketBuilderAddon<SkyAddon> fromNbt(class_2487 nbt) {
            this.effect = class_2960.method_12829((String)nbt.method_10558("effect"));
            this.dayTime = nbt.method_10537("dayTime");
            this.moonPhase = nbt.method_10571("moonPhase");
            return this;
        }

        @Override
        public class_2487 toNbt(class_2487 nbt) {
            PocketAddon.PocketBuilderAddon.super.toNbt(nbt);
            nbt.method_10582("effect", this.effect.toString());
            nbt.method_10544("dayTime", this.dayTime);
            nbt.method_10567("moonPhase", this.moonPhase);
            return nbt;
        }

        @Override
        public PocketAddon.PocketAddonType<SkyAddon> getType() {
            return (PocketAddon.PocketAddonType)PocketAddon.PocketAddonType.SKY_ADDON.get();
        }
    }

    public static interface SkyPocketBuilder<T extends Pocket.PocketBuilder<T, ?>>
    extends PocketAddon.PocketBuilderExtension<T> {
        default public T dimenionType(class_2960 effect) {
            ((SkyBuilderAddon)this.getAddon((class_2960)SkyAddon.ID)).effect = effect;
            return this.getSelf();
        }

        default public T dayTime(long dayTime) {
            ((SkyBuilderAddon)this.getAddon((class_2960)SkyAddon.ID)).dayTime = dayTime;
            return this.getSelf();
        }

        default public T moonPhase(byte moonPhase) {
            ((SkyBuilderAddon)this.getAddon((class_2960)SkyAddon.ID)).moonPhase = moonPhase;
            return this.getSelf();
        }
    }
}

