/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.world.pocket.type;

import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrarManager;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1937;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.world.pocket.PocketDirectory;
import org.dimdev.dimdoors.world.pocket.type.IdReferencePocket;
import org.dimdev.dimdoors.world.pocket.type.LazyGenerationPocket;
import org.dimdev.dimdoors.world.pocket.type.Pocket;
import org.dimdev.dimdoors.world.pocket.type.PrivatePocket;

public abstract class AbstractPocket<V extends AbstractPocket<?>> {
    public static final Registrar<AbstractPocketType<? extends AbstractPocket<?>>> REGISTRY = RegistrarManager.get((String)"dimdoors").builder(DimensionalDoors.id("abstract_pocket_type"), (Object[])new AbstractPocketType[0]).build();
    protected Integer id;
    protected class_5321<class_1937> world;

    public AbstractPocket(int id, class_5321<class_1937> world) {
        this.id = id;
        this.world = world;
    }

    protected AbstractPocket() {
    }

    public int getId() {
        return this.id;
    }

    public static AbstractPocket<? extends AbstractPocket<?>> deserialize(class_2487 nbt) {
        class_2960 id = class_2960.method_12829((String)nbt.method_10558("type"));
        return ((AbstractPocketType)REGISTRY.get(id)).fromNbt(nbt);
    }

    public static AbstractPocketBuilder<?, ?> deserializeBuilder(class_2487 nbt) {
        class_2960 id = class_2960.method_12829((String)nbt.method_10558("type"));
        return ((AbstractPocketType)REGISTRY.get(id)).builder().fromNbt(nbt);
    }

    public static class_2487 serialize(AbstractPocket<?> pocket) {
        return pocket.toNbt(new class_2487());
    }

    public V fromNbt(class_2487 nbt) {
        this.id = nbt.method_10550("id");
        this.world = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960(nbt.method_10558("world")));
        return (V)this;
    }

    public class_2487 toNbt(class_2487 nbt) {
        nbt.method_10569("id", this.id.intValue());
        nbt.method_10582("world", this.world.method_29177().toString());
        this.getType().toNbt(nbt);
        return nbt;
    }

    public abstract AbstractPocketType<?> getType();

    public Map<String, Double> toVariableMap(Map<String, Double> variableMap) {
        variableMap.put("id", (double)this.id);
        return variableMap;
    }

    public abstract Pocket getReferencedPocket();

    public Pocket getReferencedPocket(PocketDirectory directory) {
        return this.getReferencedPocket();
    }

    public class_5321<class_1937> getWorld() {
        return this.world;
    }

    public static interface AbstractPocketType<T extends AbstractPocket<?>> {
        public static final RegistrySupplier<AbstractPocketType<IdReferencePocket>> ID_REFERENCE = AbstractPocketType.register(DimensionalDoors.id(IdReferencePocket.KEY), IdReferencePocket::new, IdReferencePocket::builder);
        public static final RegistrySupplier<AbstractPocketType<Pocket>> POCKET = AbstractPocketType.register(DimensionalDoors.id(Pocket.KEY), Pocket::new, Pocket::builder);
        public static final RegistrySupplier<AbstractPocketType<PrivatePocket>> PRIVATE_POCKET = AbstractPocketType.register(DimensionalDoors.id(PrivatePocket.KEY), PrivatePocket::new, PrivatePocket::builderPrivatePocket);
        public static final RegistrySupplier<AbstractPocketType<LazyGenerationPocket>> LAZY_GENERATION_POCKET = AbstractPocketType.register(DimensionalDoors.id(LazyGenerationPocket.KEY), LazyGenerationPocket::new, LazyGenerationPocket::builderLazyGenerationPocket);

        public T fromNbt(class_2487 var1);

        public class_2487 toNbt(class_2487 var1);

        public T instance();

        public AbstractPocketBuilder<?, T> builder();

        public static void register() {
        }

        public static <U extends AbstractPocket<P>, P extends AbstractPocket<P>> RegistrySupplier<AbstractPocketType<U>> register(final class_2960 id, final Supplier<U> supplier, final Supplier<? extends AbstractPocketBuilder<?, U>> factorySupplier) {
            return REGISTRY.register(id, () -> new AbstractPocketType<U>(){

                @Override
                public U fromNbt(class_2487 nbt) {
                    return ((AbstractPocket)supplier.get()).fromNbt(nbt);
                }

                @Override
                public class_2487 toNbt(class_2487 nbt) {
                    nbt.method_10582("type", id.toString());
                    return nbt;
                }

                @Override
                public U instance() {
                    return (AbstractPocket)supplier.get();
                }

                @Override
                public AbstractPocketBuilder<?, U> builder() {
                    return (AbstractPocketBuilder)factorySupplier.get();
                }
            });
        }
    }

    public static abstract class AbstractPocketBuilder<P extends AbstractPocketBuilder<P, T>, T extends AbstractPocket<?>> {
        protected final AbstractPocketType<T> type;
        private int id;
        private class_5321<class_1937> world;

        protected AbstractPocketBuilder(AbstractPocketType<T> type) {
            this.type = type;
        }

        public class_2382 getExpectedSize() {
            return new class_2382(1, 1, 1);
        }

        public T build() {
            T instance = this.type.instance();
            ((AbstractPocket)instance).id = this.id;
            ((AbstractPocket)instance).world = this.world;
            return instance;
        }

        public P id(int id) {
            this.id = id;
            return this.getSelf();
        }

        public P world(class_5321<class_1937> world) {
            this.world = world;
            return this.getSelf();
        }

        public P getSelf() {
            return (P)this;
        }

        public abstract P fromNbt(class_2487 var1);

        public abstract class_2487 toNbt(class_2487 var1);
    }
}

